/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.assignor;

import io.confluent.kafka.multitenant.assignor.RackMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClusterMetadata
implements RackMetadata {
    private static final Logger log = LoggerFactory.getLogger(ClusterMetadata.class);
    private final String tenant;
    private final Cluster cluster;
    private final Map<Integer, NodeMetadata> nodeMetadatas;
    private boolean rackAware;
    private boolean cellAware;
    private final Set<Integer> eligibleBrokers;
    private final Set<Integer> excludedBrokerIds;
    private final Map<Integer, String> brokerRackMap;
    private final Map<Integer, String> brokerCellMap;
    private final Map<String, Set<Integer>> cellEligibleBrokerMap;

    ClusterMetadata(String tenant, Cluster cluster, Set<Integer> excludedBrokerIds) {
        this.cluster = cluster;
        this.tenant = tenant;
        this.nodeMetadatas = this.nodeMetadata();
        this.rackAware = true;
        this.cellAware = true;
        this.eligibleBrokers = new HashSet<Integer>();
        this.excludedBrokerIds = new HashSet<Integer>(excludedBrokerIds);
        this.brokerRackMap = new HashMap<Integer, String>();
        this.brokerCellMap = new HashMap<Integer, String>();
        this.cellEligibleBrokerMap = new HashMap<String, Set<Integer>>();
        for (Node node : cluster.nodes()) {
            if (!excludedBrokerIds.contains(node.id())) {
                this.eligibleBrokers.add(node.id());
            }
            String rack = node.rack();
            boolean bl = this.rackAware = this.rackAware && rack != null;
            if (this.rackAware) {
                this.brokerRackMap.put(node.id(), rack);
            }
            String cell = ConfigUtils.cell((Node)node);
            boolean bl2 = this.cellAware = this.cellAware && cell != null;
            if (!this.cellAware) continue;
            this.brokerCellMap.put(node.id(), cell);
            if (excludedBrokerIds.contains(node.id())) continue;
            this.cellEligibleBrokerMap.computeIfAbsent(cell, c -> new HashSet()).add(node.id());
        }
        if (!this.rackAware) {
            this.brokerRackMap.clear();
        }
        if (!this.cellAware) {
            this.brokerCellMap.clear();
            this.cellEligibleBrokerMap.clear();
        }
    }

    public Set<Integer> excludedBrokerIds() {
        return new HashSet<Integer>(this.excludedBrokerIds);
    }

    @Override
    public String rackForBroker(int brokerId) {
        return this.brokerRackMap.get(brokerId);
    }

    public String cellForBroker(int brokerId) {
        return this.brokerCellMap.get(brokerId);
    }

    Set<Integer> eligibleBrokers() {
        return this.eligibleBrokers;
    }

    Set<Integer> eligibleBrokersFromCell(String cellId) {
        return this.cellEligibleBrokerMap.get(cellId);
    }

    boolean isBrokerEligibleForReplicaPlacement(int brokerId) {
        return this.eligibleBrokers.contains(brokerId);
    }

    boolean rackAware() {
        return this.rackAware;
    }

    boolean cellAware() {
        return this.cellAware;
    }

    boolean brokersInSameCell(Integer brokerA, Integer brokerB) {
        if (this.cellAware) {
            return this.brokerCellMap.get(brokerA).equals(this.brokerCellMap.get(brokerB));
        }
        return true;
    }

    NodeReplicaCounter nodeReplicaCounts(List<PartitionInfo> existingPartitions) {
        HashMap<Integer, ReplicaCounts> leaderCount = new HashMap<Integer, ReplicaCounts>(this.nodeMetadatas.size());
        HashMap<Integer, ReplicaCounts> followerCount = new HashMap<Integer, ReplicaCounts>(this.nodeMetadatas.size());
        for (Boolean leader : Arrays.asList(false, true)) {
            HashMap<Integer, ReplicaCounts> nodeReplicaCounts = leader != false ? leaderCount : followerCount;
            for (Map.Entry<Integer, NodeMetadata> entry : this.nodeMetadatas.entrySet()) {
                Integer nodeId = entry.getKey();
                NodeMetadata nodeMetadata = entry.getValue();
                int tenantCount = leader != false ? nodeMetadata.tenantLeaders : nodeMetadata.tenantFollowers;
                int totalCount = leader != false ? nodeMetadata.totalLeaders : nodeMetadata.totalFollowers;
                ReplicaCounts replicaCounts = new ReplicaCounts(tenantCount, totalCount);
                nodeReplicaCounts.put(nodeId, replicaCounts);
            }
            for (PartitionInfo partitionInfo : existingPartitions) {
                Node[] replicas = partitionInfo.replicas();
                for (int i = 0; i < replicas.length; ++i) {
                    ReplicaCounts replicaCounts;
                    Node node = replicas[i];
                    ReplicaCounts replicaCounts2 = replicaCounts = node == null ? null : (ReplicaCounts)nodeReplicaCounts.get(node.id());
                    if (replicaCounts == null) {
                        throw new IllegalStateException("Inconsistent cluster metadata, broker not found");
                    }
                    if ((i != 0 || !leader.booleanValue()) && (i == 0 || leader.booleanValue())) continue;
                    ++replicaCounts.topic;
                }
            }
        }
        return new NodeReplicaCounter(leaderCount, followerCount);
    }

    void updateNodeMetadata(List<List<Integer>> assignment) {
        for (List<Integer> replicas : assignment) {
            for (int i = 0; i < replicas.size(); ++i) {
                NodeMetadata nodeMetadata = this.nodeMetadatas.get(replicas.get(i));
                if (nodeMetadata == null) {
                    throw new IllegalStateException("Inconsistent cluster metadata: replica node " + replicas.get(i) + " not found");
                }
                nodeMetadata.incrementReplicas(i == 0, true);
            }
        }
    }

    private Map<Integer, NodeMetadata> nodeMetadata() {
        List nodes = this.cluster.nodes();
        HashMap<Integer, NodeMetadata> nodeMetadatas = new HashMap<Integer, NodeMetadata>(nodes.size());
        for (Node node2 : nodes) {
            nodeMetadatas.put(node2.id(), new NodeMetadata());
        }
        String tenantPrefix = this.tenant + "_";
        for (String topic : this.cluster.topics()) {
            boolean isTenantTopic = topic.startsWith(tenantPrefix);
            for (PartitionInfo partitionInfo : this.cluster.partitionsForTopic(topic)) {
                Node[] replicas = partitionInfo.replicas();
                for (int i = 0; i < replicas.length; ++i) {
                    Node replicaNode = replicas[i];
                    if (replicaNode == null) continue;
                    NodeMetadata nodeMetadata = nodeMetadatas.computeIfAbsent(replicaNode.id(), node -> new NodeMetadata());
                    nodeMetadata.incrementReplicas(i == 0, isTenantTopic);
                }
            }
        }
        return nodeMetadatas;
    }

    class NodeReplicaCounter {
        private final Map<Integer, ReplicaCounts> leaderReplicaCounts;
        private final Map<Integer, ReplicaCounts> followerReplicaCounts;

        public NodeReplicaCounter(Map<Integer, ReplicaCounts> leaderReplicaCounts, Map<Integer, ReplicaCounts> followerReplicaCounts) {
            this.leaderReplicaCounts = new HashMap<Integer, ReplicaCounts>(leaderReplicaCounts);
            this.followerReplicaCounts = new HashMap<Integer, ReplicaCounts>(followerReplicaCounts);
        }

        public void incrementLeader(int brokerId) {
            this.leaderReplicaCounts.get(brokerId).incrementCounts();
        }

        public void incrementFollower(int brokerId) {
            this.followerReplicaCounts.get(brokerId).incrementCounts();
        }

        public List<Integer> orderLeaderNodes() {
            return this.orderLeaderNodes(this.leaderReplicaCounts.keySet());
        }

        public List<Integer> orderLeaderNodes(Set<Integer> eligibleNodes) {
            return this.orderNodes(eligibleNodes, this.leaderReplicaCounts);
        }

        public List<Integer> orderFollowerNodes() {
            return this.orderFollowerNodes(this.followerReplicaCounts.keySet());
        }

        public List<Integer> orderFollowerNodes(Set<Integer> eligibleNodes) {
            return this.orderNodes(eligibleNodes, this.followerReplicaCounts);
        }

        private List<Integer> orderNodes(Set<Integer> eligibleNodes, Map<Integer, ReplicaCounts> nodeReplicaCounts) {
            ArrayList<Integer> orderedNodes = new ArrayList<Integer>(eligibleNodes);
            orderedNodes.sort(Comparator.comparing(nodeReplicaCounts::get));
            return orderedNodes;
        }

        ReplicaCounts leaderCount(int brokerId) {
            return this.leaderReplicaCounts.get(brokerId);
        }

        ReplicaCounts followerCount(int brokerId) {
            return this.followerReplicaCounts.get(brokerId);
        }
    }

    static class ReplicaCounts
    implements Comparable<ReplicaCounts> {
        int topic;
        int tenant;
        int total;

        ReplicaCounts(int tenant, int total) {
            this(tenant, total, 0);
        }

        ReplicaCounts(int tenant, int total, int topic) {
            this.tenant = tenant;
            this.total = total;
            this.topic = topic;
        }

        void incrementCounts() {
            ++this.topic;
            ++this.tenant;
            ++this.total;
        }

        @Override
        public int compareTo(ReplicaCounts o) {
            int result = Integer.compare(this.topic, o.topic);
            if (result == 0) {
                result = Integer.compare(this.tenant, o.tenant);
            }
            if (result == 0) {
                result = Integer.compare(this.total, o.total);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplicaCounts that = (ReplicaCounts)o;
            return Objects.equals(this.topic, that.topic) && Objects.equals(this.tenant, that.tenant) && Objects.equals(this.total, that.total);
        }

        public int hashCode() {
            return Objects.hash(this.topic, this.tenant, this.total);
        }

        public String toString() {
            return "ReplicaCounts(topic=" + this.topic + ", tenant=" + this.tenant + ", total=" + this.total + ')';
        }
    }

    private static class NodeMetadata {
        int tenantLeaders;
        int tenantFollowers;
        int totalLeaders;
        int totalFollowers;

        private NodeMetadata() {
        }

        void incrementReplicas(boolean isLeaderReplica, boolean isTenantTopic) {
            if (isLeaderReplica) {
                this.incrementLeaders(isTenantTopic);
            } else {
                this.incrementFollowers(isTenantTopic);
            }
        }

        void incrementLeaders(boolean isTenantTopic) {
            ++this.totalLeaders;
            if (isTenantTopic) {
                ++this.tenantLeaders;
            }
        }

        void incrementFollowers(boolean isTenantTopic) {
            ++this.totalFollowers;
            if (isTenantTopic) {
                ++this.tenantFollowers;
            }
        }
    }
}

