/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;

public class MultiTenantInterceptorConfig {
    public static final MultiTenantInterceptorConfig DEFAULT = new MultiTenantInterceptorConfig(false, false, false);
    private final boolean clusterPrefixForHostnameEnabled;
    private final boolean schemaValidationEnabled;
    private final boolean sbcApisEnabled;

    public MultiTenantInterceptorConfig(Map<String, ?> configs) {
        this(MultiTenantInterceptorConfig.boolConfig(configs, "confluent.multitenant.listener.hostname.cluster.prefix.enable"), MultiTenantInterceptorConfig.boolConfig(configs, "confluent.schema.validator.multitenant.enable"), MultiTenantInterceptorConfig.boolConfig(configs, "confluent.multitenant.interceptor.balancer.apis.enabled"));
    }

    public MultiTenantInterceptorConfig(boolean clusterPrefixForHostnameEnabled, boolean schemaValidationEnabled, boolean sbcApisEnabled) {
        this.clusterPrefixForHostnameEnabled = clusterPrefixForHostnameEnabled;
        this.schemaValidationEnabled = schemaValidationEnabled;
        this.sbcApisEnabled = sbcApisEnabled;
    }

    public boolean isClusterPrefixForHostnameEnabled() {
        return this.clusterPrefixForHostnameEnabled;
    }

    public boolean isSchemaValidationEnabled() {
        return this.schemaValidationEnabled;
    }

    public boolean sbcApisEnabled() {
        return this.sbcApisEnabled;
    }

    public static int intConfig(Map<String, ?> configs, String configName) {
        Object configValue = configs.get(configName);
        if (configValue == null) {
            throw new ConfigException(configName + " is not set");
        }
        return Integer.parseInt(configValue.toString());
    }

    private static boolean boolConfig(Map<String, ?> configs, String configName) {
        Object configValue = configs.get(configName);
        if (configValue == null) {
            throw new ConfigException(configName + " is not set");
        }
        return Boolean.parseBoolean(configValue.toString());
    }
}

