/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.Timestamp;
import io.confluent.kafka.multitenant.quota.QuotaConfig;
import io.confluent.protobuf.cloud.events.v1.LogicalCluster;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LogicalClusterMetadata {
    public static final String KAFKA_LOGICAL_CLUSTER_TYPE = "kafka";
    public static final String HEALTHCHECK_LOGICAL_CLUSTER_TYPE = "healthcheck";
    public static final String LINK_HEALTHCHECK_LOGICAL_CLUSTER_TYPE = "link-healthcheck";
    public static final Double DEFAULT_REQUEST_PERCENTAGE_PER_BROKER = 250.0;
    public static final Integer DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE = 0;
    public static final Long DEFAULT_HEALTHCHECK_MAX_PRODUCER_RATE = 0xA00000L;
    public static final Long DEFAULT_HEALTHCHECK_MAX_CONSUMER_RATE = 0xA00000L;
    public static final Long DEFAULT_MIN_NETWORK_BYTE_RATE = 1024L;
    private final String logicalClusterId;
    private final String physicalClusterId;
    private final String logicalClusterName;
    private final String organizationId;
    private final String environmentId;
    private final String accountId;
    private final String k8sClusterId;
    private final String logicalClusterType;
    private final Long storageBytes;
    private final Long producerByteRate;
    private final Long consumerByteRate;
    private final Double brokerRequestPercentage;
    private final Integer networkQuotaOverhead;
    private final LifecycleMetadata lifecycleMetadata;
    private final Integer maxPartitions;
    private final boolean healthCheckLKC;

    @JsonCreator
    public LogicalClusterMetadata(@JsonProperty(value="logical_cluster_id") String logicalClusterId, @JsonProperty(value="physical_cluster_id") String physicalClusterId, @JsonProperty(value="logical_cluster_name") String logicalClusterName, @JsonProperty(value="account_id") String accountId, @JsonProperty(value="k8s_cluster_id") String k8sClusterId, @JsonProperty(value="logical_cluster_type") String logicalClusterType, @JsonProperty(value="storage_bytes") Long storageBytes, @JsonProperty(value="network_ingress_byte_rate") Long producerByteRate, @JsonProperty(value="network_egress_byte_rate") Long consumerByteRate, @JsonProperty(value="max_network_ingress_byte_rate") Long maxProducerByteRate, @JsonProperty(value="max_network_egress_byte_rate") Long maxConsumerByteRate, @JsonProperty(value="broker_request_percentage") Long brokerRequestPercentage, @JsonProperty(value="network_quota_overhead") Integer networkQuotaOverhead, @JsonProperty(value="metadata") LifecycleMetadata lifecycleMetadata, @JsonProperty(value="max_partitions") Integer maxPartitions, @JsonProperty(value="org_resource_id") String organizationId, @JsonProperty(value="environment_id") String environmentId) {
        this.logicalClusterId = logicalClusterId;
        this.physicalClusterId = physicalClusterId;
        this.logicalClusterName = logicalClusterName;
        this.accountId = accountId;
        this.k8sClusterId = k8sClusterId;
        this.logicalClusterType = logicalClusterType;
        this.storageBytes = storageBytes;
        this.healthCheckLKC = HEALTHCHECK_LOGICAL_CLUSTER_TYPE.equals(logicalClusterType) || LINK_HEALTHCHECK_LOGICAL_CLUSTER_TYPE.equals(logicalClusterType);
        Long validProducerByteRate = producerByteRate;
        if (validProducerByteRate != null) {
            validProducerByteRate = Math.max(maxProducerByteRate != null ? maxProducerByteRate : 0L, Math.max(DEFAULT_MIN_NETWORK_BYTE_RATE, producerByteRate));
        } else if (this.isHealthcheckLogicalCluster()) {
            validProducerByteRate = DEFAULT_HEALTHCHECK_MAX_PRODUCER_RATE;
        }
        Long validConsumerByteRate = consumerByteRate;
        if (validConsumerByteRate != null) {
            validConsumerByteRate = Math.max(maxConsumerByteRate != null ? maxConsumerByteRate : 0L, Math.max(DEFAULT_MIN_NETWORK_BYTE_RATE, consumerByteRate));
        } else if (this.isHealthcheckLogicalCluster()) {
            validConsumerByteRate = DEFAULT_HEALTHCHECK_MAX_CONSUMER_RATE;
        }
        this.producerByteRate = validProducerByteRate;
        this.consumerByteRate = validConsumerByteRate;
        this.brokerRequestPercentage = brokerRequestPercentage == null || brokerRequestPercentage == 0L ? DEFAULT_REQUEST_PERCENTAGE_PER_BROKER : (double)brokerRequestPercentage.longValue();
        this.networkQuotaOverhead = networkQuotaOverhead == null ? DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE : networkQuotaOverhead;
        this.lifecycleMetadata = lifecycleMetadata;
        this.maxPartitions = maxPartitions;
        this.organizationId = organizationId;
        this.environmentId = environmentId != null ? environmentId : accountId;
    }

    public static LogicalClusterMetadata fromProtobuf(LogicalCluster lc) {
        return new LogicalClusterMetadata(lc.getLogicalClusterId(), lc.getPhysicalClusterId(), lc.getLogicalClusterName(), lc.getAccountId(), lc.getK8SClusterId(), lc.getLogicalClusterType(), lc.getStorageBytes() > 0L ? Long.valueOf(lc.getStorageBytes()) : null, lc.getNetworkIngressByteRate(), lc.getNetworkEgressByteRate(), lc.getMaxNetworkIngressByteRate(), lc.getMaxNetworkEgressByteRate(), lc.getBrokerRequestPercentage(), 0, new LifecycleMetadata(lc.getLogicalClusterId(), lc.getPhysicalClusterId(), LogicalClusterMetadata.timeStampToDate(lc.getCreated()), lc.hasDeactivated() && !LogicalClusterMetadata.isZeroTimestamp(lc.getDeactivated()) ? LogicalClusterMetadata.timeStampToDate(lc.getDeactivated()) : null), lc.getMaxPartitions() > 0 ? Integer.valueOf(lc.getMaxPartitions()) : null, lc.getOrgResourceId().isEmpty() ? null : lc.getOrgResourceId(), lc.getEnvironmentId());
    }

    @JsonProperty
    public String logicalClusterId() {
        return this.logicalClusterId;
    }

    @JsonProperty
    public String physicalClusterId() {
        return this.physicalClusterId;
    }

    @JsonProperty
    public String logicalClusterName() {
        return this.logicalClusterName;
    }

    @JsonProperty
    public String accountId() {
        return this.accountId;
    }

    @JsonProperty
    public String organizationId() {
        return this.organizationId;
    }

    @JsonProperty
    public String environmentId() {
        return this.environmentId;
    }

    @JsonProperty
    public String k8sClusterId() {
        return this.k8sClusterId;
    }

    @JsonProperty
    public String logicalClusterType() {
        return this.logicalClusterType;
    }

    @JsonProperty
    public Long storageBytes() {
        return this.storageBytes;
    }

    @JsonProperty
    public Long producerByteRate() {
        return this.producerByteRate;
    }

    @JsonProperty
    public Long consumerByteRate() {
        return this.consumerByteRate;
    }

    @JsonProperty
    public Double brokerRequestPercentage() {
        return this.brokerRequestPercentage;
    }

    @JsonProperty
    public Integer networkQuotaOverhead() {
        return this.networkQuotaOverhead;
    }

    @JsonProperty
    public LifecycleMetadata lifecycleMetadata() {
        return this.lifecycleMetadata;
    }

    @JsonProperty
    public Integer maxPartitions() {
        return this.maxPartitions;
    }

    boolean isValid() {
        return this.isKafkaLogicalCluster() || this.isHealthcheckLogicalCluster();
    }

    boolean isKafkaLogicalCluster() {
        return KAFKA_LOGICAL_CLUSTER_TYPE.equals(this.logicalClusterType);
    }

    boolean isHealthcheckLogicalCluster() {
        return this.healthCheckLKC;
    }

    public boolean isActive() {
        return this.lifecycleMetadata == null || this.lifecycleMetadata.deletionDate() == null;
    }

    public QuotaConfig quotaConfig() {
        double multiplier = 1.0 + (double)this.networkQuotaOverhead().intValue() / 100.0;
        Long producerByteRate = this.producerByteRate() == null ? null : Long.valueOf((long)(multiplier * (double)this.producerByteRate().longValue()));
        Long consumerByteRate = this.consumerByteRate() == null ? null : Long.valueOf((long)(multiplier * (double)this.consumerByteRate().longValue()));
        return new QuotaConfig(producerByteRate, consumerByteRate, this.brokerRequestPercentage(), null, QuotaConfig.UNLIMITED_QUOTA);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalClusterMetadata that = (LogicalClusterMetadata)o;
        return Objects.equals(this.logicalClusterId, that.logicalClusterId) && Objects.equals(this.physicalClusterId, that.physicalClusterId) && Objects.equals(this.logicalClusterName, that.logicalClusterName) && Objects.equals(this.accountId, that.accountId) && Objects.equals(this.k8sClusterId, that.k8sClusterId) && Objects.equals(this.logicalClusterType, that.logicalClusterType) && Objects.equals(this.storageBytes, that.storageBytes) && Objects.equals(this.producerByteRate, that.producerByteRate) && Objects.equals(this.consumerByteRate, that.consumerByteRate) && Objects.equals(this.brokerRequestPercentage, that.brokerRequestPercentage) && Objects.equals(this.networkQuotaOverhead, that.networkQuotaOverhead) && Objects.equals(this.lifecycleMetadata, that.lifecycleMetadata) && Objects.equals(this.maxPartitions, that.maxPartitions) && Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.environmentId, that.environmentId);
    }

    public int hashCode() {
        return Objects.hash(this.logicalClusterId, this.physicalClusterId, this.logicalClusterName, this.accountId, this.k8sClusterId, this.logicalClusterType, this.storageBytes, this.producerByteRate, this.consumerByteRate, this.brokerRequestPercentage, this.networkQuotaOverhead, this.lifecycleMetadata, this.maxPartitions, this.organizationId, this.environmentId);
    }

    public String toString() {
        return "LogicalClusterMetadata(logicalClusterId=" + this.logicalClusterId + ", physicalClusterId=" + this.physicalClusterId + ", logicalClusterName=" + this.logicalClusterName + ", organizationId=" + this.organizationId + ", environmentId=" + this.environmentId + ", accountId=" + this.accountId + ", k8sClusterId=" + this.k8sClusterId + ", logicalClusterType=" + this.logicalClusterType + ", storageBytes=" + this.storageBytes + ", producerByteRate=" + this.producerByteRate + ", consumerByteRate=" + this.consumerByteRate + ", brokerRequestPercentage=" + this.brokerRequestPercentage + ", networkQuotaOverhead=" + this.networkQuotaOverhead + ", lifecycleMetadata=" + this.lifecycleMetadata + ", maxPartitions=" + this.maxPartitions + ')';
    }

    private static Date timeStampToDate(Timestamp timestamp) {
        return Date.from(Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()));
    }

    private static boolean isZeroTimestamp(Timestamp timestamp) {
        return timestamp.getSeconds() == 0L && timestamp.getNanos() == 0;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LifecycleMetadata {
        private final String logicalClusterName;
        private final String physicalK8sNamespace;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
        private final Date creationDate;
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
        private final Date deletionDate;

        @JsonCreator
        public LifecycleMetadata(@JsonProperty(value="name") String logicalClusterName, @JsonProperty(value="namespace") String physicalK8sNamespace, @JsonProperty(value="creationTimestamp") Date creationDate, @JsonProperty(value="deletionTimestamp") Date deletionDate) {
            this.logicalClusterName = logicalClusterName;
            this.physicalK8sNamespace = physicalK8sNamespace;
            this.creationDate = creationDate;
            this.deletionDate = deletionDate;
        }

        @JsonProperty
        public String logicalClusterName() {
            return this.logicalClusterName;
        }

        @JsonProperty
        public String physicalK8sNamespace() {
            return this.physicalK8sNamespace;
        }

        @JsonProperty
        public Date creationDate() {
            return this.creationDate;
        }

        @JsonProperty
        public Date deletionDate() {
            return this.deletionDate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LifecycleMetadata that = (LifecycleMetadata)o;
            return Objects.equals(this.logicalClusterName, that.logicalClusterName) && Objects.equals(this.physicalK8sNamespace, that.physicalK8sNamespace) && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.deletionDate, that.deletionDate);
        }

        public int hashCode() {
            return Objects.hash(this.logicalClusterName, this.physicalK8sNamespace, this.creationDate, this.deletionDate);
        }

        public String toString() {
            return "LifecycleMetadata{logicalClusterName='" + this.logicalClusterName + '\'' + ", physicalK8sNamespace='" + this.physicalK8sNamespace + '\'' + ", creationDate=" + this.creationDate + ", deletionDate=" + this.deletionDate + '}';
        }
    }
}

