/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.server.plugins.policy.ClusterLinkPolicyConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.server.interceptor.ClusterLinkInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateClusterLinkPolicy
implements org.apache.kafka.server.policy.CreateClusterLinkPolicy,
ClusterLinkInterceptor,
Reconfigurable {
    private static final Logger log = LoggerFactory.getLogger(CreateClusterLinkPolicy.class);
    private static final Set<String> RECONFIGURABLE_CONFIGS = ImmutableSet.of((Object)"confluent.plugins.cluster.link.policy.max.destination.links.per.tenant", (Object)"confluent.plugins.cluster.link.policy.max.source.links.per.tenant");
    private ClusterLinkPolicyConfig clusterLinkPolicyConfig;
    private volatile int maxDestLinksPerTenant;
    private volatile int maxSourceLinksPerTenant;
    private Map<UUID, LinkData> linkIdToLinkData = new HashMap<UUID, LinkData>();
    private Map<String, Integer> tenantToNumDestLinks = new HashMap<String, Integer>();
    private Map<String, Integer> tenantToNumSourceLinks = new HashMap<String, Integer>();

    public void configure(Map<String, ?> configs) {
        this.reconfigure(configs);
    }

    public void reconfigure(Map<String, ?> configs) {
        this.clusterLinkPolicyConfig = new ClusterLinkPolicyConfig(configs);
        this.maxDestLinksPerTenant = this.clusterLinkPolicyConfig.getInt("confluent.plugins.cluster.link.policy.max.destination.links.per.tenant");
        this.maxSourceLinksPerTenant = this.clusterLinkPolicyConfig.getInt("confluent.plugins.cluster.link.policy.max.source.links.per.tenant");
        log.info("Setting maximum number of destination links to {} and maximum number of source links to {}", (Object)this.maxDestLinksPerTenant, (Object)this.maxSourceLinksPerTenant);
    }

    public Set<String> reconfigurableConfigs() {
        return RECONFIGURABLE_CONFIGS;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Optional<String> tenantPrefix, String linkModeStr, Map<String, String> configs) throws PolicyViolationException {
        if (!tenantPrefix.isPresent()) {
            return;
        }
        CreateClusterLinkPolicy createClusterLinkPolicy = this;
        synchronized (createClusterLinkPolicy) {
            ClusterLinkConfig.LinkMode linkMode = ClusterLinkConfig.LinkMode.fromString((String)linkModeStr);
            if (linkMode.equals((Object)ClusterLinkConfig.LinkMode.Destination)) {
                CreateClusterLinkPolicy.validateLinkCount(tenantPrefix.get(), this.tenantToNumDestLinks, this.maxDestLinksPerTenant, linkModeStr);
            } else {
                CreateClusterLinkPolicy.CheckCondition(linkMode.equals((Object)ClusterLinkConfig.LinkMode.Source), "Invalid link mode " + linkModeStr);
                CreateClusterLinkPolicy.validateLinkCount(tenantPrefix.get(), this.tenantToNumSourceLinks, this.maxSourceLinksPerTenant, linkModeStr);
            }
        }
        ClusterLinkPolicyConfig.validateBootstrap(configs);
    }

    private static void validateLinkCount(String tenantPrefix, Map<String, Integer> tenantToNumLinks, int maxLinks, String mode) throws PolicyViolationException {
        Integer tenantLinks = tenantToNumLinks.get(tenantPrefix);
        if (tenantLinks == null) {
            tenantLinks = 0;
        }
        if (tenantLinks >= maxLinks) {
            throw new PolicyViolationException(String.format("This cluster already has the maximum number of %s cluster links (%d). You can request a higher limit through Confluent Support.", mode, maxLinks));
        }
    }

    public synchronized void linkAdded(UUID linkId, Optional<String> tenantPrefix, String linkModeStr) {
        if (!tenantPrefix.isPresent()) {
            return;
        }
        if (this.linkIdToLinkData.containsKey(linkId)) {
            return;
        }
        ClusterLinkConfig.LinkMode linkMode = ClusterLinkConfig.LinkMode.fromString((String)linkModeStr);
        if (linkMode.equals((Object)ClusterLinkConfig.LinkMode.Destination)) {
            this.linkAddedInternal(linkId, tenantPrefix.get(), this.tenantToNumDestLinks, LinkMode.Destination);
        } else {
            CreateClusterLinkPolicy.CheckCondition(linkMode.equals((Object)ClusterLinkConfig.LinkMode.Source), "Invalid link mode " + linkModeStr);
            this.linkAddedInternal(linkId, tenantPrefix.get(), this.tenantToNumSourceLinks, LinkMode.Source);
        }
    }

    private void linkAddedInternal(UUID linkId, String tenantPrefix, Map<String, Integer> tenantToNumLinks, LinkMode mode) {
        this.linkIdToLinkData.put(linkId, new LinkData(tenantPrefix, mode));
        if (tenantToNumLinks.computeIfPresent(tenantPrefix, (k, v) -> {
            v = v + 1;
            return v;
        }) == null) {
            tenantToNumLinks.put(tenantPrefix, 1);
        }
    }

    public synchronized void linkDeleted(UUID linkId) {
        LinkData linkData = this.linkIdToLinkData.remove(linkId);
        if (linkData == null) {
            return;
        }
        Map<String, Integer> tenantToNumLinks = linkData.linkMode == LinkMode.Destination ? this.tenantToNumDestLinks : this.tenantToNumSourceLinks;
        CreateClusterLinkPolicy.CheckCondition(tenantToNumLinks.containsKey(linkData.tenantPrefix), linkData.tenantPrefix + " can't be found in map with link mode " + (Object)((Object)linkData.linkMode));
        Integer linkCount = tenantToNumLinks.get(linkData.tenantPrefix);
        CreateClusterLinkPolicy.CheckCondition(linkCount > 0, "Invalid link count " + linkCount + " for tenant " + linkData.tenantPrefix + " with link mode " + (Object)((Object)linkData.linkMode));
        Integer n = linkCount;
        Integer n2 = linkCount = Integer.valueOf(linkCount - 1);
        if (linkCount == 0) {
            tenantToNumLinks.remove(linkData.tenantPrefix);
        } else {
            tenantToNumLinks.put(linkData.tenantPrefix, linkCount);
        }
    }

    private static void CheckCondition(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    private class LinkData {
        public String tenantPrefix;
        public LinkMode linkMode;

        LinkData(String tenantPrefix, LinkMode linkMode) {
            this.tenantPrefix = tenantPrefix;
            this.linkMode = linkMode;
        }
    }

    static enum LinkMode {
        Source,
        Destination;

    }
}

