/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.multitenant.utils.Utils;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecrets;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsStore;
import io.confluent.kafka.server.plugins.auth.PlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;

public class TopicBasedPlainSaslAuthenticator
extends PlainSaslAuthenticator {
    private final MultiTenantSaslSecretsStore secretsLoader;

    public TopicBasedPlainSaslAuthenticator(Map<String, ?> props) {
        super(SUCCESSFUL_AUTH_CACHE, FAILED_AUTH_CACHE);
        this.secretsLoader = MultiTenantSaslSecretsStore.getInstance(Utils.getBrokerSessionUuid(props));
    }

    @Override
    public void initialize(List<AppConfigurationEntry> jaasContextEntries) {
        this.mode = SniValidationMode.fromString(TopicBasedPlainSaslAuthenticator.configEntryOption(jaasContextEntries, "sni_host_name_validation_mode", TopicBasedLoginModule.class.getName()));
        this.log.debug(String.format("TopicBasedPlainSaslAuthenticator initialized with mode: %s.", this.mode.getText()));
    }

    @Override
    protected MultiTenantSaslSecrets loadSecrets() {
        return this.secretsLoader.load();
    }
}

