/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.AuthAttemptCache;
import io.confluent.kafka.server.plugins.auth.FileBasedLoginModule;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecrets;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsLoader;
import io.confluent.kafka.server.plugins.auth.PlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.utils.SystemTime;

public class FileBasedPlainSaslAuthenticator
extends PlainSaslAuthenticator {
    static final String JAAS_ENTRY_CONFIG = "config_path";
    static final String JAAS_ENTRY_REFRESH_MS = "refresh_ms";
    private String configFilePath;
    private long refreshMs;
    private static final MultiTenantSaslSecretsLoader SECRETS_LOADER = new MultiTenantSaslSecretsLoader(3);
    private final MultiTenantSaslSecretsLoader secretsLoader;

    public FileBasedPlainSaslAuthenticator() {
        this(SUCCESSFUL_AUTH_CACHE, FAILED_AUTH_CACHE, SECRETS_LOADER);
    }

    FileBasedPlainSaslAuthenticator(AuthAttemptCache successfulAuthCache, AuthAttemptCache failedAuthCache, MultiTenantSaslSecretsLoader secretsLoader) {
        super(successfulAuthCache, failedAuthCache);
        this.secretsLoader = secretsLoader;
    }

    @Override
    public void initialize(List<AppConfigurationEntry> jaasContextEntries) {
        this.configFilePath = FileBasedPlainSaslAuthenticator.configEntryOption(jaasContextEntries, JAAS_ENTRY_CONFIG, FileBasedLoginModule.class.getName());
        this.refreshMs = Long.parseLong(FileBasedPlainSaslAuthenticator.configEntryOption(jaasContextEntries, JAAS_ENTRY_REFRESH_MS, FileBasedLoginModule.class.getName()));
        this.mode = SniValidationMode.fromString(FileBasedPlainSaslAuthenticator.configEntryOption(jaasContextEntries, "sni_host_name_validation_mode", FileBasedLoginModule.class.getName()));
        this.log.debug(String.format("FileBasedPlainSaslAuthenticator initialized with mode: %s, refreshMs: %d and config path: %s.", this.mode.getText(), this.refreshMs, this.configFilePath));
    }

    @Override
    protected MultiTenantSaslSecrets loadSecrets() {
        return this.secretsLoader.load(this.configFilePath, SystemTime.SYSTEM.milliseconds(), this.refreshMs);
    }

    void setConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
    }
}

