/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.utils;

import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.protobuf.cloud.events.v1.EventsMetadata;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String SEQUENCE_ID_STRING_HEADER_KEY = "_sequence_id";
    public static final String EVENTS_METADATA_HEADER_KEY = "eventsmetadata";

    public static AdminClient createAdminClient(String endpoint) {
        Properties adminClientProps = new Properties();
        try {
            LOG.info("Using bootstrap server {}", (Object)endpoint);
            adminClientProps.put("bootstrap.servers", endpoint);
            return AdminClient.create((Properties)adminClientProps);
        }
        catch (Exception e) {
            LOG.error("Failed to create admin client for endpoint {} ", (Object)endpoint, (Object)e);
            return null;
        }
    }

    public static ConfluentAdmin createConfluentAdmin(String endpoint) {
        Properties adminClientProps = new Properties();
        try {
            LOG.info("Using bootstrap server {}", (Object)endpoint);
            adminClientProps.put("bootstrap.servers", endpoint);
            return ConfluentAdmin.create((Properties)adminClientProps);
        }
        catch (Exception e) {
            LOG.error("Failed to create admin client for endpoint {} ", (Object)endpoint, (Object)e);
            return null;
        }
    }

    public static String getBrokerSessionUuid(Map<String, ?> configs) {
        Object uuidConfigValue = configs.get(KafkaConfig.BrokerSessionUuidProp());
        if (uuidConfigValue == null) {
            throw new ConfigException(KafkaConfig.BrokerSessionUuidProp() + " is not set");
        }
        return uuidConfigValue.toString();
    }

    static Long clampSequenceId(Long sequenceId) {
        if (sequenceId <= 0L) {
            LOG.error("Encountered sequence id outside the expected range 0 < {} < 2^63", (Object)Long.toUnsignedString(sequenceId));
            sequenceId = null;
        }
        return sequenceId;
    }

    static Long tryParseEventsSequenceIdFromProto(byte[] headerValue) {
        Long sequenceId = null;
        try {
            EventsMetadata em = EventsMetadata.parseFrom(headerValue);
            sequenceId = Utils.clampSequenceId(em.getSequenceId());
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Error when parsing EventsMetadata protobuf", (Throwable)e);
        }
        return sequenceId;
    }

    static Long tryParseEventsSequenceIdFromString(byte[] headerValue) {
        Objects.requireNonNull(headerValue, "This method shouldn't be used for testing header's existance. headerValue mustn't be null");
        Long sequenceId = null;
        try {
            sequenceId = Utils.clampSequenceId(Long.parseUnsignedLong(new String(headerValue, StandardCharsets.UTF_8)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sequenceId;
    }

    private static void logResult(String headerName, String key, Long sequenceId) {
        if (sequenceId == null) {
            LOG.error("For message with key {}, unable to read sequence id from {}", (Object)key, (Object)headerName);
        } else {
            LOG.trace("For message with key {}, read sequence id {} from {}", new Object[]{key, sequenceId, headerName});
        }
    }

    public static Long tryParseEventsSequenceId(ConsumerRecord record) {
        Long sequenceId = null;
        Headers headers = record.headers();
        Header protoHeader = headers.lastHeader(EVENTS_METADATA_HEADER_KEY);
        if (protoHeader != null) {
            sequenceId = Utils.tryParseEventsSequenceIdFromProto(protoHeader.value());
            Utils.logResult(EVENTS_METADATA_HEADER_KEY, record.key().toString(), sequenceId);
        } else {
            Header stringHeader = headers.lastHeader(SEQUENCE_ID_STRING_HEADER_KEY);
            if (stringHeader != null) {
                sequenceId = Utils.tryParseEventsSequenceIdFromString(stringHeader.value());
                Utils.logResult(EVENTS_METADATA_HEADER_KEY, record.key().toString(), sequenceId);
            }
        }
        return sequenceId;
    }
}

