/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.utils;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.security.authorizer.AclAccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.RequestContext;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.ConfluentAuthorizationEvent;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.audit.AuditEvent;
import org.apache.kafka.server.audit.AuditEventType;
import org.apache.kafka.server.audit.AuthenticationEvent;
import org.apache.kafka.server.audit.DefaultAuthenticationEvent;

public class TenantSanitizer {
    public static final String PRINCIPAL_RESOURCE_ID = "principal-resource-id";

    private static KafkaPrincipal tenantPrincipal(MultiTenantPrincipal principal) {
        return new KafkaPrincipal("User", principal.user());
    }

    private static KafkaPrincipal tenantPrincipal(KafkaPrincipal principal) {
        int index;
        if ("TenantUser".equals(principal.getPrincipalType()) && (index = principal.getName().indexOf("_")) > 0) {
            return new KafkaPrincipal("User", principal.getName().substring(index + 1));
        }
        throw new NotTenantPrefixedException("Expected a multi-tenant principal: " + principal);
    }

    private static Scope tenantScope(Scope scope, String tenantClusterId) {
        Scope.Builder builder = new Scope.Builder(new String[0]);
        scope.path().forEach(arg_0 -> ((Scope.Builder)builder).addPath(arg_0));
        scope.clusters().forEach((k, v) -> {
            if (k.equals("kafka-cluster")) {
                builder.withKafkaCluster(tenantClusterId);
            } else {
                builder.withCluster(k, v);
            }
        });
        return builder.build();
    }

    private static io.confluent.security.authorizer.ResourcePattern tenantResourcePattern(io.confluent.security.authorizer.ResourcePattern resourcePattern, String tenantPrefix) {
        if (!resourcePattern.name().startsWith(tenantPrefix)) {
            throw new NotTenantPrefixedException("Expected a multi-tenant prefix: " + resourcePattern.name());
        }
        return new io.confluent.security.authorizer.ResourcePattern(resourcePattern.resourceType(), resourcePattern.name().substring(tenantPrefix.length()), resourcePattern.patternType());
    }

    private static RequestContext tenantRequestContext(final RequestContext requestContext) {
        return new RequestContext(){

            public KafkaPrincipal principal() {
                return TenantSanitizer.tenantPrincipal((MultiTenantPrincipal)requestContext.principal());
            }

            public String requestSource() {
                return requestContext.requestSource();
            }

            public String listenerName() {
                return requestContext.listenerName();
            }

            public SecurityProtocol securityProtocol() {
                return requestContext.securityProtocol();
            }

            public InetAddress clientAddress() {
                return requestContext.clientAddress();
            }

            public int requestType() {
                return requestContext.requestType();
            }

            public int requestVersion() {
                return requestContext.requestVersion();
            }

            public String clientId() {
                return requestContext.clientId();
            }

            public int correlationId() {
                return requestContext.correlationId();
            }
        };
    }

    private static AccessControlEntry tenantAccessControlEntry(AccessControlEntry entry) {
        return new AccessControlEntry(TenantSanitizer.tenantPrincipal(SecurityUtils.parseKafkaPrincipal((String)entry.principal())).toString(), entry.host(), entry.operation(), entry.permissionType(), entry.clusterLinkIds());
    }

    private static AclAccessRule tenantAclAccessRule(AclAccessRule accessRule, String tenantPrefix) {
        AclBinding aclBinding = accessRule.aclBinding();
        AclBinding tenantAclBinding = new AclBinding(io.confluent.security.authorizer.ResourcePattern.to((io.confluent.security.authorizer.ResourcePattern)TenantSanitizer.tenantResourcePattern(io.confluent.security.authorizer.ResourcePattern.from((ResourcePattern)aclBinding.pattern()), tenantPrefix)), TenantSanitizer.tenantAccessControlEntry(aclBinding.entry()));
        return new AclAccessRule(TenantSanitizer.tenantResourcePattern(accessRule.resourcePattern(), tenantPrefix), TenantSanitizer.tenantPrincipal(accessRule.principal()), accessRule.permissionType(), accessRule.host(), accessRule.operation(), accessRule.policyType(), tenantAclBinding);
    }

    private static AuthorizePolicy tenantAuthorizePolicy(AuthorizePolicy authorizePolicy, String tenantPrefix) {
        switch (authorizePolicy.policyType()) {
            case DENY_ACL: 
            case ALLOW_ACL: {
                return TenantSanitizer.tenantAclAccessRule((AclAccessRule)authorizePolicy, tenantPrefix);
            }
        }
        return authorizePolicy;
    }

    public static AuditEvent tenantAuditEvent(AuditEvent auditEvent, String defaultKafkaClusterId) {
        if (auditEvent.type() == AuditEventType.AUTHORIZATION) {
            return TenantSanitizer.handleAuthorizationEvent((ConfluentAuthorizationEvent)auditEvent);
        }
        if (auditEvent.type() == AuditEventType.AUTHENTICATION) {
            return TenantSanitizer.handleAuthenticationEvent((ConfluentAuthenticationEvent)auditEvent, defaultKafkaClusterId);
        }
        return auditEvent;
    }

    public static AuditEvent tenantAuditEvent(AuditEvent auditEvent) {
        return TenantSanitizer.tenantAuditEvent(auditEvent, null);
    }

    private static Map<String, Object> getData(TenantMetadata metadata, AuditEvent auditEvent) {
        if (auditEvent.data().isEmpty()) {
            return Collections.singletonMap(PRINCIPAL_RESOURCE_ID, metadata.userResourceId);
        }
        HashMap<String, Object> data = new HashMap<String, Object>(auditEvent.data());
        data.put(PRINCIPAL_RESOURCE_ID, metadata.userResourceId);
        return data;
    }

    private static AuditEvent handleAuthorizationEvent(ConfluentAuthorizationEvent auditEvent) {
        if (auditEvent.requestContext().principal() instanceof MultiTenantPrincipal) {
            TenantMetadata metadata = ((MultiTenantPrincipal)auditEvent.requestContext().principal()).tenantMetadata();
            RequestContext tenantRequestContext = TenantSanitizer.tenantRequestContext(auditEvent.requestContext());
            io.confluent.security.authorizer.ResourcePattern tenantResourcePattern = TenantSanitizer.tenantResourcePattern(auditEvent.action().resourcePattern(), metadata.tenantPrefix());
            Action tenantAction = new Action(auditEvent.action().scope(), tenantResourcePattern, auditEvent.action().operation(), auditEvent.action().resourceReferenceCount(), auditEvent.action().logIfAllowed(), auditEvent.action().logIfDenied());
            AuthorizePolicy tenantAuthorizePolicy = TenantSanitizer.tenantAuthorizePolicy(auditEvent.authorizePolicy(), metadata.tenantPrefix());
            ConfluentAuthorizationEvent sanitizeAuditEvent = new ConfluentAuthorizationEvent(auditEvent.action().scope(), tenantRequestContext, tenantAction, auditEvent.authorizeResult(), tenantAuthorizePolicy, auditEvent.timestamp());
            if (metadata.userResourceId != null) {
                sanitizeAuditEvent.setData(TenantSanitizer.getData(metadata, (AuditEvent)auditEvent));
            }
            return sanitizeAuditEvent;
        }
        return auditEvent;
    }

    private static AuditEvent handleAuthenticationEvent(ConfluentAuthenticationEvent auditEvent, String defaultKafkaClusterId) {
        AuthenticationException exception;
        String lkcId;
        if (auditEvent.principal().orElse(null) instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal principal = (MultiTenantPrincipal)auditEvent.principal().get();
            DefaultAuthenticationEvent defaultEvent = new DefaultAuthenticationEvent(TenantSanitizer.tenantPrincipal(principal), auditEvent.authenticationContext(), auditEvent.status(), (AuthenticationException)auditEvent.authenticationException().orElse(null), auditEvent.timestamp());
            ConfluentAuthenticationEvent sanitizeAuditEvent = new ConfluentAuthenticationEvent((AuthenticationEvent)defaultEvent, principal.tenantMetadata().scope());
            if (principal.tenantMetadata().userResourceId != null) {
                sanitizeAuditEvent.setData(TenantSanitizer.getData(principal.tenantMetadata(), (AuditEvent)auditEvent));
            }
            return sanitizeAuditEvent;
        }
        if (auditEvent.authenticationException().isPresent() && !(lkcId = TenantSanitizer.getLKCIdFromException(exception = auditEvent.authenticationException().get())).isEmpty()) {
            Scope tenantScope = TenantSanitizer.tenantScope(auditEvent.getScope(), lkcId);
            return new ConfluentAuthenticationEvent((AuthenticationEvent)new DefaultAuthenticationEvent((KafkaPrincipal)auditEvent.principal().orElse(null), auditEvent.authenticationContext(), auditEvent.status(), (AuthenticationException)auditEvent.authenticationException().orElse(null), auditEvent.timestamp()), tenantScope);
        }
        if (defaultKafkaClusterId == null) {
            return auditEvent;
        }
        return new ConfluentAuthenticationEvent((AuthenticationEvent)new DefaultAuthenticationEvent((KafkaPrincipal)auditEvent.principal().orElse(null), auditEvent.authenticationContext(), auditEvent.status(), (AuthenticationException)auditEvent.authenticationException().orElse(null), auditEvent.timestamp()), TenantSanitizer.tenantScope(auditEvent.getScope(), defaultKafkaClusterId));
    }

    private static String getLKCIdFromException(AuthenticationException exception) {
        String clusterId = exception.errorInfo().clusterId();
        if (!clusterId.isEmpty()) {
            return clusterId;
        }
        return exception.errorInfo().saslExtensions().getOrDefault("logicalCluster", "");
    }

    public static class NotTenantPrefixedException
    extends RuntimeException {
        public NotTenantPrefixedException(String message) {
            super(message);
        }
    }
}

