/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.quota;

import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.quota.QuotaConfig;
import io.confluent.kafka.multitenant.schema.TenantContext;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kafka.common.TenantHelpers;
import kafka.server.ConfigEntityName;
import kafka.server.KafkaConfig$;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.ClientQuotaEntity;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantQuotaCallback
implements ClientQuotaCallback,
ClusterLevelQuotaCallback,
Reconfigurable {
    private static final Logger log = LoggerFactory.getLogger(TenantQuotaCallback.class);
    static final EnumSet<ClientQuotaType> USER_CONFIGURABLE_QUOTAS = EnumSet.of(ClientQuotaType.PRODUCE, ClientQuotaType.FETCH);
    private static final Map<Integer, TenantQuotaCallback> INSTANCES = new HashMap<Integer, TenantQuotaCallback>();
    private static final Set<String> RECONFIGURABLE_CONFIGS = new HashSet<String>();
    private final EnumMap<ClientQuotaType, AtomicBoolean> quotaResetPending = new EnumMap(ClientQuotaType.class);
    private final ConcurrentHashMap<String, TenantQuota> tenantQuotas;
    private volatile int brokerId;
    private volatile long maxPerTenantBrokerProducerRate;
    private volatile long maxPerTenantBrokerConsumerRate;
    private volatile long minPerTenantFollowerBrokerProducerRate;
    private volatile long minPerTenantFollowerBrokerConsumerRate;
    private volatile double tenantProduceQuotaMultiplier;
    private volatile double tenantFetchQuotaMultiplier;
    private volatile double defaultPerTenantControllerMutationRate;
    private volatile boolean tenantUserQuotasEnabled;
    private volatile Cluster cluster;
    private volatile QuotaConfig defaultTenantQuota;

    public TenantQuotaCallback() {
        for (ClientQuotaType quotaType : ClientQuotaType.values()) {
            this.quotaResetPending.put(quotaType, new AtomicBoolean());
        }
        this.tenantQuotas = new ConcurrentHashMap();
        this.defaultTenantQuota = QuotaConfig.UNLIMITED_QUOTA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Map<String, ?> configs) {
        this.brokerId = MultiTenantInterceptorConfig.intConfig(configs, KafkaConfig$.MODULE$.BrokerIdProp());
        Map<Integer, TenantQuotaCallback> map = INSTANCES;
        synchronized (map) {
            INSTANCES.put(this.brokerId, this);
        }
        TenantQuotaCallbackConfig config = new TenantQuotaCallbackConfig(configs);
        this.minPerTenantFollowerBrokerConsumerRate = config.minPerTenantFollowerBrokerConsumerRate();
        this.minPerTenantFollowerBrokerProducerRate = config.minPerTenantFollowerBrokerProducerRate();
        this.maxPerTenantBrokerConsumerRate = config.maxPerTenantBrokerConsumerRate();
        this.maxPerTenantBrokerProducerRate = config.maxPerTenantBrokerProducerRate();
        this.defaultPerTenantControllerMutationRate = config.defaultPerTenantControllerMutationRate();
        this.tenantProduceQuotaMultiplier = config.tenantProduceQuotaMultiplier();
        this.tenantFetchQuotaMultiplier = config.tenantFetchQuotaMultiplier();
        this.tenantUserQuotasEnabled = config.tenantUserQuotasEnabled();
        this.printQuota(false);
    }

    public Set<String> reconfigurableConfigs() {
        return RECONFIGURABLE_CONFIGS;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        new TenantQuotaCallbackConfig(configs);
    }

    public void reconfigure(Map<String, ?> configs) {
        TenantQuotaCallbackConfig config = new TenantQuotaCallbackConfig(configs);
        this.defaultPerTenantControllerMutationRate = config.defaultPerTenantControllerMutationRate();
        this.tenantProduceQuotaMultiplier = config.tenantProduceQuotaMultiplier();
        this.tenantFetchQuotaMultiplier = config.tenantFetchQuotaMultiplier();
        this.tenantUserQuotasEnabled = config.tenantUserQuotasEnabled();
        this.reconfigureQuotas();
        this.printQuota(true);
    }

    private void printQuota(boolean reconfigured) {
        log.info("{} tenant quota callback for broker {} with {}={}, {}={}, {}={}, {}={}, {}={}, {}={}, {}={}, {}={}", new Object[]{reconfigured ? "Re-configured" : "Configured", this.brokerId, "confluent.quota.tenant.follower.broker.min.producer.rate", this.minPerTenantFollowerBrokerProducerRate, "confluent.quota.tenant.follower.broker.min.consumer.rate", this.minPerTenantFollowerBrokerConsumerRate, "confluent.quota.tenant.broker.max.producer.rate", this.maxPerTenantBrokerProducerRate, "confluent.quota.tenant.broker.max.consumer.rate", this.maxPerTenantBrokerConsumerRate, "confluent.quota.tenant.default.controller.mutation.rate", this.defaultPerTenantControllerMutationRate, "confluent.quota.tenant.produce.multiplier", this.tenantProduceQuotaMultiplier, "confluent.quota.tenant.fetch.multiplier", this.tenantFetchQuotaMultiplier, "confluent.quota.tenant.user.quotas.enable", this.tenantUserQuotasEnabled});
    }

    private synchronized void reconfigureQuotas() {
        this.updateDefaultQuota(this.defaultTenantQuota);
        for (TenantQuota tenantQuota : this.tenantQuotas.values()) {
            tenantQuota.updateBrokerQuota();
        }
        this.quotaResetPending.get(ClientQuotaType.CONTROLLER_MUTATION).getAndSet(true);
        this.quotaResetPending.get(ClientQuotaType.PRODUCE).getAndSet(true);
        this.quotaResetPending.get(ClientQuotaType.FETCH).getAndSet(true);
    }

    public Map<String, String> quotaMetricTags(ClientQuotaType quotaType, KafkaPrincipal principal, String clientId) {
        if (principal instanceof MultiTenantPrincipal) {
            TenantMetadata tenantMetadata = ((MultiTenantPrincipal)principal).tenantMetadata();
            String tenant = tenantMetadata.tenantName;
            TenantQuota tenantQuota = this.getOrCreateTenantQuota(tenant, this.defaultTenantQuota, false);
            if (!tenantQuota.hasQuotaLimit(quotaType)) {
                log.debug("Returning empty metric tags for tenant principal: {} without a quota for quotaType: {}", (Object)principal, (Object)quotaType);
                return Collections.emptyMap();
            }
            return this.tenantMetricTags(quotaType, tenantMetadata);
        }
        log.debug("Returning empty metric tags for non-tenant principal: {} for quotaType: {}", (Object)principal, (Object)quotaType);
        return Collections.emptyMap();
    }

    public Map<String, String> parentQuotaMetricTags(ClientQuotaType quotaType, Map<String, String> metricTags) {
        if (!this.tenantUserQuotasEnabled || !USER_CONFIGURABLE_QUOTAS.contains(quotaType)) {
            return Collections.emptyMap();
        }
        if (metricTags.containsKey("user-resource-id") && metricTags.containsKey("tenant")) {
            return Collections.singletonMap("tenant", metricTags.get("tenant"));
        }
        return Collections.emptyMap();
    }

    public Double quotaLimit(ClientQuotaType quotaType, Map<String, String> metricTags) {
        String tenant = metricTags.get("tenant");
        String userResourceId = metricTags.get("user-resource-id");
        if (tenant == null || tenant.isEmpty()) {
            return QuotaConfig.UNLIMITED_QUOTA.quota(quotaType);
        }
        TenantQuota tenantQuota = this.tenantQuotas.get(tenant);
        if (tenantQuota != null) {
            boolean returnTenantQuota = userResourceId == null || !this.tenantUserQuotasEnabled || !USER_CONFIGURABLE_QUOTAS.contains(quotaType);
            Double quotaLimit = returnTenantQuota ? tenantQuota.quotaLimit(quotaType) : tenantQuota.userQuotaLimit(quotaType, userResourceId);
            log.debug("Returning {} quota limit {} for metric tags {}", new Object[]{quotaType, quotaLimit, metricTags});
            return quotaLimit;
        }
        log.warn("Quota not found for tenant {}, using default quota", (Object)tenant);
        return this.defaultTenantQuota.quota(quotaType);
    }

    public synchronized void updateQuota(ClientQuotaType quotaType, ClientQuotaEntity quotaEntity, double newValue) {
        this.updateQuotaEntity(quotaType, quotaEntity, Optional.of(newValue));
    }

    public synchronized void removeQuota(ClientQuotaType quotaType, ClientQuotaEntity quotaEntity) {
        this.updateQuotaEntity(quotaType, quotaEntity, Optional.empty());
    }

    private void updateQuotaEntity(ClientQuotaType quotaType, ClientQuotaEntity quotaEntity, Optional<Double> newValue) {
        if (!USER_CONFIGURABLE_QUOTAS.contains(quotaType) || !this.tenantUserQuotasEnabled) {
            log.debug("Ignored {} quota configuration update for entity {} to {}", new Object[]{quotaType, quotaEntity, newValue});
        } else if (!this.isValidUserQuotaEntity(quotaEntity)) {
            log.warn("Ignored invalid {} quota configuration update for entity {} to {}", new Object[]{quotaType, quotaEntity, newValue});
        } else {
            String clientQuotaEntityName = ((ClientQuotaEntity.ConfigEntity)quotaEntity.configEntities().get(0)).name();
            String tenant = TenantHelpers.extractTenantPrefix((String)clientQuotaEntityName, (boolean)false);
            String serviceAccount = TenantHelpers.extractLogicalName((String)clientQuotaEntityName);
            TenantQuota tenantQuota = this.getOrCreateTenantQuota(tenant, this.defaultTenantQuota, false);
            double newQuotaValue = newValue.orElse(QuotaConfig.UNLIMITED_QUOTA.quota(quotaType));
            if (ConfigEntityName.Default().equals(serviceAccount)) {
                QuotaConfig newQuotaConfig = tenantQuota.defaultUserClusterQuotaConfig.withQuota(quotaType, newQuotaValue);
                tenantQuota.updateDefaultUserClusterQuota(newQuotaConfig);
                this.logServiceAccountQuota(tenant, serviceAccount, newQuotaConfig);
            } else {
                QuotaConfig newQuotaConfig = tenantQuota.userClusterQuotaConfigs.getOrDefault(serviceAccount, QuotaConfig.UNLIMITED_QUOTA).withQuota(quotaType, newQuotaValue);
                tenantQuota.updateUserClusterQuota(serviceAccount, newQuotaConfig);
                this.logServiceAccountQuota(tenant, serviceAccount, newQuotaConfig);
            }
        }
    }

    private boolean isValidUserQuotaEntity(ClientQuotaEntity quotaEntity) {
        if (quotaEntity.configEntities().size() != 1) {
            return false;
        }
        ClientQuotaEntity.ConfigEntity configEntity = (ClientQuotaEntity.ConfigEntity)quotaEntity.configEntities().get(0);
        if (configEntity.entityType() != ClientQuotaEntity.ConfigEntityType.USER) {
            return false;
        }
        return TenantHelpers.isTenantPrefixed((String)configEntity.name());
    }

    public boolean updateDynamicQuotas(Map<Map<String, String>, Map<String, Long>> dynamicQuotas) {
        boolean updated = false;
        for (Map.Entry<Map<String, String>, Map<String, Long>> entry : dynamicQuotas.entrySet()) {
            Long fetchQuota;
            Map<String, String> metricTags = entry.getKey();
            String tenant = metricTags.get("tenant");
            String userResourceId = metricTags.get("user-resource-id");
            if (tenant == null || userResourceId != null && !this.tenantUserQuotasEnabled) continue;
            Map<String, Long> quotas = entry.getValue();
            TenantQuota tenantQuota = this.getOrCreateTenantQuota(tenant, this.defaultTenantQuota, false);
            Long produceQuota = quotas.get(ClientQuotaType.PRODUCE.toString());
            if (produceQuota != null && produceQuota == 0L) {
                produceQuota = null;
            }
            if ((fetchQuota = quotas.get(ClientQuotaType.FETCH.toString())) != null && fetchQuota == 0L) {
                fetchQuota = null;
            }
            QuotaConfig dynamicBrokerQuotas = new QuotaConfig(produceQuota, fetchQuota, null, null, QuotaConfig.UNLIMITED_QUOTA);
            boolean isTenantQuota = userResourceId == null || userResourceId.isEmpty();
            QuotaConfig prevQuotasUsed = new QuotaConfig(this.quotaLimit(ClientQuotaType.PRODUCE, metricTags).longValue(), this.quotaLimit(ClientQuotaType.FETCH, metricTags).longValue(), this.quotaLimit(ClientQuotaType.REQUEST, metricTags), this.quotaLimit(ClientQuotaType.CONTROLLER_MUTATION, metricTags), QuotaConfig.UNLIMITED_QUOTA);
            if (isTenantQuota) {
                tenantQuota.updateDynamicBrokerQuota(dynamicBrokerQuotas);
            } else {
                tenantQuota.updateDynamicUserBrokerQuota(userResourceId, dynamicBrokerQuotas);
            }
            for (ClientQuotaType quotaType : ClientQuotaType.values()) {
                if (prevQuotasUsed.quota(quotaType) == this.quotaLimit(quotaType, metricTags).doubleValue()) continue;
                this.quotaResetPending.get(quotaType).getAndSet(true);
                updated = true;
            }
        }
        return updated;
    }

    public boolean quotaResetRequired(ClientQuotaType quotaType) {
        return this.quotaResetPending.get(quotaType).getAndSet(false);
    }

    public synchronized boolean updateClusterMetadata(Cluster cluster) {
        log.debug("Updating cluster metadata {}", (Object)cluster);
        this.cluster = cluster;
        HashMap<String, Set<Object>> brokersHostingLeaders = new HashMap<String, Set<Object>>();
        HashMap<String, Integer> tenantPartitionsOnThisBroker = new HashMap<String, Integer>();
        ((ConcurrentHashMap.KeySetView)this.tenantQuotas.keySet()).forEach(tenant -> tenantPartitionsOnThisBroker.put((String)tenant, 0));
        for (String topic : cluster.topics()) {
            String tenant2 = TenantQuotaCallback.topicTenant(topic);
            if (tenant2.isEmpty()) continue;
            for (PartitionInfo partitionInfo : cluster.partitionsForTopic(topic)) {
                Node leader = partitionInfo.leader();
                if (leader == null) continue;
                if (leader.id() == this.brokerId) {
                    tenantPartitionsOnThisBroker.merge(tenant2, 1, Integer::sum);
                }
                if (!brokersHostingLeaders.containsKey(tenant2)) {
                    brokersHostingLeaders.put(tenant2, new HashSet());
                }
                ((Set)brokersHostingLeaders.get(tenant2)).add(leader.id());
            }
        }
        boolean updated = false;
        for (Map.Entry entry : tenantPartitionsOnThisBroker.entrySet()) {
            String tenant3 = (String)entry.getKey();
            TenantQuota tenantQuota = this.getOrCreateTenantQuota(tenant3, this.defaultTenantQuota, false);
            int leaderPartitions = (Integer)entry.getValue();
            int brokersWithLeaders = brokersHostingLeaders.getOrDefault(tenant3, Collections.emptySet()).size();
            updated |= tenantQuota.updatePartitions(leaderPartitions, brokersWithLeaders);
        }
        if (updated) {
            log.trace("Some tenant quotas have been updated, new quotas: {}", this.tenantQuotas);
        }
        return updated;
    }

    public Double clusterQuotaLimit(ClientQuotaType quotaType, Map<String, String> metricTags) {
        String tenant = metricTags.get("tenant");
        String userResourceId = metricTags.get("user-resource-id");
        if (tenant == null || tenant.isEmpty()) {
            return QuotaConfig.UNLIMITED_QUOTA.quota(quotaType);
        }
        TenantQuota tenantQuota = this.tenantQuotas.get(tenant);
        if (tenantQuota != null) {
            boolean returnTenantQuota = userResourceId == null || !USER_CONFIGURABLE_QUOTAS.contains(quotaType);
            Double quotaLimit = returnTenantQuota ? tenantQuota.clusterQuotaLimit(quotaType) : tenantQuota.userClusterQuotaLimit(quotaType, userResourceId);
            log.debug("Returning cluster-level {} quota limit {} for metric tags {}", new Object[]{quotaType, quotaLimit, metricTags});
            return quotaLimit;
        }
        log.warn("Cluster-level quota not found for tenant {}, using default quota", (Object)tenant);
        return this.defaultTenantQuota.quota(quotaType);
    }

    public Cluster cluster() {
        return this.cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<Integer, TenantQuotaCallback> map = INSTANCES;
        synchronized (map) {
            INSTANCES.remove(this.brokerId);
        }
    }

    TenantQuota getOrCreateTenantQuota(String tenant, QuotaConfig clusterQuotaConfig, boolean forceUpdate) {
        TenantQuota tenantQuota = new TenantQuota(clusterQuotaConfig);
        TenantQuota prevQuota = this.tenantQuotas.putIfAbsent(tenant, tenantQuota);
        if (prevQuota != null) {
            tenantQuota = prevQuota;
            if (forceUpdate) {
                QuotaConfig prevQuotas = tenantQuota.updateClusterQuota(clusterQuotaConfig);
                boolean updated = false;
                for (ClientQuotaType quotaType : ClientQuotaType.values()) {
                    if (prevQuotas.quota(quotaType) == tenantQuota.quotaLimit(quotaType).doubleValue()) continue;
                    this.quotaResetPending.get(quotaType).getAndSet(true);
                    updated = true;
                }
                if (updated) {
                    this.logTenantQuota(tenant, tenantQuota);
                }
            }
        } else if (forceUpdate) {
            for (ClientQuotaType quotaType : ClientQuotaType.values()) {
                this.quotaResetPending.get(quotaType).getAndSet(true);
            }
            this.logTenantQuota(tenant, tenantQuota);
        }
        return tenantQuota;
    }

    private void logTenantQuota(String tenant, TenantQuota tenantQuota) {
        log.info("Updated tenant {} quota: {}={}, {}={}, {}={}, {}={}", new Object[]{tenant, ClientQuotaType.PRODUCE, tenantQuota.quotaLimit(ClientQuotaType.PRODUCE), ClientQuotaType.FETCH, tenantQuota.quotaLimit(ClientQuotaType.FETCH), ClientQuotaType.REQUEST, tenantQuota.quotaLimit(ClientQuotaType.REQUEST), ClientQuotaType.CONTROLLER_MUTATION, tenantQuota.quotaLimit(ClientQuotaType.CONTROLLER_MUTATION)});
    }

    private void logServiceAccountQuota(String tenant, String serviceAccount, QuotaConfig quotaConfig) {
        log.info("Updated tenant {} service account {} quota config: {}", new Object[]{tenant, serviceAccount, quotaConfig});
    }

    private void updateDefaultQuota(QuotaConfig defaultTenantQuota) {
        this.defaultTenantQuota = new QuotaConfig(defaultTenantQuota.quota(ClientQuotaType.PRODUCE), defaultTenantQuota.quota(ClientQuotaType.FETCH), defaultTenantQuota.quota(ClientQuotaType.REQUEST), this.defaultPerTenantControllerMutationRate);
    }

    private synchronized void updateTenantQuotas(Map<String, QuotaConfig> tenantClusterQuotas, QuotaConfig defaultTenantQuota) {
        this.updateDefaultQuota(defaultTenantQuota);
        if (!this.tenantUserQuotasEnabled) {
            ((ConcurrentHashMap.CollectionView)((Object)this.tenantQuotas.keySet())).retainAll(tenantClusterQuotas.keySet());
        }
        for (Map.Entry<String, QuotaConfig> entry : tenantClusterQuotas.entrySet()) {
            this.getOrCreateTenantQuota(entry.getKey(), entry.getValue(), true);
        }
        log.trace("Updated tenant quotas, new quotas: {}", this.tenantQuotas);
    }

    private synchronized void updateTenantUserQuotas(String tenant, Map<String, QuotaConfig> userClusterQuotas, QuotaConfig defaultUserQuota) {
        TenantQuota tenantQuota = this.getOrCreateTenantQuota(tenant, this.defaultTenantQuota, false);
        tenantQuota.updateDefaultUserClusterQuota(defaultUserQuota);
        userClusterQuotas.forEach(tenantQuota::updateUserClusterQuota);
        USER_CONFIGURABLE_QUOTAS.forEach(quotaType -> this.quotaResetPending.get(quotaType).getAndSet(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateQuotas(Map<String, QuotaConfig> tenantQuotas, QuotaConfig defaultTenantQuota) {
        log.debug("Update quotas: tenantQuotas={} default={}", tenantQuotas, (Object)defaultTenantQuota);
        Map<Integer, TenantQuotaCallback> map = INSTANCES;
        synchronized (map) {
            INSTANCES.values().forEach(callback -> callback.updateTenantQuotas(tenantQuotas, defaultTenantQuota));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateUserQuotas(String tenant, Map<String, QuotaConfig> userQuotas, QuotaConfig defaultUserQuota) {
        log.debug("Update {} quotas: userQuotas={} default={}", new Object[]{tenant, userQuotas, defaultUserQuota});
        Map<Integer, TenantQuotaCallback> map = INSTANCES;
        synchronized (map) {
            INSTANCES.values().forEach(callback -> callback.updateTenantUserQuotas(tenant, userQuotas, defaultUserQuota));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeAll() {
        Map<Integer, TenantQuotaCallback> map = INSTANCES;
        synchronized (map) {
            while (!INSTANCES.isEmpty()) {
                INSTANCES.values().iterator().next().close();
            }
        }
    }

    private static String topicTenant(String topic) {
        if (TenantContext.isTenantPrefixed(topic)) {
            return TenantContext.extractTenant(topic);
        }
        return "";
    }

    private Map<String, String> tenantMetricTags(ClientQuotaType quotaType, TenantMetadata tenant) {
        if (ClientQuotaType.CONTROLLER_MUTATION.equals((Object)quotaType) || !this.tenantUserQuotasEnabled) {
            return Collections.singletonMap("tenant", tenant.tenantName);
        }
        HashMap<String, String> tags = new HashMap<String, String>((int)Math.ceil(2.6666666666666665));
        tags.put("tenant", tenant.tenantName);
        if (tenant.userResourceId != null) {
            tags.put("user-resource-id", tenant.userResourceId);
        }
        return tags;
    }

    static {
        RECONFIGURABLE_CONFIGS.add("confluent.quota.tenant.default.controller.mutation.rate");
        RECONFIGURABLE_CONFIGS.add("confluent.quota.tenant.user.quotas.enable");
        RECONFIGURABLE_CONFIGS.add("confluent.quota.tenant.produce.multiplier");
        RECONFIGURABLE_CONFIGS.add("confluent.quota.tenant.fetch.multiplier");
    }

    class TenantQuota {
        private int leaderPartitions = 0;
        private int brokersWithLeaders = 0;
        QuotaConfig clusterQuotaConfig;
        private volatile QuotaConfig brokerQuotas;
        private volatile QuotaConfig dynamicBrokerQuotas;
        private final ConcurrentHashMap<String, QuotaConfig> userClusterQuotaConfigs;
        private final ConcurrentHashMap<String, QuotaConfig> userBrokerQuotaConfigs;
        private final ConcurrentHashMap<String, QuotaConfig> dynamicUserBrokerQuotaConfigs;
        private QuotaConfig defaultUserClusterQuotaConfig;
        private QuotaConfig defaultUserBrokerQuotaConfig;

        public TenantQuota(QuotaConfig clusterQuotaConfig) {
            this.clusterQuotaConfig = clusterQuotaConfig;
            this.userClusterQuotaConfigs = new ConcurrentHashMap();
            this.userBrokerQuotaConfigs = new ConcurrentHashMap();
            this.dynamicUserBrokerQuotaConfigs = new ConcurrentHashMap();
            this.defaultUserClusterQuotaConfig = QuotaConfig.UNLIMITED_QUOTA;
            this.dynamicBrokerQuotas = null;
            this.updateBrokerQuota();
        }

        boolean updatePartitions(int leaderPartitions, int brokersWithLeaders) {
            if (leaderPartitions == this.leaderPartitions && brokersWithLeaders == this.brokersWithLeaders) {
                return false;
            }
            this.leaderPartitions = leaderPartitions;
            this.brokersWithLeaders = brokersWithLeaders;
            return this.updateBrokerQuota();
        }

        QuotaConfig updateClusterQuota(QuotaConfig clusterQuotaConfig) {
            QuotaConfig oldBrokerQuotas = this.brokerQuotas;
            if (!clusterQuotaConfig.equals(this.clusterQuotaConfig)) {
                this.clusterQuotaConfig = clusterQuotaConfig;
                this.brokerQuotas = this.computeBrokerQuota(clusterQuotaConfig);
            }
            return oldBrokerQuotas;
        }

        QuotaConfig updateUserClusterQuota(String userResourceId, QuotaConfig userClusterQuotaConfig) {
            QuotaConfig oldUserBrokerQuotas = this.userBrokerQuotaConfigs.get(userResourceId);
            QuotaConfig oldUserQuotas = this.userClusterQuotaConfigs.get(userResourceId);
            if (!userClusterQuotaConfig.equals(oldUserQuotas)) {
                this.userClusterQuotaConfigs.put(userResourceId, userClusterQuotaConfig);
                this.userBrokerQuotaConfigs.put(userResourceId, this.computeBrokerQuota(userClusterQuotaConfig));
            }
            return oldUserBrokerQuotas;
        }

        QuotaConfig updateDefaultUserClusterQuota(QuotaConfig userClusterQuotaConfig) {
            QuotaConfig oldDefaultUserBrokerQuotas = this.defaultUserBrokerQuotaConfig;
            if (!this.defaultUserClusterQuotaConfig.equals(userClusterQuotaConfig)) {
                this.defaultUserClusterQuotaConfig = userClusterQuotaConfig;
                this.defaultUserBrokerQuotaConfig = this.computeBrokerQuota(userClusterQuotaConfig);
            }
            return oldDefaultUserBrokerQuotas;
        }

        boolean updateBrokerQuota() {
            QuotaConfig oldBrokerQuotas = this.brokerQuotas;
            this.brokerQuotas = this.computeBrokerQuota(this.clusterQuotaConfig);
            boolean updated = !Objects.equals(oldBrokerQuotas, this.brokerQuotas);
            QuotaConfig oldDefaultUserBrokerQuota = this.defaultUserBrokerQuotaConfig;
            this.defaultUserBrokerQuotaConfig = this.computeBrokerQuota(this.defaultUserClusterQuotaConfig);
            updated |= !Objects.equals(oldDefaultUserBrokerQuota, this.defaultUserBrokerQuotaConfig);
            ConcurrentHashMap<String, QuotaConfig> oldUserBrokerQuotas = new ConcurrentHashMap<String, QuotaConfig>(this.userBrokerQuotaConfigs);
            this.userBrokerQuotaConfigs.clear();
            this.userBrokerQuotaConfigs.putAll(this.userClusterQuotaConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.computeBrokerQuota((QuotaConfig)entry.getValue()))));
            return updated |= Objects.equals(oldUserBrokerQuotas, this.userBrokerQuotaConfigs);
        }

        QuotaConfig updateDynamicBrokerQuota(QuotaConfig dynamicBrokerQuotas) {
            QuotaConfig oldDynamicBrokerQuota = this.dynamicBrokerQuotas;
            if (!dynamicBrokerQuotas.equals(this.dynamicBrokerQuotas)) {
                this.dynamicBrokerQuotas = dynamicBrokerQuotas;
            }
            return oldDynamicBrokerQuota;
        }

        QuotaConfig updateDynamicUserBrokerQuota(String userResourceId, QuotaConfig dynamicBrokerQuotas) {
            QuotaConfig oldDynamicUserBrokerQuotas = this.dynamicUserBrokerQuotaConfigs.get(userResourceId);
            if (!dynamicBrokerQuotas.equals(oldDynamicUserBrokerQuotas)) {
                this.dynamicUserBrokerQuotaConfigs.put(userResourceId, dynamicBrokerQuotas);
            }
            return oldDynamicUserBrokerQuotas;
        }

        private QuotaConfig computeBrokerQuota(QuotaConfig clusterQuotaConfig) {
            Long produceQuota = this.computeBandwidthQuota(ClientQuotaType.PRODUCE, clusterQuotaConfig, TenantQuotaCallback.this.minPerTenantFollowerBrokerProducerRate, TenantQuotaCallback.this.maxPerTenantBrokerProducerRate, TenantQuotaCallback.this.tenantProduceQuotaMultiplier);
            Long consumeQuota = this.computeBandwidthQuota(ClientQuotaType.FETCH, clusterQuotaConfig, TenantQuotaCallback.this.minPerTenantFollowerBrokerConsumerRate, TenantQuotaCallback.this.maxPerTenantBrokerConsumerRate, TenantQuotaCallback.this.tenantFetchQuotaMultiplier);
            return new QuotaConfig(produceQuota, consumeQuota, clusterQuotaConfig.quota(ClientQuotaType.REQUEST), TenantQuotaCallback.this.defaultPerTenantControllerMutationRate, QuotaConfig.UNLIMITED_QUOTA);
        }

        private Long computeBandwidthQuota(ClientQuotaType quotaType, QuotaConfig clusterQuotaConfig, long minPerTenantQuota, long maxPerTenantQuota, double quotaMultiplier) {
            if (clusterQuotaConfig.hasQuotaLimit(quotaType)) {
                if (this.leaderPartitions == 0) {
                    return minPerTenantQuota;
                }
                long computedQuota = clusterQuotaConfig.equalQuotaPerBrokerOrUnlimited(quotaType, this.brokersWithLeaders, minPerTenantQuota);
                return Math.min(maxPerTenantQuota, Math.round(quotaMultiplier * (double)computedQuota));
            }
            return (long)QuotaConfig.UNLIMITED_QUOTA.quota(quotaType);
        }

        boolean hasQuotaLimit(ClientQuotaType quotaType) {
            if (this.dynamicBrokerQuotas != null && this.dynamicBrokerQuotas.hasQuotaLimit(quotaType)) {
                return true;
            }
            return this.brokerQuotas.hasQuotaLimit(quotaType);
        }

        Double quotaLimit(ClientQuotaType quotaType) {
            if (this.dynamicBrokerQuotas != null && this.dynamicBrokerQuotas.hasQuotaLimit(quotaType)) {
                return this.dynamicBrokerQuotas.quota(quotaType);
            }
            return this.brokerQuotas.quota(quotaType);
        }

        Double clusterQuotaLimit(ClientQuotaType quotaType) {
            return this.clusterQuotaConfig.quota(quotaType);
        }

        Double userQuotaLimit(ClientQuotaType quotaType, String userResourceId) {
            QuotaConfig dynamicUserBrokerQuota = this.dynamicUserBrokerQuotaConfigs.get(userResourceId);
            QuotaConfig userBrokerQuota = this.userBrokerQuotaConfigs.get(userResourceId);
            if (dynamicUserBrokerQuota != null && dynamicUserBrokerQuota.hasQuotaLimit(quotaType)) {
                return dynamicUserBrokerQuota.quota(quotaType);
            }
            if (userBrokerQuota != null && userBrokerQuota.hasQuotaLimit(quotaType)) {
                return userBrokerQuota.quota(quotaType);
            }
            return this.defaultUserBrokerQuotaConfig.quota(quotaType);
        }

        Double userClusterQuotaLimit(ClientQuotaType quotaType, String userResourceId) {
            QuotaConfig userClusterBrokerQuota = this.userClusterQuotaConfigs.getOrDefault(userResourceId, this.defaultUserClusterQuotaConfig);
            return userClusterBrokerQuota.quota(quotaType);
        }

        public String toString() {
            return "TenantQuota(brokersWithLeaders=" + this.brokersWithLeaders + ", leaderPartitions=" + this.leaderPartitions + ", clusterQuotaConfig=" + this.clusterQuotaConfig + ", brokerQuotas=" + this.brokerQuotas + ",dynamicBrokerQuota=" + this.dynamicBrokerQuotas + ") ";
        }
    }

    private static class TenantQuotaCallbackConfig
    extends AbstractConfig {
        private static final ConfigDef CONFIG = new ConfigDef().define("confluent.quota.tenant.follower.broker.min.producer.rate", ConfigDef.Type.LONG, (Object)0xA00000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1L), ConfigDef.Importance.HIGH, "Minimum producer quota in bytes/s per tenant per broker that has no leaders for tenant's partitions").define("confluent.quota.tenant.follower.broker.min.consumer.rate", ConfigDef.Type.LONG, (Object)0xA00000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1L), ConfigDef.Importance.HIGH, "Minimum consumer quota in bytes/s per tenant per broker that has no leaders for tenant's partitions").define("confluent.quota.tenant.broker.max.producer.rate", ConfigDef.Type.LONG, (Object)0xC80000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1L), ConfigDef.Importance.HIGH, "Maximum producer quota in bytes/s per tenant per broker").define("confluent.quota.tenant.broker.max.consumer.rate", ConfigDef.Type.LONG, (Object)0xC80000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1L), ConfigDef.Importance.HIGH, "Maximum consumer quota in bytes/s per tenant per broker").define("confluent.quota.tenant.default.controller.mutation.rate", ConfigDef.Type.DOUBLE, (Object)2.147483647E9, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0.1), ConfigDef.Importance.HIGH, "The rate per tenant at which mutations are accepted for the create topics request, the create partitions request and the delete topics request. The rate is accumulated by the number of partitions created or deleted.").define("confluent.quota.tenant.produce.multiplier", ConfigDef.Type.DOUBLE, (Object)ConfluentConfigs.TENANT_PRODUCE_QUOTA_MULTIPLIER_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1.0), ConfigDef.Importance.HIGH, "Broker-wide produce bandwidth limit multiplier for tenant quotas.").define("confluent.quota.tenant.fetch.multiplier", ConfigDef.Type.DOUBLE, (Object)ConfluentConfigs.TENANT_FETCH_QUOTA_MULTIPLIER_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1.0), ConfigDef.Importance.HIGH, "Broker-wide fetch bandwidth limit multiplier for tenant quotas.").define("confluent.quota.tenant.user.quotas.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "confluent.quota.tenant.user.quotas.enable");

        public TenantQuotaCallbackConfig(Map<String, ?> configs) {
            super(CONFIG, configs);
            if (this.maxPerTenantBrokerConsumerRate() < this.minPerTenantFollowerBrokerConsumerRate()) {
                throw new ConfigException("confluent.quota.tenant.broker.max.consumer.rate", (Object)this.maxPerTenantBrokerConsumerRate(), "must be >= " + this.minPerTenantFollowerBrokerConsumerRate());
            }
            if (this.maxPerTenantBrokerProducerRate() < this.minPerTenantFollowerBrokerProducerRate()) {
                throw new ConfigException("confluent.quota.tenant.broker.max.producer.rate", (Object)this.maxPerTenantBrokerProducerRate(), "must be >= " + this.minPerTenantFollowerBrokerProducerRate());
            }
        }

        public long maxPerTenantBrokerProducerRate() {
            return this.getLong("confluent.quota.tenant.broker.max.producer.rate");
        }

        public long maxPerTenantBrokerConsumerRate() {
            return this.getLong("confluent.quota.tenant.broker.max.consumer.rate");
        }

        public long minPerTenantFollowerBrokerProducerRate() {
            return this.getLong("confluent.quota.tenant.follower.broker.min.producer.rate");
        }

        public long minPerTenantFollowerBrokerConsumerRate() {
            return this.getLong("confluent.quota.tenant.follower.broker.min.consumer.rate");
        }

        public double defaultPerTenantControllerMutationRate() {
            return this.getDouble("confluent.quota.tenant.default.controller.mutation.rate");
        }

        public double tenantProduceQuotaMultiplier() {
            return this.getDouble("confluent.quota.tenant.produce.multiplier");
        }

        public double tenantFetchQuotaMultiplier() {
            return this.getDouble("confluent.quota.tenant.fetch.multiplier");
        }

        public boolean tenantUserQuotasEnabled() {
            return this.getBoolean("confluent.quota.tenant.user.quotas.enable");
        }
    }
}

