/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.metrics.ApiKeyConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.ConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.ConnectionSensors;
import io.confluent.kafka.multitenant.metrics.IpConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.PartitionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.PartitionSensors;
import java.net.InetAddress;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.metrics.ApiSensorBuilder;
import org.apache.kafka.server.metrics.ApiSensors;
import org.apache.kafka.server.metrics.MetricsBuilderContext;

public class TenantMetrics {
    static final String API_KEY_METHOD = "SASL/PLAIN";
    final EnumMap<ApiKeys, ApiSensors> apiSensors = new EnumMap(ApiKeys.class);
    final EnumMap<ApiKeys, ApiSensors> aggregateApiSensors = new EnumMap(ApiKeys.class);
    private ConnectionSensors connectionSensors;
    private ConnectionSensors ipConnectionSensors;
    private ConnectionSensors apiKeySensors;
    private PartitionSensors partitionSensors;

    public void recordAuthenticatedConnection(Metrics metrics, MultiTenantPrincipal principal, InetAddress clientAddress) {
        if (this.connectionSensors == null) {
            this.connectionSensors = new ConnectionSensorBuilder(metrics, principal).build();
            this.connectionSensors.recordAuthenticatedConnection();
        }
        if (this.ipConnectionSensors == null) {
            this.ipConnectionSensors = new IpConnectionSensorBuilder(metrics, principal, clientAddress).build();
            this.ipConnectionSensors.recordAuthenticatedConnection();
        }
        if (this.apiKeySensors == null && principal.tenantMetadata().isApiKeyAuthenticated) {
            this.apiKeySensors = new ApiKeyConnectionSensorBuilder(metrics, principal).build();
            this.apiKeySensors.recordAuthenticatedConnection();
        }
    }

    public void recordAuthenticatedDisconnection() {
        if (this.connectionSensors != null) {
            this.connectionSensors.recordAuthenticatedDisconnection();
            this.connectionSensors = null;
        }
        if (this.ipConnectionSensors != null) {
            this.ipConnectionSensors.recordAuthenticatedDisconnection();
            this.ipConnectionSensors = null;
        }
        if (this.apiKeySensors != null) {
            this.apiKeySensors.recordAuthenticatedDisconnection();
            this.apiKeySensors = null;
        }
    }

    public void recordRequest(Metrics metrics, MetricsRequestContext context, long requestSize, long currentTimeMs) {
        ApiSensors sensors = this.apiSensors(metrics, context, apiSensors -> apiSensors.requestSensorsExpired(metrics));
        sensors.recordRequest(requestSize, currentTimeMs);
        sensors = this.aggregateApiSensors(metrics, new AggregateTenantMetricsContext(context.apiKey), apiSensors -> apiSensors.requestSensorsExpired(metrics));
        sensors.recordRequest(requestSize, currentTimeMs);
    }

    public void recordResponse(Metrics metrics, MetricsRequestContext context, long responseSize, long responseTimeNanos, Map<Errors, Integer> errorCounts, long currentTimeMs) {
        ApiKeys apiKey = context.apiKey();
        ApiSensors sensors = this.apiSensors(metrics, context, apiSensors -> apiSensors.responseSensorsExpired(metrics));
        Set newErrors = sensors.errorsWithoutSensors(metrics, errorCounts.keySet());
        if (!newErrors.isEmpty()) {
            ApiSensorBuilder builder = new ApiSensorBuilder(metrics, (MetricsBuilderContext)context, apiKey);
            builder.addErrorSensors(sensors, newErrors);
        }
        sensors.recordResponse(responseSize, responseTimeNanos, currentTimeMs);
        sensors.recordErrors(errorCounts, currentTimeMs);
        sensors = this.aggregateApiSensors(metrics, new AggregateTenantMetricsContext(context.apiKey), apiSensors -> apiSensors.responseSensorsExpired(metrics));
        newErrors = sensors.errorsWithoutSensors(metrics, errorCounts.keySet());
        if (!newErrors.isEmpty()) {
            new ApiSensorBuilder(metrics, (MetricsBuilderContext)context, apiKey).addErrorSensors(sensors, newErrors);
        }
        sensors.recordResponse(responseSize, responseTimeNanos, currentTimeMs);
        sensors.recordErrors(errorCounts, currentTimeMs);
    }

    public void recordPartitionStatsIn(Metrics metrics, MetricsRequestContext context, TopicPartition topicPartition, int size, int numRecords, long timeMs) {
        this.partitionSensors(metrics, context).recordStatsIn(topicPartition, size, numRecords, timeMs);
    }

    public void recordPartitionStatsOut(Metrics metrics, MetricsRequestContext context, TopicPartition topicPartition, int size, int numRecords, long timeMs) {
        this.partitionSensors(metrics, context).recordStatsOut(topicPartition, size, numRecords, timeMs);
    }

    public static boolean isExpired(Metrics metrics, Sensor sensor) {
        return metrics.getSensor(sensor.name()) != sensor;
    }

    private ApiSensors apiSensors(Metrics metrics, MetricsRequestContext context, Predicate<ApiSensors> expiredPred) {
        ApiKeys apiKey = context.apiKey();
        ApiSensors sensors = this.apiSensors.get(apiKey);
        if (sensors == null || expiredPred.test(sensors)) {
            sensors = new ApiSensorBuilder(metrics, (MetricsBuilderContext)context, apiKey).build();
            this.apiSensors.put(apiKey, sensors);
        }
        return sensors;
    }

    private ApiSensors aggregateApiSensors(Metrics metrics, AggregateTenantMetricsContext context, Predicate<ApiSensors> expiredPred) {
        ApiKeys apiKey = context.apiKey();
        ApiSensors sensors = this.aggregateApiSensors.get(apiKey);
        if (sensors == null || expiredPred.test(sensors)) {
            sensors = new ApiSensorBuilder(metrics, (MetricsBuilderContext)context, apiKey).build();
            this.aggregateApiSensors.put(apiKey, sensors);
        }
        return sensors;
    }

    private PartitionSensors partitionSensors(Metrics metrics, MetricsRequestContext context) {
        if (this.partitionSensors == null) {
            this.partitionSensors = new PartitionSensorBuilder(metrics, context).build();
        }
        return this.partitionSensors;
    }

    public static class MetricsRequestContext
    extends TenantMetricsContext {
        private final String clientId;
        private final ApiKeys apiKey;

        public MetricsRequestContext(MultiTenantPrincipal principal, String clientId, ApiKeys apiKey) {
            super(principal);
            this.clientId = clientId;
            this.apiKey = apiKey;
        }

        public String clientId() {
            return this.clientId;
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }
    }

    public static class AggregateTenantMetricsContext
    implements MetricsBuilderContext {
        static final String AGGREGATE_TAG = "aggregate";
        private final ApiKeys apiKey;

        public AggregateTenantMetricsContext(ApiKeys apiKey) {
            this.apiKey = apiKey;
        }

        public String metricsGroup() {
            return String.format("%s-%s", AGGREGATE_TAG, "tenant-metrics");
        }

        public Map<String, String> metricTags() {
            return new HashMap<String, String>();
        }

        public String sensorSuffix() {
            return String.format(":%s-%s", AGGREGATE_TAG, this.apiKey);
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }
    }

    public static class ApiKeyMetricsContext
    extends TenantMetricsContext {
        public ApiKeyMetricsContext(MultiTenantPrincipal principal) {
            super(principal);
        }

        public static Map<String, String> metricTags(String key, String user) {
            return ApiKeyMetricsContext.metricTags(TenantMetrics.API_KEY_METHOD, key, user, null);
        }

        private static Map<String, String> metricTags(String method, String key, String user, String userResourceId) {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("auth-method", method);
            tags.put("auth-credential", key);
            tags.put("user", user);
            if (userResourceId != null) {
                tags.put("user-resource-id", userResourceId);
            }
            return tags;
        }

        @Override
        public Map<String, String> metricTags() {
            assert (this.principal().tenantMetadata().isApiKeyAuthenticated);
            return ApiKeyMetricsContext.metricTags(TenantMetrics.API_KEY_METHOD, this.principal().authenticationId(), this.principal().user(), this.principal().tenantMetadata().userResourceId);
        }

        @Override
        public String sensorSuffix() {
            StringBuilder builder = new StringBuilder();
            this.metricTags().forEach((tag, value) -> builder.append(":").append((String)tag).append("-").append((String)value));
            return builder.toString();
        }
    }

    public static class TenantIpMetricsContext
    extends TenantMetricsContext {
        private final InetAddress clientAddress;

        public TenantIpMetricsContext(MultiTenantPrincipal principal, InetAddress clientAddress) {
            super(principal);
            this.clientAddress = clientAddress;
        }

        @Override
        public Map<String, String> metricTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tenant", this.principal().tenantMetadata().tenantName);
            tags.put("ip", this.clientAddress.getHostAddress());
            return tags;
        }

        @Override
        public String sensorSuffix() {
            return String.format(":%s-%s:%s-%s", "tenant", this.principal().tenantMetadata().tenantName, "ip", this.clientAddress.getHostAddress());
        }
    }

    public static class TenantMetricsContext
    implements MetricsBuilderContext {
        private final MultiTenantPrincipal principal;

        public TenantMetricsContext(MultiTenantPrincipal principal) {
            this.principal = principal;
        }

        public MultiTenantPrincipal principal() {
            return this.principal;
        }

        public String metricsGroup() {
            return "tenant-metrics";
        }

        public Map<String, String> metricTags() {
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("tenant", this.principal.tenantMetadata().tenantName);
            tags.put("user", this.principal.user());
            if (this.principal.tenantMetadata().userResourceId != null) {
                tags.put("user-resource-id", this.principal.tenantMetadata().userResourceId);
            }
            return tags;
        }

        public String sensorSuffix() {
            if (this.principal.tenantMetadata().userResourceId != null) {
                return String.format(":%s-%s:%s-%s:%s-%s", "tenant", this.principal.tenantMetadata().tenantName, "user", this.principal.user(), "user-resource-id", this.principal.tenantMetadata().userResourceId);
            }
            return String.format(":%s-%s:%s-%s", "tenant", this.principal.tenantMetadata().tenantName, "user", this.principal.user());
        }
    }
}

