/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.metrics.PartitionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.server.metrics.AbstractSensorCreator;

public class PartitionSensors {
    static final long PARTITION_SENSOR_EXPIRY_SECONDS = 3600L;
    final ThroughputSensors in;
    final ThroughputSensors out;

    public PartitionSensors(TenantMetrics.MetricsRequestContext context, Metrics metrics, PartitionSensorBuilder sensorBuilder) {
        this.in = new ThroughputSensors(context, metrics, "partition-bytes-in", "partition-records-in", sensorBuilder);
        this.out = new ThroughputSensors(context, metrics, "partition-bytes-out", "partition-records-out", sensorBuilder);
    }

    public void recordStatsIn(TopicPartition tp, long bytes, long numRecords, long timeMs) {
        this.in.record(tp, bytes, numRecords, timeMs);
    }

    public void recordStatsOut(TopicPartition tp, long bytes, long numRecords, long timeMs) {
        this.out.record(tp, bytes, numRecords, timeMs);
    }

    static class PartitionDetailSensorCreator
    extends AbstractSensorCreator {
        private final String tenant;
        private final String clientId;
        private final TopicPartition tp;

        PartitionDetailSensorCreator(String name, String descriptiveName, String tenant, String clientId, TopicPartition tp) {
            super(name, descriptiveName);
            this.tenant = tenant;
            this.clientId = clientId;
            this.tp = tp;
        }

        public Sensor createSensor(Metrics metrics, String sensorName) {
            Sensor sensor = super.createSensor(metrics, sensorName, 3600L);
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("io-confluent-jmx-ignore", "");
            tags.put("tenant", this.tenant);
            tags.put("client-id", this.clientId);
            tags.put("topic", this.tp.topic());
            tags.put("partition", String.valueOf(this.tp.partition()));
            sensor.add((CompoundStat)this.createMeter(metrics, "tenant-metrics", tags, this.name, this.name));
            return sensor;
        }
    }

    static class PartitionDetailSensors {
        final Sensor bytesSensor;
        final Sensor recordsSensor;

        public PartitionDetailSensors(Sensor bytesSensor, Sensor recordsSensor) {
            this.bytesSensor = bytesSensor;
            this.recordsSensor = recordsSensor;
        }

        boolean anyExpired(Metrics metrics) {
            return TenantMetrics.isExpired(metrics, this.bytesSensor) || TenantMetrics.isExpired(metrics, this.recordsSensor);
        }
    }

    static class ThroughputSensors {
        private final String bytesMetricName;
        private final String recordsMetricName;
        private final String tenant;
        private final String clientId;
        private final Metrics metrics;
        private final PartitionSensorBuilder partitionSensorBuilder;
        private final Map<TopicPartition, PartitionDetailSensors> partitionSensors;

        ThroughputSensors(TenantMetrics.MetricsRequestContext context, Metrics metrics, String bytesMetricName, String recordsMetricName, PartitionSensorBuilder partitionSensorBuilder) {
            this.bytesMetricName = bytesMetricName;
            this.recordsMetricName = recordsMetricName;
            this.tenant = context.principal().tenantMetadata().tenantName;
            this.clientId = context.clientId();
            this.metrics = metrics;
            this.partitionSensorBuilder = partitionSensorBuilder;
            this.partitionSensors = new ConcurrentHashMap<TopicPartition, PartitionDetailSensors>();
        }

        void record(TopicPartition tp, long bytes, long numRecords, long currentTimeMs) {
            PartitionDetailSensors partitionSensors = this.partitionDetailSensors(tp, this.metrics);
            partitionSensors.bytesSensor.record((double)bytes, currentTimeMs);
            partitionSensors.recordsSensor.record((double)numRecords, currentTimeMs);
        }

        PartitionDetailSensors partitionDetailSensors(TopicPartition tp, Metrics metrics) {
            PartitionDetailSensors partitionSensor = this.partitionSensors.get(tp);
            if (partitionSensor != null && !partitionSensor.anyExpired(metrics)) {
                return partitionSensor;
            }
            String bytesSensorName = String.format("%s:%s-%s:%s-%s:%s-%s,%s-%s", this.bytesMetricName, "tenant", this.tenant, "client-id", this.clientId, "topic", tp.topic(), "partition", tp.partition());
            String recordsSensorName = String.format("%s:%s-%s:%s-%s:%s-%s,%s-%s", this.recordsMetricName, "tenant", this.tenant, "client-id", this.clientId, "topic", tp.topic(), "partition", tp.partition());
            PartitionDetailSensorCreator bytesSensorCreator = new PartitionDetailSensorCreator(this.bytesMetricName, this.bytesMetricName, this.tenant, this.clientId, tp);
            PartitionDetailSensorCreator recordsSensorCreator = new PartitionDetailSensorCreator(this.recordsMetricName, this.recordsMetricName, this.tenant, this.clientId, tp);
            HashMap<String, PartitionDetailSensorCreator> sensorCreators = new HashMap<String, PartitionDetailSensorCreator>(2);
            sensorCreators.put(bytesSensorName, bytesSensorCreator);
            sensorCreators.put(recordsSensorName, recordsSensorCreator);
            HashMap<String, String> sensorsToFind = new HashMap<String, String>(2);
            sensorsToFind.put(bytesSensorName, bytesSensorName);
            sensorsToFind.put(recordsSensorName, recordsSensorName);
            Map s = this.partitionSensorBuilder.getOrCreateSensors(sensorsToFind, sensorCreators);
            PartitionDetailSensors sensors = new PartitionDetailSensors((Sensor)s.get(bytesSensorName), (Sensor)s.get(recordsSensorName));
            this.partitionSensors.put(tp, sensors);
            return sensors;
        }
    }
}

