/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.assignor;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.assignor.TenantPartitionAssignor;
import java.util.Map;
import java.util.Optional;
import kafka.assignor.TopicReplicaAssignor;
import kafka.assignor.TopicReplicaAssignorBuilder;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantPartitionAssignorBuilder
implements TopicReplicaAssignorBuilder {
    private final Logger logger = LoggerFactory.getLogger(TenantPartitionAssignorBuilder.class);
    public volatile Cluster cluster = null;
    int maxPartitionsPerCreation = Integer.MAX_VALUE;

    public void configure(Map<String, ?> configs) {
        if (configs != null && configs.containsKey("confluent.multitenant.max.partitions.per.request")) {
            this.maxPartitionsPerCreation = (Integer)configs.get("confluent.multitenant.max.partitions.per.request");
            this.logger.info("{} configured with {} max partitions per topic/partition creation", (Object)this.getClass().getSimpleName(), (Object)this.maxPartitionsPerCreation);
        }
    }

    public Optional<TopicReplicaAssignor> maybeBuildAssignor(Optional<KafkaPrincipal> principalOpt) {
        if (!principalOpt.isPresent()) {
            this.logger.debug("No principal given, will not use TenantPartitionAssignor");
            return Optional.empty();
        }
        KafkaPrincipal principal = principalOpt.get();
        if (!(principal instanceof MultiTenantPrincipal)) {
            this.logger.error("The {} only supports principals of type {} but was given {}", new Object[]{TenantPartitionAssignor.class.getSimpleName(), MultiTenantPrincipal.class.getSimpleName(), principal == null ? "<null>" : principal.getClass().getSimpleName()});
            return Optional.empty();
        }
        MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)principal;
        try {
            TenantPartitionAssignor assignor = new TenantPartitionAssignor(this.cluster, multiTenantPrincipal.tenantMetadata().tenantName, this.maxPartitionsPerCreation);
            return Optional.of(assignor);
        }
        catch (Exception e) {
            this.logger.error("Exception while building TenantPartitionAssignor with principal {}", (Object)principal);
            return Optional.empty();
        }
    }

    public void updateClusterMetadata(Cluster cluster) {
        this.cluster = cluster;
    }
}

