/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.token;

import io.confluent.kafka.clients.plugins.auth.jwt.JwtVerificationException;
import io.confluent.kafka.server.plugins.auth.token.TokenBearerValidatorCallbackHandler;
import io.confluent.kafka.test.utils.TokenTestUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TokenBearerValidatorCallbackHandlerTest {
    private TokenTestUtils.JwsContainer jwsContainer;
    private String defaultIssuer = "Confluent";
    private String defaultSubject = "Customer";
    private Map<String, Object> configs;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.configs = new HashMap<String, Object>();
        this.configs.put("multitenant.metadata.dir", this.tempFolder.getRoot().getCanonicalPath());
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAttachesJws() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, this.defaultIssuer, this.defaultSubject);
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(this.jwsContainer.getJwsToken());
        callbackHandler.handle(new Callback[]{callback});
        Assert.assertNotNull((Object)callback.token());
        Assert.assertEquals((Object)this.jwsContainer.getJwsToken(), (Object)callback.token().value());
        Assert.assertNull((Object)callback.errorStatus());
    }

    @Test(expected=ConfigException.class)
    public void testConfigureRaisesExceptionWhenInvalidKeyPath() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, this.defaultIssuer, this.defaultSubject);
        Map<String, String> options = this.baseOptions();
        options.put("publicKeyPath", this.jwsContainer.getPublicKeyFile().getAbsolutePath() + "/invalid!");
        this.createCallbackHandler(options);
    }

    @Test(expected=JwtVerificationException.class)
    public void testRaisesJwtExceptionWhenInvalidJws() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, this.defaultIssuer, this.defaultSubject);
        TokenTestUtils.writePemFile(this.jwsContainer.getPublicKeyFile(), TokenTestUtils.generateKeyPair().getPublic());
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        callbackHandler.processToken(this.jwsContainer.getJwsToken());
    }

    @Test(expected=JwtVerificationException.class)
    public void testRaisesJwtExceptionWhenExpiredJws() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(50, this.defaultIssuer, this.defaultSubject);
        Thread.sleep(100L);
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        callbackHandler.processToken(this.jwsContainer.getJwsToken());
    }

    @Test(expected=JwtVerificationException.class)
    public void testRaisesJwtExceptionIfDifferentIssuer() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, "AWS", this.defaultSubject);
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        callbackHandler.processToken(this.jwsContainer.getJwsToken());
    }

    @Test(expected=JwtVerificationException.class)
    public void testRaisesJwtExceptionIfMissingSubject() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(36000, this.defaultIssuer, null);
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        callbackHandler.processToken(this.jwsContainer.getJwsToken());
    }

    @Test(expected=JwtVerificationException.class)
    public void testRaisesJwtExceptionIfNoExpirationTime() throws Exception {
        this.jwsContainer = TokenTestUtils.setUpJws(null, this.defaultIssuer, this.defaultSubject);
        TokenBearerValidatorCallbackHandler callbackHandler = this.createCallbackHandler(this.baseOptions());
        callbackHandler.processToken(this.jwsContainer.getJwsToken());
    }

    private TokenBearerValidatorCallbackHandler createCallbackHandler(Map<String, String> options) {
        TestJaasConfig config = new TestJaasConfig();
        config.createOrUpdateEntry("Kafka", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule", options);
        TokenBearerValidatorCallbackHandler callbackHandler = new TokenBearerValidatorCallbackHandler();
        callbackHandler.configure(this.configs, "OAUTHBEARER", Collections.singletonList(config.getAppConfigurationEntry("Kafka")[0]));
        return callbackHandler;
    }

    private Map<String, String> baseOptions() throws Exception {
        if (this.jwsContainer == null) {
            this.jwsContainer = TokenTestUtils.setUpJws(36000, this.defaultIssuer, this.defaultSubject);
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("publicKeyPath", this.jwsContainer.getPublicKeyFile().getAbsolutePath());
        options.put("audience", String.join((CharSequence)",", new CharSequence[0]));
        return options;
    }
}

