/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.stats;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.server.plugins.auth.stats.TenantAuthenticationStats;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TenantAuthenticationStatsTest {
    private MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private TenantAuthenticationStats tenantStats = TenantAuthenticationStats.instance();

    @Before
    @After
    public void cleanMBeans() {
        this.tenantStats.removeAllMBeans();
    }

    @Test
    public void testMBean() throws Exception {
        String tenant = "tenant1";
        String user = "userA";
        this.authenticate(tenant, user);
        this.verifyStat(this.mbeanName(tenant, user), 1L);
        this.authenticate(tenant, user);
        this.verifyStat(this.mbeanName(tenant, user), 2L);
    }

    @Test
    public void testMBeanNames() throws Exception {
        String tenant = "tenant'{}\"!$:";
        String user = "user*?1";
        this.authenticate(tenant, user);
        this.verifyStat(this.mbeanName(ObjectName.quote(tenant), ObjectName.quote(user)), 1L);
    }

    @Test
    public void testMBeanCleanup() throws Exception {
        int startMBeanCount = this.mbeanServer.getMBeanCount();
        HashSet<MultiTenantPrincipal> principals = new HashSet<MultiTenantPrincipal>();
        principals.add(this.createPrincipal("tenant1", "user-1"));
        principals.add(this.createPrincipal("tenant1", "user-2"));
        principals.add(this.createPrincipal("tenant:2", "user*1"));
        principals.add(this.createPrincipal("tenant3", "user*1"));
        principals.add(this.createPrincipal("tenant*4", "user:2"));
        for (MultiTenantPrincipal principal : principals) {
            for (int i = 0; i < 5; ++i) {
                this.authenticate(principal.tenantMetadata().tenantName, principal.user());
            }
        }
        Assert.assertEquals((long)principals.size(), (long)(this.mbeanServer.getMBeanCount() - startMBeanCount));
        for (MultiTenantPrincipal principal : principals) {
            this.verifyStat(this.mbeanName(principal), 5L);
        }
        HashSet<MultiTenantPrincipal> updatedPrincipals = new HashSet<MultiTenantPrincipal>(principals);
        MultiTenantPrincipal deletedUserPrincipal = this.createPrincipal("tenant1", "user-2");
        MultiTenantPrincipal deletedTenantPrincipal = this.createPrincipal("tenant3", "user*1");
        MultiTenantPrincipal newUserPrincipal = this.createPrincipal("tenant1", "user-3");
        MultiTenantPrincipal newTenantPrincipal = this.createPrincipal("tenant5", "user*1");
        updatedPrincipals.remove(deletedUserPrincipal);
        updatedPrincipals.remove(deletedTenantPrincipal);
        updatedPrincipals.add(newUserPrincipal);
        updatedPrincipals.add(newTenantPrincipal);
        this.tenantStats.removeUnusedMBeans(updatedPrincipals);
        Assert.assertEquals((long)(principals.size() - 2), (long)(this.mbeanServer.getMBeanCount() - startMBeanCount));
        principals.remove(deletedUserPrincipal);
        principals.remove(deletedTenantPrincipal);
        for (MultiTenantPrincipal principal : principals) {
            this.verifyStat(this.mbeanName(principal), 5L);
        }
    }

    private void authenticate(String tenant, String user) {
        MultiTenantPrincipal principal = this.createPrincipal(tenant, user);
        this.tenantStats.onSuccessfulAuthentication(principal);
    }

    private ObjectName mbeanName(MultiTenantPrincipal principal) throws Exception {
        return this.mbeanName(this.tenantStats.quoteIfRequired(principal.tenantMetadata().tenantName), this.tenantStats.quoteIfRequired(principal.user()));
    }

    private ObjectName mbeanName(String tenant, String user) throws Exception {
        return new ObjectName(String.format("%s,tenant=%s,user=%s", "io.confluent.kafka.server.plugins:type=TenantAuthentication", tenant, user));
    }

    private void verifyStat(ObjectName mbeanName, long count) throws Exception {
        Assert.assertEquals((Object)count, (Object)this.mbeanServer.getAttribute(mbeanName, "Succeeded"));
    }

    private MultiTenantPrincipal createPrincipal(String tenant, String user) {
        return new MultiTenantPrincipal(user, new TenantMetadata(tenant, tenant));
    }
}

