/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.server.plugins.auth.PlainSaslServer;
import io.confluent.kafka.server.plugins.auth.SaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.stats.AuthenticationStats;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.SaslException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PlainSaslServerTest {
    private List<AppConfigurationEntry> jaasEntries;
    private SaslAuthenticator mockSaslAuth;
    private PlainSaslServer saslServer;
    private static AuthenticationStats stats = AuthenticationStats.getInstance();

    @Before
    public void setUp() throws Exception {
        this.jaasEntries = Collections.emptyList();
        this.mockSaslAuth = (SaslAuthenticator)Mockito.mock(SaslAuthenticator.class);
        Mockito.when((Object)this.mockSaslAuth.clusterId((String)ArgumentMatchers.any())).thenReturn(Optional.of("test-cluster"));
        this.saslServer = new PlainSaslServer(this.jaasEntries, this.mockSaslAuth, null);
        stats.reset();
    }

    @Test
    public void shouldNotAllowImpersonation() throws Exception {
        String username = "foo";
        String password = "bar";
        String authString = "impersonating\u0000foo\u0000bar";
        try {
            this.saslServer.evaluateResponse("impersonating\u0000foo\u0000bar".getBytes());
            Assert.fail();
        }
        catch (SaslAuthenticationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Client requested an authorization id that is different from username"));
            this.verifyErrorInfo(e, AuditEventStatus.UNAUTHENTICATED, "foo");
        }
    }

    @Test
    public void authSucceedsWithMetrics() throws Exception {
        String username = "foo";
        String password = "bar";
        String authString = "\u0000foo\u0000bar";
        this.configureUser("foo", "bar", "tenant1");
        this.saslServer.evaluateResponse("\u0000foo\u0000bar".getBytes());
        Assert.assertEquals((Object)"foo", (Object)this.saslServer.getAuthorizationID());
        Assert.assertEquals((long)1L, (long)stats.getSucceeded());
        Assert.assertEquals((long)0L, (long)stats.getFailed());
        Assert.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void authFailsWithMetrics() throws Exception {
        String username = "foo";
        String password = "bar";
        String authString = "\u0000foo\u0000bar";
        ((SaslAuthenticator)Mockito.doThrow((Throwable[])new Throwable[]{new SaslException("Top level msg", new Exception("Detailed cause"))}).when((Object)this.mockSaslAuth)).authenticate("foo", "bar", Optional.empty());
        try {
            this.saslServer.evaluateResponse("\u0000foo\u0000bar".getBytes());
            Assert.fail();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)stats.getSucceeded());
        Assert.assertEquals((long)1L, (long)stats.getFailed());
        Assert.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void nullCauseIsOK() throws Exception {
        String username = "foo";
        String password = "bar";
        String authString = "\u0000foo\u0000bar";
        ((SaslAuthenticator)Mockito.doThrow((Throwable[])new Throwable[]{new SaslException("Top level msg", null)}).when((Object)this.mockSaslAuth)).authenticate("foo", "bar", Optional.empty());
        try {
            this.saslServer.evaluateResponse("\u0000foo\u0000bar".getBytes());
            Assert.fail();
        }
        catch (SaslException saslException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)stats.getSucceeded());
        Assert.assertEquals((long)1L, (long)stats.getFailed());
        Assert.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void parseFailsWithMetrics() throws Exception {
        try {
            this.saslServer.evaluateResponse("garbage".getBytes());
            Assert.fail();
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)stats.getSucceeded());
        Assert.assertEquals((long)1L, (long)stats.getFailed());
        Assert.assertEquals((long)1L, (long)stats.getTotal());
    }

    @Test
    public void metricsInJMX() throws Exception {
        String username = "foo";
        String password = "bar";
        String authString = "\u0000foo\u0000bar";
        long successes = 7L;
        this.configureUser("foo", "bar", "tenant1");
        int i = 0;
        while ((long)i < 7L) {
            this.saslServer.evaluateResponse("\u0000foo\u0000bar".getBytes());
            ++i;
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        String objectName = "io.confluent.kafka.server.plugins:type=Authentication";
        Set<ObjectInstance> instances = mBeanServer.queryMBeans(new ObjectName(objectName), null);
        Assert.assertEquals((long)1L, (long)instances.size());
        ObjectInstance instance = (ObjectInstance)instances.toArray()[0];
        MBeanInfo info = mBeanServer.getMBeanInfo(instance.getObjectName());
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        for (MBeanAttributeInfo attrInfo : info.getAttributes()) {
            attrMap.put(attrInfo.getName(), mBeanServer.getAttribute(instance.getObjectName(), attrInfo.getName()));
        }
        Assert.assertEquals((Object)7L, attrMap.get("Succeeded"));
        Assert.assertEquals((Object)0L, attrMap.get("Failed"));
        Assert.assertEquals((Object)7L, attrMap.get("Total"));
    }

    @Test
    public void emptyTokens() {
        SaslAuthenticationException e = (SaslAuthenticationException)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("", "", "")));
        Assert.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
        e = (SaslAuthenticationException)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("", "", "p")));
        Assert.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
        e = (SaslAuthenticationException)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("", "u", "")));
        Assert.assertEquals((Object)"Authentication failed: password not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNAUTHENTICATED, "u");
        e = (SaslAuthenticationException)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("a", "", "")));
        Assert.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
        e = (SaslAuthenticationException)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("a", "", "p")));
        Assert.assertEquals((Object)"Authentication failed: username not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
        e = (SaslAuthenticationException)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(this.saslMessage("a", "u", "")));
        Assert.assertEquals((Object)"Authentication failed: password not specified", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNAUTHENTICATED, "u");
        String nul = "\u0000";
        e = (SaslAuthenticationException)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(String.format("%s%s%s%s%s%s", "a", nul, "u", nul, "p", nul).getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((Object)"Invalid SASL/PLAIN response: expected 3 tokens, got 4", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
        e = (SaslAuthenticationException)Assert.assertThrows(SaslAuthenticationException.class, () -> this.saslServer.evaluateResponse(String.format("%s%s%s", "", nul, "u").getBytes(StandardCharsets.UTF_8)));
        Assert.assertEquals((Object)"Invalid SASL/PLAIN response: expected 3 tokens, got 2", (Object)e.getMessage());
        this.verifyErrorInfo(e, AuditEventStatus.UNKNOWN_USER_DENIED, "");
    }

    private void verifyErrorInfo(SaslAuthenticationException e, AuditEventStatus auditEventStatus, String identifier) {
        Assert.assertEquals((Object)auditEventStatus, (Object)e.errorInfo().auditEventStatus());
        Assert.assertEquals((Object)identifier, (Object)e.errorInfo().identifier());
        if (AuditEventStatus.UNAUTHENTICATED == auditEventStatus) {
            Assert.assertEquals((Object)"test-cluster", (Object)e.errorInfo().clusterId());
        }
    }

    private void configureUser(final String username, String password, final String tenant) throws SaslException {
        ((SaslAuthenticator)Mockito.doAnswer((Answer)new Answer<MultiTenantPrincipal>(){

            public MultiTenantPrincipal answer(InvocationOnMock invocation) throws Throwable {
                TenantMetadata tenantMetadata = new TenantMetadata(tenant, tenant);
                return new MultiTenantPrincipal(username, tenantMetadata);
            }
        }).when((Object)this.mockSaslAuth)).authenticate(username, password, Optional.empty());
    }

    private byte[] saslMessage(String authorizationId, String userName, String password) {
        String nul = "\u0000";
        String message = String.format("%s%s%s%s%s", authorizationId, nul, userName, nul, password);
        return message.getBytes(StandardCharsets.UTF_8);
    }
}

