/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.server.plugins.auth.AbstractFileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.server.plugins.auth.FileBasedLoginModule;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.FileBasedSaslServerFactory;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsLoader;
import io.confluent.kafka.server.plugins.auth.PlainSaslServer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.common.security.plain.internals.PlainServerCallbackHandler;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.junit.Assert;
import org.junit.Test;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedPlainSaslAuthenticatorTest
extends AbstractFileBasedPlainSaslAuthenticatorTest {
    private static final Logger log = LoggerFactory.getLogger(FileBasedPlainSaslAuthenticatorTest.class);
    public static final String USER_ID_1 = "23";
    public static final String TENANT_NAME_1 = "lkc-bkey";
    public static final String CLUSTER_ID_1 = "lkc-bkey";

    @Override
    protected FileBasedPlainSaslAuthenticator createAuthenticator() {
        return new FileBasedPlainSaslAuthenticator();
    }

    @Test
    public void testHashedPasswordAuth() throws Exception {
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.empty());
        this.assertPrincipal("lkc-bkey_23", USER_ID_1, "lkc-bkey", "lkc-bkey", true, principal);
    }

    @Test
    public void testPlainPasswordAuth() throws Exception {
        for (int i = 0; i < 3; ++i) {
            MultiTenantPrincipal principal = this.saslAuth.authenticate("pkey", "no hash", Optional.empty());
            this.assertPrincipal("confluent_7", "7", "confluent", "confluent", true, principal);
        }
    }

    @Test
    public void testServiceAcoountAuth() throws Exception {
        for (int i = 0; i < 3; ++i) {
            MultiTenantPrincipal principal = this.saslAuth.authenticate("skey", "service secret", Optional.empty());
            Assert.assertEquals((Object)"test_service_11", (Object)principal.getName());
            Assert.assertEquals((Object)"11", (Object)principal.user());
            Assert.assertEquals((Object)"test_service", (Object)principal.tenantMetadata().tenantName);
            Assert.assertEquals((Object)"test_service", (Object)principal.tenantMetadata().clusterId);
            Assert.assertFalse((boolean)principal.tenantMetadata().isSuperUser);
        }
    }

    @Test
    public void testInvalidUser() throws Exception {
        for (int i = 0; i < 3; ++i) {
            try {
                this.saslAuth.authenticate("no_user", "blah", Optional.empty());
                Assert.fail((String)"Invalid user name should fail the authentication");
                continue;
            }
            catch (SaslAuthenticationException e) {
                Assert.assertEquals((Object)"Authentication failed", (Object)e.getMessage());
                Assert.assertEquals((Object)AuditEventStatus.UNKNOWN_USER_DENIED, (Object)e.errorInfo().auditEventStatus());
                Assert.assertEquals((Object)"Unknown user no_user", (Object)e.errorInfo().errorMessage());
                Assert.assertEquals((Object)"no_user", (Object)e.errorInfo().identifier());
                Assert.assertEquals((Object)"", (Object)e.errorInfo().clusterId());
            }
        }
    }

    @Test
    public void testInvalidHashedPassword() throws Exception {
        for (int i = 0; i < 3; ++i) {
            try {
                this.saslAuth.authenticate("bkey", "not right", Optional.empty());
                Assert.fail((String)"Invalid hashed password should fail the authentication");
                continue;
            }
            catch (SaslAuthenticationException e) {
                Assert.assertEquals((Object)"Authentication failed", (Object)e.getMessage());
                Assert.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)e.errorInfo().auditEventStatus());
                Assert.assertEquals((Object)"Bad password for user bkey", (Object)e.errorInfo().errorMessage());
                Assert.assertEquals((Object)"bkey", (Object)e.errorInfo().identifier());
                Assert.assertEquals((Object)"lkc-bkey", (Object)e.errorInfo().clusterId());
            }
        }
    }

    @Test
    public void testInvalidPlainPassword() throws Exception {
        try {
            this.saslAuth.authenticate("pkey", "not right", Optional.empty());
            Assert.fail((String)"Invalid plain password should fail the authentication");
        }
        catch (SaslAuthenticationException e) {
            Assert.assertEquals((Object)"Authentication failed", (Object)e.getMessage());
            Assert.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)e.errorInfo().auditEventStatus());
            Assert.assertEquals((Object)"Bad password for user pkey", (Object)e.errorInfo().errorMessage());
            Assert.assertEquals((Object)"pkey", (Object)e.errorInfo().identifier());
            Assert.assertEquals((Object)"confluent", (Object)e.errorInfo().clusterId());
        }
    }

    @Test
    public void testCheckpwPerSecond() throws Exception {
        long now;
        String configFilePath = FileBasedPlainSaslAuthenticator.configEntryOption((List)this.jaasEntries, (String)"config_path", (String)FileBasedLoginModule.class.getName());
        MultiTenantSaslSecretsLoader loader = new MultiTenantSaslSecretsLoader(1);
        Map.Entry entry = loader.load(configFilePath, 100L, 100000000L).entries().entrySet().iterator().next();
        long calls = 0L;
        long startMs = Time.SYSTEM.milliseconds();
        long endMs = startMs + 1000L;
        do {
            BCrypt.checkpw((String)((MultiTenantSaslConfigEntry)entry.getValue()).userId(), (String)((MultiTenantSaslConfigEntry)entry.getValue()).hashedSecret());
            ++calls;
        } while ((now = Time.SYSTEM.milliseconds()) < endMs);
        double duration = (double)(endMs - startMs) / 1000.0;
        log.info("testCheckpwPerSecond: performed {} operations in {} seconds.  Average sec/op = {}", new Object[]{calls, duration, duration / (double)calls});
    }

    @Test
    public void testServerFactory() throws SaslException {
        FileBasedSaslServerFactory factory = new FileBasedSaslServerFactory();
        PlainServerCallbackHandler cbh = new PlainServerCallbackHandler();
        Map emptyMap = Collections.emptyMap();
        cbh.configure(emptyMap, "PLAIN", this.jaasEntries);
        PlainSaslServer server = (PlainSaslServer)factory.createSaslServer("PLAIN", "", "", emptyMap, (CallbackHandler)cbh);
        Assert.assertNotNull((String)"Server not created", (Object)server);
    }

    @Test
    public void testPKCClusterIdShouldAuthenticateUserInLegacyMode() throws Exception {
        this.setAuthenticatorValidationMode("allow_legacy_bootstrap");
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.of(new PathAwareSniHostName("pkc-12345.wrong.host.name")));
        this.assertPrincipal("lkc-bkey_23", USER_ID_1, "lkc-bkey", "lkc-bkey", true, principal);
    }

    @Test
    public void testIncorrectClusterIdShouldAuthenticateUserInOptionalMode() throws Exception {
        this.setAuthenticatorValidationMode("optional_validation");
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.of(new PathAwareSniHostName("wrong.host.name")));
        this.assertPrincipal("lkc-bkey_23", USER_ID_1, "lkc-bkey", "lkc-bkey", true, principal);
    }

    @Test
    public void testIncorrectClusterIdShouldFailAuthenticationInStrictMode() throws Exception {
        this.setAuthenticatorValidationMode("strict");
        try {
            this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.of(new PathAwareSniHostName("lkc-wrong-00aa.host.name")));
            Assert.fail((String)"Incorrect cluster Id should fail the authentication.");
        }
        catch (SaslAuthenticationException e) {
            Assert.assertEquals((Object)"Authentication failed", (Object)e.getMessage());
            Assert.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)e.errorInfo().auditEventStatus());
            Assert.assertEquals((Object)String.format("SNI cluster ID: %s does not match API key cluster ID %s for user name: %s", "lkc-wrong", "lkc-bkey", "bkey"), (Object)e.errorInfo().errorMessage());
            Assert.assertEquals((Object)"bkey", (Object)e.errorInfo().identifier());
            Assert.assertEquals((Object)"lkc-bkey", (Object)e.errorInfo().clusterId());
        }
    }

    @Test
    public void testCorrectClusterIdShouldAuthenticateUser() throws Exception {
        this.setAuthenticatorValidationMode("strict");
        MultiTenantPrincipal principal = this.saslAuth.authenticate("bkey", "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe", Optional.of(new PathAwareSniHostName("lkc-bkey-0aa.rufus.confluent.cloud")));
        this.assertPrincipal("lkc-bkey_23", USER_ID_1, "lkc-bkey", "lkc-bkey", true, principal);
    }

    private void assertPrincipal(String expectedUserName, String expectedUserId, String expectedTenantName, String expectedClusterId, boolean expectedIsSuperUser, MultiTenantPrincipal actualPrincipal) {
        Assert.assertEquals((Object)expectedUserName, (Object)actualPrincipal.getName());
        Assert.assertEquals((Object)expectedUserId, (Object)actualPrincipal.user());
        Assert.assertEquals((Object)expectedTenantName, (Object)actualPrincipal.tenantMetadata().tenantName);
        Assert.assertEquals((Object)expectedClusterId, (Object)actualPrincipal.tenantMetadata().clusterId);
        Assert.assertEquals((Object)expectedIsSuperUser, (Object)actualPrincipal.tenantMetadata().isSuperUser);
    }
}

