/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.quota;

import io.confluent.kafka.multitenant.quota.QuotaConfig;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.Assert;
import org.junit.Test;

public class QuotaConfigTest {
    private static final QuotaConfig TEST_CONFIG = new QuotaConfig(Long.valueOf(102400L), Long.valueOf(204800L), Double.valueOf(500.0), null, QuotaConfig.UNLIMITED_QUOTA);

    @Test
    public void testQuotaConfig() {
        Assert.assertTrue((boolean)TEST_CONFIG.hasQuotaLimit(ClientQuotaType.PRODUCE));
        Assert.assertEquals((double)102400.0, (double)TEST_CONFIG.quota(ClientQuotaType.PRODUCE), (double)1.0E-4);
        Assert.assertTrue((boolean)TEST_CONFIG.hasQuotaLimit(ClientQuotaType.FETCH));
        Assert.assertEquals((double)204800.0, (double)TEST_CONFIG.quota(ClientQuotaType.FETCH), (double)1.0E-4);
        Assert.assertTrue((boolean)TEST_CONFIG.hasQuotaLimit(ClientQuotaType.REQUEST));
        Assert.assertEquals((double)500.0, (double)TEST_CONFIG.quota(ClientQuotaType.REQUEST), (double)1.0E-4);
    }

    @Test
    public void testUnlimitedQuotaConfig() {
        Assert.assertFalse((boolean)QuotaConfig.UNLIMITED_QUOTA.hasQuotaLimit(ClientQuotaType.PRODUCE));
        Assert.assertFalse((boolean)QuotaConfig.UNLIMITED_QUOTA.hasQuotaLimit(ClientQuotaType.FETCH));
        Assert.assertFalse((boolean)QuotaConfig.UNLIMITED_QUOTA.hasQuotaLimit(ClientQuotaType.REQUEST));
    }

    @Test
    public void testEqualQuotaPerBrokerNoBrokers() {
        long quotaNoBrokers = 12345L;
        Assert.assertEquals((String)"Unexpected produce broker quota", (long)12345L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.PRODUCE, 0, Long.valueOf(12345L)));
        Assert.assertEquals((String)"Unexpected consume broker quota", (long)12345L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.FETCH, 0, Long.valueOf(12345L)));
        Assert.assertEquals((String)"Unexpected request broker quota", (long)12345L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.REQUEST, 0, Long.valueOf(12345L)));
    }

    @Test
    public void testEqualQuotaPerBroker() {
        Assert.assertEquals((String)"Unexpected produce broker quota", (long)10240L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.PRODUCE, 10, Long.valueOf(12345L)));
        Assert.assertEquals((String)"Unexpected consume broker quota", (long)20480L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.FETCH, 10, Long.valueOf(12345L)));
        Assert.assertEquals((String)"Unexpected request broker quota", (long)50L, (long)TEST_CONFIG.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.REQUEST, 10, Long.valueOf(12345L)));
    }

    @Test
    public void testEqualQuotaPerBrokerForUnlimitedQuotasReturnsUnlimitedQuota() {
        Assert.assertEquals((String)"Unexpected produce broker quota for unlimited quota", (double)QuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.PRODUCE), (double)QuotaConfig.UNLIMITED_QUOTA.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.PRODUCE, 10, Long.valueOf(13L)).doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"Unexpected consume broker quota for unlimited quota", (double)QuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.FETCH), (double)QuotaConfig.UNLIMITED_QUOTA.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.FETCH, 10, Long.valueOf(123L)).doubleValue(), (double)1.0E-4);
        Assert.assertEquals((String)"Unexpected request broker quota for unlimited quota", (double)QuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.REQUEST), (double)QuotaConfig.UNLIMITED_QUOTA.equalQuotaPerBrokerOrUnlimited(ClientQuotaType.REQUEST, 10, Long.valueOf(11L)).doubleValue(), (double)1.0E-4);
    }
}

