/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.junit.Assert;

public class TenantMetricsTestUtils {
    private Metrics metrics;
    private final String tenantName;
    private final String userName;

    public TenantMetricsTestUtils(Metrics metrics, String tenantName, String userName) {
        this.metrics = metrics;
        this.tenantName = tenantName;
        this.userName = userName;
    }

    public Map<String, KafkaMetric> verifyTenantMetrics(String ... expectedMetrics) {
        return TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, this.tenantName, this.userName, expectedMetrics);
    }

    public static Map<String, KafkaMetric> verifyTenantMetrics(Metrics metrics, String tenantName, String userName, String ... expectedMetrics) {
        return TenantMetricsTestUtils.verifyTenantMetrics(metrics, tenantName, userName, false, expectedMetrics);
    }

    public static Map<String, KafkaMetric> verifyTenantMetrics(Metrics metrics, String tenantName, String userName, boolean assertEmpty, String ... expectedMetrics) {
        HashSet<String> tenantMetrics = new HashSet<String>();
        HashMap<String, KafkaMetric> metricsByName = new HashMap<String, KafkaMetric>();
        List<String> expectedMetricsList = Arrays.asList(expectedMetrics);
        for (Map.Entry entry : metrics.metrics().entrySet()) {
            MetricName metricName = (MetricName)entry.getKey();
            String tenant = (String)metricName.tags().get("tenant");
            String user = (String)metricName.tags().get("user");
            if (!expectedMetricsList.contains(metricName.name()) || !tenantName.equals(tenant) || !userName.equals(user)) continue;
            KafkaMetric metric = (KafkaMetric)entry.getValue();
            metricsByName.put(metricName.name(), metric);
            tenantMetrics.add(metricName.name());
            Assert.assertEquals((Object)tenantName, (Object)tenant);
            Assert.assertEquals((Object)userName, (Object)user);
            double value = (Double)metric.metricValue();
            if (assertEmpty) {
                Assert.assertEquals((String)String.format("Metric (%s) was recorded: %s", metricName.name(), value), (double)value, (double)0.0, (double)0.0);
                continue;
            }
            Assert.assertTrue((String)String.format("Metric (%s) not recorded: %s", metricName.name(), value), (value > 0.0 ? 1 : 0) != 0);
        }
        TenantMetricsTestUtils.verifySensors(metrics, tenantName, userName, expectedMetrics);
        return metricsByName;
    }

    public KafkaMetric metric(String wantedMetricName) {
        return this.metric(this.metrics, wantedMetricName);
    }

    public KafkaMetric metric(Metrics metrics, String wantedMetricName) {
        for (Map.Entry entry : metrics.metrics().entrySet()) {
            MetricName metricName = (MetricName)entry.getKey();
            if (!wantedMetricName.equals(metricName.name())) continue;
            return (KafkaMetric)entry.getValue();
        }
        return null;
    }

    public static void verifySensors(Metrics metrics, String tenantName, String userName, String ... expectedMetrics) {
        for (String metricName : expectedMetrics) {
            String name = metricName.substring(0, metricName.lastIndexOf(45));
            String sensorName = String.format("%s:%s-%s:%s-%s", name, "tenant", tenantName, "user", userName);
            Sensor sensor = metrics.getSensor(sensorName);
            TestCase.assertNotNull((String)("Sensor not found " + sensorName), (Object)sensor);
        }
    }
}

