/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantInterceptor;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.link.ClusterLinkSourceMetricsTest;
import org.junit.Assert;

public class MultiTenantClusterLinkSourceMetricsTest
extends ClusterLinkSourceMetricsTest {
    private final String tenant = "tenant";

    protected BrokerInterceptor createInterceptor(Time time) {
        HashMap<String, Object> configs = new HashMap<String, Object>(){
            {
                this.put(KafkaConfig.BrokerIdProp(), 1);
                this.put(KafkaConfig.DefaultReplicationFactorProp(), (short)1);
                this.put(KafkaConfig.NumPartitionsProp(), 1);
                this.put("confluent.multitenant.listener.hostname.cluster.prefix.enable", false);
                this.put("confluent.schema.validator.multitenant.enable", false);
                this.put("confluent.multitenant.max.partitions.per.request", Integer.MAX_VALUE);
            }
        };
        MultiTenantInterceptor interceptor = new MultiTenantInterceptor(time);
        interceptor.configure((Map)configs);
        return interceptor;
    }

    protected KafkaPrincipal createPrincipal() {
        return new MultiTenantPrincipal("user", new TenantMetadata("tenant", "tenant"));
    }

    protected String responseTopic() {
        return "tenant_topic";
    }

    protected void verifyMetrics(Set<MetricName> metricNames) {
        super.verifyMetrics(metricNames);
        for (MetricName metricName : metricNames) {
            Assert.assertEquals((Object)"tenant", metricName.tags().get("tenant"));
        }
    }
}

