/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.ConnectionSensorBuilder;
import io.confluent.kafka.multitenant.metrics.ConnectionSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetricsTestUtils;
import java.util.Map;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConnectionSensorsTest {
    private TenantMetricsTestUtils utils;
    private ConnectionSensors sensors;
    private Metrics metrics;
    private final String activeAuthConnectionsCountMetricName = "active-authenticated-connection-count";
    private String[] connectionMetrics = new String[]{"successful-authentication-rate", "successful-authentication-total", "active-authenticated-connection-count"};

    @Before
    public void setUp() {
        String tenantName = "tenant";
        String userName = "user";
        this.metrics = new Metrics();
        MultiTenantPrincipal principal = new MultiTenantPrincipal(userName, new TenantMetadata(tenantName, "cluster-1"));
        this.utils = new TenantMetricsTestUtils(this.metrics, tenantName, userName);
        this.sensors = new ConnectionSensorBuilder(this.metrics, principal).build();
    }

    @After
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testRecordConnectionAndDisconnectionBringsActiveConnectionsToZero() {
        int i;
        for (i = 0; i < 5; ++i) {
            this.sensors.recordAuthenticatedConnection();
            Assert.assertEquals((double)((double)i + 1.0), (double)((Double)this.utils.metric("active-authenticated-connection-count").metricValue()), (double)0.0);
        }
        for (i = 5; i > 0; --i) {
            this.sensors.recordAuthenticatedDisconnection();
            Assert.assertEquals((double)((double)i - 1.0), (double)((Double)this.utils.metric("active-authenticated-connection-count").metricValue()), (double)0.0);
        }
        Map<String, KafkaMetric> metrics = this.utils.verifyTenantMetrics("successful-authentication-rate", "successful-authentication-total");
        Assert.assertEquals((double)5.0, (double)((Double)metrics.get("successful-authentication-total").metricValue()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((Double)this.utils.metric("active-authenticated-connection-count").metricValue()), (double)0.0);
    }

    @Test
    public void testRecordAuthenticatedConnectionIncrementsRateTotalAndActiveConnections() {
        this.sensors.recordAuthenticatedConnection();
        this.utils.verifyTenantMetrics("successful-authentication-rate", "successful-authentication-total", "active-authenticated-connection-count");
    }

    @Test
    public void testRecordAuthenticatedConnectionsPerTenant() {
        TenantMetadata firstTenantMetadata = new TenantMetadata("tenant1", "cluster-1");
        MultiTenantPrincipal firstTenantU1 = new MultiTenantPrincipal("user1", firstTenantMetadata);
        MultiTenantPrincipal firstTenantU2 = new MultiTenantPrincipal("user2", firstTenantMetadata);
        MultiTenantPrincipal secondTenantU1 = new MultiTenantPrincipal("user1", new TenantMetadata("tenant2", "cluster-1"));
        ConnectionSensors firstTenantU1Sensors = new ConnectionSensorBuilder(this.metrics, firstTenantU1).build();
        ConnectionSensors firstTenantU2Sensors = new ConnectionSensorBuilder(this.metrics, firstTenantU2).build();
        ConnectionSensors secondTenantU1Sensors = new ConnectionSensorBuilder(this.metrics, secondTenantU1).build();
        for (int i = 0; i < 5; ++i) {
            firstTenantU1Sensors.recordAuthenticatedConnection();
        }
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, "tenant1", "user1", this.connectionMetrics);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, "tenant1", "user2", true, this.connectionMetrics);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, "tenant2", "user1", true, this.connectionMetrics);
        firstTenantU2Sensors.recordAuthenticatedConnection();
        Map<String, KafkaMetric> firstTenantU1Metrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, "tenant1", "user1", this.connectionMetrics);
        Map<String, KafkaMetric> firstTenantU2Metrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, "tenant1", "user2", this.connectionMetrics);
        Assert.assertEquals((double)5.0, (double)((Double)firstTenantU1Metrics.get("active-authenticated-connection-count").metricValue()), (double)0.0);
        Assert.assertEquals((double)1.0, (double)((Double)firstTenantU2Metrics.get("active-authenticated-connection-count").metricValue()), (double)0.0);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, "tenant2", "user1", true, this.connectionMetrics);
        for (int i = 0; i < 3; ++i) {
            secondTenantU1Sensors.recordAuthenticatedConnection();
        }
        Map<String, KafkaMetric> secondTenantU1Metrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, "tenant2", "user1", this.connectionMetrics);
        Assert.assertEquals((double)3.0, (double)((Double)secondTenantU1Metrics.get("active-authenticated-connection-count").metricValue()), (double)0.0);
        firstTenantU1Metrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, "tenant1", "user1", this.connectionMetrics);
        firstTenantU2Metrics = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, "tenant1", "user2", this.connectionMetrics);
        Assert.assertEquals((double)5.0, (double)((Double)firstTenantU1Metrics.get("active-authenticated-connection-count").metricValue()), (double)0.0);
        Assert.assertEquals((double)1.0, (double)((Double)firstTenantU2Metrics.get("active-authenticated-connection-count").metricValue()), (double)0.0);
    }
}

