/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import com.amazonaws.util.IOUtils;
import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import kafka.admin.AclCommand;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTest.class})
public class TopicBasedPlainSaslAuthIntegrationTest {
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final String serviceUserAPIkey = "APIKEY1";
    private final String serviceUserAPIkeyPassword = "pwd1";
    private IntegrationTestHarness testHarness;
    private PhysicalCluster physicalCluster;
    private final String apiKeysTopic = "_confluent-apikey";
    private final String testTopic = "abcd";
    private final List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));

    @Before
    public void setUp() throws Exception {
        MockAuditLogProvider.reset();
        this.testHarness = new IntegrationTestHarness();
        this.physicalCluster = this.testHarness.start(this.brokerProps());
        int serviceUserId = 1;
        LogicalCluster logicalCluster = this.physicalCluster.createLogicalCluster(this.logicalClusterId, 100, serviceUserId);
        LogicalClusterUser serviceUser = logicalCluster.user(serviceUserId);
        AclCommand.main((String[])SecurityTestUtils.addTopicAclArgs(this.testHarness.zkConnect(), serviceUser.prefixedKafkaPrincipal(), serviceUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL));
    }

    @After
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
    }

    private Properties brokerProps() {
        Properties props = new Properties();
        props.put("listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("advertised.listeners", "INTERNAL://localhost:0, EXTERNAL://localhost:0");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT, EXTERNAL:SASL_PLAINTEXT");
        props.put("inter.broker.listener.name", "INTERNAL");
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", "true");
        props.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule required;");
        props.put("confluent.cdc.api.keys.topic", "_confluent-apikey");
        props.put("confluent.cdc.api.keys.load.timeout.ms", (Object)300);
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        return props;
    }

    @Test
    public void testSuccessfulAuthentication() throws Exception {
        this.createTopic();
        this.loadApiKeys();
        try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            client.createTopics(this.sampleTopics).all().get();
            List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
            TestCase.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics));
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.instance;
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        TestCase.assertTrue((boolean)authenticationEvent.principal().isPresent());
        Assert.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assert.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assert.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        Assert.assertFalse((boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"));
        Assert.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assert.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    @Test
    public void testInvalidPassword() throws Exception {
        this.createTopic();
        this.loadApiKeys();
        try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "WrongPassword"));){
            KafkaFuture future = client.createTopics(this.sampleTopics).all();
            TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.instance;
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assert.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assert.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assert.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        TestCase.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assert.assertTrue((boolean)errorInfo.errorMessage().contains("Bad password for user APIKEY1"));
        Assert.assertEquals((Object)"APIKEY1", (Object)errorInfo.identifier());
        Assert.assertEquals((Object)"lkc-abc", (Object)errorInfo.clusterId());
    }

    @Test
    public void testUnknownUser() throws Exception {
        this.createTopic();
        this.loadApiKeys();
        try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("UnknownUser", "WrongPassword"));){
            KafkaFuture future = client.createTopics(this.sampleTopics).all();
            TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.instance;
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assert.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assert.assertEquals((Object)AuditEventStatus.UNKNOWN_USER_DENIED, (Object)authenticationEvent.status());
        TestCase.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assert.assertTrue((boolean)errorInfo.errorMessage().contains("Unknown user UnknownUser"));
        Assert.assertEquals((Object)"UnknownUser", (Object)errorInfo.identifier());
    }

    @Test
    public void testNoSecretsInTopic() throws Exception {
        this.createTopic();
        try (AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));){
            KafkaFuture future = client.createTopics(this.sampleTopics).all();
            TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        }
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.instance;
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assert.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assert.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        TestCase.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        Assert.assertTrue((boolean)authenticationException.errorMessage().contains("Unable to find api key"));
    }

    @Test
    public void testFailureToConnectWithNoTopic() throws Exception {
        Properties props = new Properties();
        props.put("default.api.timeout.ms", (Object)400);
        props.put("request.timeout.ms", (Object)400);
        props.put("reconnect.backoff.ms", (Object)400);
        AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"), props);
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        TestUtils.assertFutureError((Future)future, TimeoutException.class);
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.instance;
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assert.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assert.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        TestCase.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        Assert.assertTrue((boolean)authenticationException.errorMessage().contains("Could not find source topic"));
    }

    private void createTopic() {
        this.physicalCluster.kafkaCluster().createTopic("_confluent-apikey", 1, 1);
    }

    private void loadApiKeys() throws Exception {
        BufferedInputStream path;
        try {
            path = (BufferedInputStream)FileBasedPlainSaslAuthenticatorTest.class.getResource("/file_auth_test_apikeys.json").getContent();
        }
        catch (IOException e) {
            throw new Exception("Couldn't read apikeys content");
        }
        String apiKeys = IOUtils.toString((InputStream)path);
        this.physicalCluster.kafkaCluster().produceApiKeysData("_confluent-apikey", apiKeys);
    }
}

