/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.clients.plugins.auth.oauth.OAuthBearerLoginCallbackHandler;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithCorrectSni;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithSniStartWithPKC;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import kafka.admin.AclCommand;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={IntegrationTest.class})
public class OAuthHostNameValidationIntegrationTest {
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final String testTopic = "abcd";
    private final String[] allowedClusters = new String[]{this.logicalClusterId};
    private final Properties adminProperties = new Properties();
    private final List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));
    private IntegrationTestHarness testHarness;
    private OAuthUtils.JwsContainer jwsContainer;
    private String brokerUUID;
    private PhysicalClusterMetadata metadata;
    private LogicalClusterUser testUser;
    private Map<String, Object> testCert;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    private void setUp(String sniValidationMode) throws Exception {
        this.adminProperties.put("sasl.login.callback.handler.class", OAuthBearerLoginCallbackHandler.class.getName());
        MockAuditLogProvider.reset();
        this.setUp(this.allowedClusters, sniValidationMode);
    }

    private void setUp(String[] allowedClusters, String sniValidationMode) throws Exception {
        this.testHarness = new IntegrationTestHarness();
        boolean serviceUserId = true;
        String subject = "1";
        this.jwsContainer = OAuthUtils.setUpJws(100000, "Confluent", subject, allowedClusters);
        PhysicalCluster physicalCluster = this.testHarness.start(this.setUpMetadata(this.brokerProps(sniValidationMode)));
        int adminUserId = 100;
        LogicalCluster logicalCluster = physicalCluster.createLogicalCluster(this.logicalClusterId, 100, 1);
        this.testUser = logicalCluster.user(1);
        this.addAdminAcls();
    }

    private void addAdminAcls() {
        AclCommand.main((String[])SecurityTestUtils.addTopicAclArgs(this.testHarness.zkConnect(), this.testUser.prefixedKafkaPrincipal(), this.testUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL));
    }

    @After
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        this.metadata.close(this.brokerUUID);
    }

    private Properties setUpMetadata(Properties brokerProps) throws IOException, InterruptedException {
        this.brokerUUID = "uuid";
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        brokerProps.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        brokerProps.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        configs.put("multitenant.metadata.dir", this.tempFolder.getRoot().getCanonicalPath());
        this.metadata = Utils.initiatePhysicalClusterMetadata(configs);
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempFolder);
        TestUtils.waitForCondition(() -> this.metadata.metadata(Utils.LC_META_ABC.logicalClusterId()) != null, (String)"Expected metadata of new logical cluster to be present in metadata cache");
        return brokerProps;
    }

    private Properties brokerProps(String sniValidationMode) throws Exception {
        Properties props = IntegrationTestHarness.defaultOAuthBrokerProps();
        props.put("listener.name.external.oauthbearer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required publicKeyPath=\"" + this.jwsContainer.getPublicKeyFile().toPath() + "\"" + this.getModeConfigString(sniValidationMode) + ";");
        props.put("confluent.multitenant.parse.sni.host.name.enable", (Object)true);
        props.put("listener.security.protocol.map", "REPLICATION:PLAINTEXT,EXTERNAL:SASL_SSL");
        CertStores certStores = new CertStores.Builder(true).cn("127.0.0.1").hostAddress(InetAddress.getByName("127.0.0.1")).build();
        this.testCert = certStores.keyStoreProps();
        this.testCert.putAll(certStores.trustStoreProps());
        props.put(KafkaConfig.ListenersProp(), "REPLICATION://127.0.0.1:0,EXTERNAL://127.0.0.1:0");
        props.put(KafkaConfig.InterBrokerListenerNameProp(), "REPLICATION");
        this.testCert.values().removeIf(Objects::isNull);
        props.putAll(this.testCert);
        return props;
    }

    private String getModeConfigString(String sniValidationMode) {
        return sniValidationMode == null ? "" : "sni_host_name_validation_mode=\"" + sniValidationMode + "\"";
    }

    private String clientJaasConfig(String jwsToken, String allowedCluster) {
        return "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required token=\"" + jwsToken + "\" cluster=\"" + allowedCluster + "\";";
    }

    @Test
    public void testNoSniHostNameSetSuccessfulAuthenticationNoModeSpecified() throws Exception {
        this.setUp(null);
        AdminClient client = this.adminClientWithoutSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @Test
    public void testNoSniHostNameSetSuccessfulAuthenticationInOptionalMode() throws Exception {
        this.setUp(SniValidationMode.OPTIONAL_VALIDATION.getText());
        AdminClient client = this.adminClientWithoutSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @Test
    public void testPkcSniHostNameSetSuccessfulAuthenticationInOptionalMode() throws Exception {
        this.setUp(SniValidationMode.OPTIONAL_VALIDATION.getText());
        AdminClient client = this.adminClientWithPkcSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @Test
    public void testNoSniHostNameSetFailedAuthenticationInLegacyMode() throws Exception {
        this.setUp(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.adminClientWithoutSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future, null);
    }

    @Test
    public void testPkcHostNameSuccessfulAuthenticationInLegacyMode() throws Exception {
        this.setUp(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.adminClientWithPkcSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @Test
    public void testCorrectHostNameSuccessfulAuthenticationInLegacyMode() throws Exception {
        this.setUp(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.adminClientWithMatchingSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @Test
    public void testNoHostNameFailedAuthenticationInStrictMode() throws Exception {
        this.setUp(SniValidationMode.STRICT.getText());
        AdminClient client = this.adminClientWithoutSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future, null);
    }

    @Test
    public void testPkcHostNameFailedAuthenticationInStrictMode() throws Exception {
        this.setUp(SniValidationMode.STRICT.getText());
        AdminClient client = this.adminClientWithPkcSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future, "pkc-wrong-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud");
    }

    @Test
    public void testCorrectHostNameSuccessfulAuthenticationInStrictMode() throws Exception {
        this.setUp(SniValidationMode.STRICT.getText());
        AdminClient client = this.adminClientWithMatchingSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    private AdminClient adminClientWithoutSni() {
        return this.testHarness.createSSLOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties, this.testCert, null);
    }

    private AdminClient adminClientWithPkcSni() {
        return this.testHarness.createSSLOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties, this.testCert, SslEngineFactoryWithSniStartWithPKC.class.getCanonicalName());
    }

    private AdminClient adminClientWithMatchingSni() {
        return this.testHarness.createSSLOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties, this.testCert, SslEngineFactoryWithCorrectSni.class.getCanonicalName());
    }

    private void verifySuccessfulAuthentication(AdminClient client, KafkaFuture<Void> future) throws InterruptedException, ExecutionException {
        future.get();
        this.verifyExpectedTopicsPresent(client);
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        this.verifySuccessfulAuthenticationEvent(authenticationEvent);
    }

    private void verifyExpectedTopicsPresent(AdminClient client) throws InterruptedException, ExecutionException {
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestCase.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics));
    }

    private void verifySuccessfulAuthenticationEvent(ConfluentAuthenticationEvent authenticationEvent) {
        Assert.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assert.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assert.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        TestCase.assertTrue((String)"Authentication event should contain principal", (boolean)authenticationEvent.principal().isPresent());
        Assert.assertFalse((String)"Authentication event shouldn't contain tenant metadata", (boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"));
        TestCase.assertTrue((String)"Authentication event should contain expected logical cluster.", (boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assert.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    private void verifyFailedAuthentication(KafkaFuture<Void> future, String expectedSNIHostName) throws InterruptedException {
        TestUtils.assertFutureError(future, SaslAuthenticationException.class);
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        this.verifyUnauthenticatedEvent(authenticationEvent, expectedSNIHostName);
    }

    private ConfluentAuthenticationEvent getLastAuthenticationEvent() {
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.instance;
        return (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
    }

    private void verifyUnauthenticatedEvent(ConfluentAuthenticationEvent authenticationEvent, String expectedSNIHostName) {
        Assert.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        TestCase.assertTrue((String)"Authentication event should contain expected logical cluster", (boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        TestCase.assertTrue((String)"Authentication event should contain exception", (boolean)authenticationEvent.authenticationException().isPresent());
        Assert.assertFalse((String)"Authentication event shouldn't contain principal", (boolean)authenticationEvent.principal().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        TestCase.assertTrue((String)"Error message should say the SNI cluster Id doesn't match", (errorInfo.errorMessage().contains("The SNI cluster Id") && errorInfo.errorMessage().contains("doesn't match with logical cluster extension") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"1", (Object)errorInfo.identifier());
        Assert.assertEquals((Object)expectedSNIHostName, errorInfo.saslExtensions().get("__confluent_sni_broker_host_name"));
    }
}

