/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticatorTest;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import kafka.admin.AclCommand;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.test.IntegrationTest;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

@Category(value={IntegrationTest.class})
public class FileBasedPlainSaslAuthIntegrationTest {
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final int serviceUserId = 1;
    private final String serviceUserAPIkey = "APIKEY1";
    private final String serviceUserAPIkeyPassword = "pwd1";
    private IntegrationTestHarness testHarness;
    private String brokerUUID;
    private PhysicalClusterMetadata metadata;
    private final String testTopic = "abcd";
    private final List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));
    private final String path = FileBasedPlainSaslAuthenticatorTest.class.getResource("/file_auth_test_apikeys.json").getFile();
    private LogicalClusterUser testUser;
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        MockAuditLogProvider.reset();
        this.testHarness = new IntegrationTestHarness();
        PhysicalCluster physicalCluster = this.testHarness.start(this.setUpMetadata(this.brokerProps()));
        LogicalCluster logicalCluster = physicalCluster.createLogicalCluster(this.logicalClusterId, 100, 1);
        this.testUser = logicalCluster.user(1);
        AclCommand.main((String[])SecurityTestUtils.addTopicAclArgs(this.testHarness.zkConnect(), this.testUser.prefixedKafkaPrincipal(), this.testUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL));
    }

    @After
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        this.metadata.close(this.brokerUUID);
    }

    private Properties setUpMetadata(Properties brokerProps) throws IOException, InterruptedException {
        this.brokerUUID = "uuid";
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("broker.session.uuid", this.brokerUUID);
        brokerProps.put("broker.session.uuid", this.brokerUUID);
        configs.put("multitenant.metadata.dir", this.tempFolder.getRoot().getCanonicalPath());
        this.metadata = Utils.initiatePhysicalClusterMetadata(configs);
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempFolder);
        TestUtils.waitForCondition(() -> this.metadata.metadata(Utils.LC_META_ABC.logicalClusterId()) != null, (String)"Expected metadata of new logical cluster to be present in metadata cache");
        return brokerProps;
    }

    private Properties brokerProps() {
        Properties props = new Properties();
        props.put("sasl.enabled.mechanisms", Collections.singletonList("PLAIN"));
        props.put("listener.name.external.principal.builder.class", MultiTenantPrincipalBuilder.class.getName());
        props.put("listener.name.external.confluent.security.event.logger.authentication.enable", "true");
        props.put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), MultiTenantAuthorizer.class.getName());
        props.put("confluent.security.event.logger.multitenant.enable", "true");
        props.put("listener.name.external.plain.sasl.jaas.config", "io.confluent.kafka.server.plugins.auth.FileBasedLoginModule required config_path=\"" + this.path + "\" refresh_ms=\"1000\";");
        props.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        return props;
    }

    @Test
    public void testSuccessfulAuthentication() throws Exception {
        AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "pwd1"));
        client.createTopics(this.sampleTopics).all().get();
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestCase.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics));
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.instance;
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assert.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assert.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assert.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        Assert.assertFalse((boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"));
        Assert.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assert.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    @Test
    public void testInvalidPassword() throws InterruptedException {
        AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("APIKEY1", "WrongPassword"));
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.instance;
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assert.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assert.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assert.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"));
        TestCase.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assert.assertTrue((boolean)errorInfo.errorMessage().contains("Bad password for user APIKEY1"));
        Assert.assertEquals((Object)"APIKEY1", (Object)errorInfo.identifier());
        Assert.assertEquals((Object)"lkc-abc", (Object)errorInfo.clusterId());
    }

    @Test
    public void testUnknownUser() throws InterruptedException {
        AdminClient client = this.testHarness.createPlainAuthAdminClient(IntegrationTestHarness.clientPlainJaasConfig("UnknownUser", "WrongPassword"));
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        TestUtils.assertFutureError((Future)future, SaslAuthenticationException.class);
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.instance;
        ConfluentAuthenticationEvent authenticationEvent = (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
        Assert.assertFalse((boolean)authenticationEvent.principal().isPresent());
        Assert.assertEquals((Object)AuditEventStatus.UNKNOWN_USER_DENIED, (Object)authenticationEvent.status());
        TestCase.assertTrue((boolean)authenticationEvent.authenticationException().isPresent());
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assert.assertTrue((boolean)errorInfo.errorMessage().contains("Unknown user UnknownUser"));
        Assert.assertEquals((Object)"UnknownUser", (Object)errorInfo.identifier());
    }
}

