/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.cluster;

import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.UserMetadata;
import io.confluent.kafka.test.utils.SecurityTestUtils;
import java.util.HashMap;
import java.util.Map;

public class LogicalCluster {
    private final String logicalClusterId;
    private final PhysicalCluster physicalCluster;
    private final Map<Integer, LogicalClusterUser> users;
    private final LogicalClusterUser adminUser;

    public LogicalCluster(PhysicalCluster physicalCluster, String logicalClusterId, UserMetadata adminUser) {
        this.physicalCluster = physicalCluster;
        this.logicalClusterId = logicalClusterId;
        this.users = new HashMap<Integer, LogicalClusterUser>();
        this.adminUser = this.addUser(adminUser);
    }

    public synchronized LogicalClusterUser addUser(UserMetadata user) {
        int userId = user.userId();
        if (this.users.containsKey(userId)) {
            throw new IllegalArgumentException("User " + userId + " already exists in logical cluster");
        }
        LogicalClusterUser logicalClusterUser = new LogicalClusterUser(user, this.logicalClusterId);
        this.users.put(userId, logicalClusterUser);
        SecurityTestUtils.createScramUser(this.physicalCluster.kafkaCluster(), logicalClusterUser.saslUserName(), user.apiSecret());
        return logicalClusterUser;
    }

    public synchronized void removeUser(int userId) {
        this.users.remove(userId);
    }

    public synchronized LogicalClusterUser user(int userId) {
        return this.users.get(userId);
    }

    public synchronized LogicalClusterUser adminUser() {
        return this.adminUser;
    }

    public String logicalClusterId() {
        return this.logicalClusterId;
    }
}

