/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.LogicalClusterMetadata;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantLifecycleManager;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.schema.TenantContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.easymock.PowerMock;

public class TenantLifecycleManagerTest {
    private static final Long TEST_DELETE_DELAY_MS = 0L;
    private AdminClient mockAdminClient;
    private TenantLifecycleManager lifecycleManagerWithDeleteDelay;
    private TenantLifecycleManager lifecycleManager;

    @Before
    public void setUp() throws Exception {
        Node node = new Node(0, "localhost", 9092);
        this.mockAdminClient = (AdminClient)Mockito.spy((Object)new MockAdminClient(Collections.singletonList(node), node));
        DescribeAclsResult emptyAcls = (DescribeAclsResult)Mockito.mock(DescribeAclsResult.class);
        ((DescribeAclsResult)Mockito.doReturn((Object)KafkaFuture.completedFuture(Collections.emptySet())).when((Object)emptyAcls)).values();
        ((AdminClient)Mockito.doReturn((Object)emptyAcls).when((Object)this.mockAdminClient)).describeAcls((AclBindingFilter)ArgumentMatchers.any(), (DescribeAclsOptions)ArgumentMatchers.any());
        ((AdminClient)Mockito.doReturn(null).when((Object)this.mockAdminClient)).deleteAcls((Collection)ArgumentMatchers.any(), (DeleteAclsOptions)ArgumentMatchers.any());
        this.lifecycleManager = new TenantLifecycleManager(TEST_DELETE_DELAY_MS.longValue(), this.mockAdminClient);
        this.lifecycleManagerWithDeleteDelay = new TenantLifecycleManager(ConfluentConfigs.MULTITENANT_TENANT_DELETE_DELAY_MS_DEFAULT.longValue(), this.mockAdminClient);
        this.lifecycleManagerWithDeleteDelay.updateTenantState(Utils.LC_META_ABC);
        this.lifecycleManagerWithDeleteDelay.updateTenantState(Utils.LC_META_DED);
        this.lifecycleManagerWithDeleteDelay.updateTenantState(Utils.LC_META_MEH);
    }

    @After
    public void teardown() {
        this.lifecycleManager.close();
    }

    @Test
    public void testStateInitialization() {
        Assert.assertEquals((String)"Expecting tenant LC_META_ABC to be active", (Object)TenantLifecycleManager.State.ACTIVE, this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.get(Utils.LC_META_ABC.logicalClusterId()));
        Assert.assertEquals((String)"Expecting tenant LC_META_DED to be deactivated", (Object)TenantLifecycleManager.State.DEACTIVATED, this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.get(Utils.LC_META_DED.logicalClusterId()));
        Assert.assertEquals((String)"Expecting tenant LC_META_MEH to be on the way to deletion", (Object)TenantLifecycleManager.State.DELETE_IN_PROGRESS, this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.get(Utils.LC_META_MEH.logicalClusterId()));
    }

    @Test
    public void testInactiveClusters() {
        List<String> clusters = Arrays.asList(Utils.LC_META_DED.logicalClusterId(), Utils.LC_META_MEH.logicalClusterId());
        Assert.assertTrue((String)"LC_META_DED and LC_META_MEH should be inactive", (boolean)this.lifecycleManagerWithDeleteDelay.inactiveClusters().containsAll(clusters));
        Assert.assertFalse((String)"LC_META_ABC should be active", (boolean)this.lifecycleManagerWithDeleteDelay.inactiveClusters().contains(Utils.LC_META_ABC.logicalClusterId()));
    }

    @Test
    public void testOnlyDeleteTenantsOnce() throws ExecutionException, InterruptedException {
        TenantContext tc = new TenantContext(new MultiTenantPrincipal("", new TenantMetadata(Utils.LC_META_DED.logicalClusterId(), Utils.LC_META_DED.logicalClusterId())));
        List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic(tc.addTenantPrefix("topic"), 3, 1));
        this.mockAdminClient.createTopics(sampleTopics).all().get();
        this.lifecycleManager.updateTenantState(Utils.LC_META_DED);
        this.lifecycleManager.deleteTenants();
        this.lifecycleManager.topicDeletionExecutor().submit(() -> {}).get();
        this.lifecycleManager.deleteTenants();
        ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)2))).listTopics((ListTopicsOptions)ArgumentMatchers.any());
        ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)2))).describeAcls((AclBindingFilter)ArgumentMatchers.any(), (DescribeAclsOptions)ArgumentMatchers.any());
        ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)2))).deleteAcls((Collection)ArgumentMatchers.any(), (DeleteAclsOptions)ArgumentMatchers.any());
        Mockito.reset((Object[])new AdminClient[]{this.mockAdminClient});
        this.lifecycleManager.updateTenantState(Utils.LC_META_DED);
        this.lifecycleManager.deleteTenants();
        ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.never())).listTopics((ListTopicsOptions)ArgumentMatchers.any());
    }

    @Test
    public void testUndelete() throws IOException {
        Assert.assertEquals((String)"Expecting tenant LC_META_DED to be deactivated", (Object)TenantLifecycleManager.State.DEACTIVATED, this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.get(Utils.LC_META_DED.logicalClusterId()));
        LogicalClusterMetadata active = this.reactivateLogicalCluster(Utils.LC_META_DED);
        this.lifecycleManagerWithDeleteDelay.updateTenantState(active);
        Assert.assertEquals((String)"Expecting tenant to be deactivated", (Object)TenantLifecycleManager.State.ACTIVE, this.lifecycleManagerWithDeleteDelay.tenantLifecycleState.get(active.logicalClusterId()));
    }

    @Test
    public void testOnlyDeleteTenantTopics() throws ExecutionException, InterruptedException {
        String internalTopicName = "_internal-topic";
        TenantContext tc = new TenantContext(new MultiTenantPrincipal("", new TenantMetadata(Utils.LC_META_DED.logicalClusterId(), Utils.LC_META_DED.logicalClusterId())));
        ArrayList<NewTopic> sampleTopics = new ArrayList<NewTopic>();
        sampleTopics.add(new NewTopic(tc.addTenantPrefix("topic"), 3, 1));
        sampleTopics.add(new NewTopic(internalTopicName, 3, 1));
        this.mockAdminClient.createTopics(sampleTopics).all().get();
        this.lifecycleManager.updateTenantState(Utils.LC_META_DED);
        this.lifecycleManager.deleteTenants();
        this.lifecycleManager.topicDeletionExecutor().submit(() -> {}).get();
        this.lifecycleManager.deleteTenants();
        Set topicsRemaining = (Set)this.mockAdminClient.listTopics().names().get();
        Assert.assertTrue((String)(internalTopicName + " should still exist after deleting tenant"), (boolean)topicsRemaining.contains(internalTopicName));
        Assert.assertEquals((String)(internalTopicName + " should be the only topic remaining"), (long)1L, (long)topicsRemaining.size());
    }

    @Test
    public void testUpdateMaxPartitionsNullOldMeta() throws InterruptedException, ExecutionException {
        this.testUpdateMaxPartitions(null, Utils.LC_META_ABC, false);
    }

    @Test
    public void testUpdateMaxPartitionsNonNullOldMeta() throws InterruptedException, ExecutionException {
        this.testUpdateMaxPartitions(Utils.LC_META_XYZ, Utils.LC_META_ABC, true);
    }

    @Test
    public void testUpdateMaxPartitionsNoChange() throws InterruptedException, ExecutionException {
        this.testUpdateMaxPartitions(Utils.LC_META_ABC, Utils.LC_META_ABC, false);
    }

    private void testUpdateMaxPartitions(LogicalClusterMetadata oldMeta, LogicalClusterMetadata newMeta, boolean shouldUpdate) {
        Assert.assertTrue((boolean)this.lifecycleManager.updateMaxPartitionsIfNecessary(oldMeta, newMeta));
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry("confluent.plugins.topic.policy.max.partitions.per.tenant", newMeta.maxPartitions().toString()), AlterConfigOp.OpType.SET);
        if (shouldUpdate) {
            ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.times((int)1))).incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singleton(alterConfigOp)));
        } else {
            ((AdminClient)Mockito.verify((Object)this.mockAdminClient, (VerificationMode)Mockito.never())).incrementalAlterConfigs((Map)ArgumentMatchers.any());
        }
    }

    @Test
    public void testUpdateMaxPartitionsFails() {
        AdminClient mockAdminClient = (AdminClient)Mockito.mock(AdminClient.class);
        TenantLifecycleManager lifecycleManager = new TenantLifecycleManager(TEST_DELETE_DELAY_MS.longValue(), mockAdminClient);
        AlterConfigsResult mockResult = (AlterConfigsResult)Mockito.mock(AlterConfigsResult.class);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new KafkaException());
        Mockito.when((Object)mockResult.all()).thenReturn((Object)future);
        Mockito.when((Object)mockAdminClient.incrementalAlterConfigs((Map)ArgumentMatchers.any())).thenReturn((Object)mockResult);
        PowerMock.replay((Object[])new Object[0]);
        Assert.assertFalse((boolean)lifecycleManager.updateMaxPartitionsIfNecessary(Utils.LC_META_XYZ, Utils.LC_META_ABC));
    }

    private LogicalClusterMetadata reactivateLogicalCluster(LogicalClusterMetadata lkc) throws IOException {
        LogicalClusterMetadata deleted = new LogicalClusterMetadata(lkc.logicalClusterId(), lkc.physicalClusterId(), lkc.logicalClusterName(), lkc.accountId(), lkc.k8sClusterId(), lkc.logicalClusterType(), lkc.storageBytes(), lkc.producerByteRate(), lkc.consumerByteRate(), null, null, Long.valueOf(lkc.brokerRequestPercentage().longValue()), lkc.networkQuotaOverhead(), new LogicalClusterMetadata.LifecycleMetadata(lkc.lifecycleMetadata().logicalClusterName(), lkc.lifecycleMetadata().physicalK8sNamespace(), lkc.lifecycleMetadata().creationDate(), null), null);
        return deleted;
    }
}

