/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.multitenant.SslCertificateSpecification;
import io.confluent.kafka.multitenant.Utils;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SslCertificateSpecificationTest {
    private SslCertificateSpecification sslSpec;
    private Path sslSpecPath;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testSpecFileWithRequiredFields() {
        URL url = this.getClass().getResource("/cert_exp_may/spec.json");
        this.sslSpecPath = Paths.get(url.getPath(), new String[0]);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.sslSpec = (SslCertificateSpecification)objectMapper.readValue(this.sslSpecPath.toFile(), SslCertificateSpecification.class);
        }
        catch (IOException ioe) {
            Assert.fail((String)("Failed to read ssl specification from file " + this.sslSpecPath));
        }
        Assert.assertEquals((Object)"PKCS12", (Object)this.sslSpec.sslKeystoreType());
        Assert.assertEquals((Object)"mystorepassword", (Object)this.sslSpec.getSslKeystorePassword());
        Assert.assertEquals((Object)"pkcs.p12", (Object)this.sslSpec.pkcsCertFilename());
        Assert.assertEquals((Object)"fullchain.pem", (Object)this.sslSpec.sslPemFullchainFilename());
        Assert.assertEquals((Object)"privkey.pem", (Object)this.sslSpec.sslPemPrivkeyFilename());
    }

    @Test
    public void testSpecFileContentMissingKeystoreTypeField() throws IOException {
        this.sslSpecPath = Utils.createSpecFile(this.tempFolder, Utils.SSL_CERT_SPEC_NO_TYPE);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.sslSpec = (SslCertificateSpecification)objectMapper.readValue(this.sslSpecPath.toFile(), SslCertificateSpecification.class);
        }
        catch (IOException ioe) {
            Assert.fail((String)("Failed to read ssl specification from file " + this.sslSpecPath));
        }
        Assert.assertNotEquals((Object)"PKCS12", (Object)this.sslSpec.sslKeystoreType());
        Assert.assertEquals((Object)"pkcs.p12", (Object)this.sslSpec.pkcsCertFilename());
        Assert.assertEquals((Object)"fullchain.pem", (Object)this.sslSpec.sslPemFullchainFilename());
        Assert.assertEquals((Object)"privkey.pem", (Object)this.sslSpec.sslPemPrivkeyFilename());
    }

    @Test
    public void testSpecFileContentMissingKeystoreCertFileField() throws IOException {
        this.sslSpecPath = Utils.createSpecFile(this.tempFolder, Utils.SSL_CERT_SPEC_NO_PKCSFILE);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.sslSpec = (SslCertificateSpecification)objectMapper.readValue(this.sslSpecPath.toFile(), SslCertificateSpecification.class);
        }
        catch (IOException ioe) {
            Assert.fail((String)("Failed to read ssl specification from file " + this.sslSpecPath));
        }
        Assert.assertEquals((Object)"PKCS12", (Object)this.sslSpec.sslKeystoreType());
        Assert.assertNotEquals((Object)"pkcs.p12", (Object)this.sslSpec.pkcsCertFilename());
        Assert.assertEquals((Object)"fullchain.pem", (Object)this.sslSpec.sslPemFullchainFilename());
        Assert.assertEquals((Object)"privkey.pem", (Object)this.sslSpec.sslPemPrivkeyFilename());
    }

    @Test
    public void testSpecFileContentMissingPemFilesField() throws IOException {
        this.sslSpecPath = Utils.createSpecFile(this.tempFolder, Utils.SSL_CERT_SPEC_NO_PEMFILES);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            this.sslSpec = (SslCertificateSpecification)objectMapper.readValue(this.sslSpecPath.toFile(), SslCertificateSpecification.class);
        }
        catch (IOException ioe) {
            Assert.fail((String)("Failed to read ssl specification from file " + this.sslSpecPath));
        }
        Assert.assertEquals((Object)"PKCS12", (Object)this.sslSpec.sslKeystoreType());
        Assert.assertEquals((Object)"pkcs.p12", (Object)this.sslSpec.pkcsCertFilename());
        Assert.assertNotEquals((Object)"fullchain.pem", (Object)this.sslSpec.sslPemFullchainFilename());
        Assert.assertNotEquals((Object)"privkey.pem", (Object)this.sslSpec.sslPemPrivkeyFilename());
    }
}

