/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenantProviderConfigTest {
    @Test
    public void testUnconfigured() {
        MultiTenantAuthorizer mta = new MultiTenantAuthorizer();
        HashMap config = new HashMap();
        mta.configureAccessRuleProviders(config);
        Assert.assertEquals((Object)ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name(), config.get("confluent.authorizer.access.rule.providers"));
    }

    @Test
    public void testConfiguredWithoutMT() {
        MultiTenantAuthorizer mta = new MultiTenantAuthorizer();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("confluent.authorizer.access.rule.providers", String.join((CharSequence)",", ConfluentBuiltInProviders.AccessRuleProviders.ZK_ACL.name(), ConfluentBuiltInProviders.AccessRuleProviders.CONFLUENT.name()));
        mta.configureAccessRuleProviders(config);
        Assert.assertEquals((Object)ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name(), config.get("confluent.authorizer.access.rule.providers"));
    }

    @Test
    public void testConfiguredAsMT() {
        MultiTenantAuthorizer mta = new MultiTenantAuthorizer();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("confluent.authorizer.access.rule.providers", ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name());
        mta.configureAccessRuleProviders(config);
        Assert.assertEquals((Object)ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name(), config.get("confluent.authorizer.access.rule.providers"));
    }

    @Test
    public void testConfiguredWithMTAndOther() {
        MultiTenantAuthorizer mta = new MultiTenantAuthorizer();
        HashMap<String, String> config = new HashMap<String, String>();
        String original = String.join((CharSequence)",", ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name(), ConfluentBuiltInProviders.AccessRuleProviders.CONFLUENT.name());
        config.put("confluent.authorizer.access.rule.providers", original);
        mta.configureAccessRuleProviders(config);
        Assert.assertEquals((Object)original, config.get("confluent.authorizer.access.rule.providers"));
    }
}

