/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.common.multitenant.oauth.OAuthBearerJwsToken;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantPrincipalBuilder;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.oauthbearer.internals.OAuthBearerSaslServer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class MultiTenantPrincipalBuilderTest {
    private static final String OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY = "OAUTHBEARER.token";
    private SaslAuthenticationContext context;
    Map<String, Object> configs;

    @Before
    public void setUp() {
        SaslServer saslServer = (SaslServer)Mockito.mock(OAuthBearerSaslServer.class);
        Mockito.when((Object)saslServer.getNegotiatedProperty(OAUTH_NEGOTIATED_TOKEN_PROPERTY_KEY)).thenReturn((Object)new OAuthBearerJwsToken("", null, 0L, "user", Long.valueOf(0L)));
        Mockito.when((Object)saslServer.getNegotiatedProperty("logicalCluster")).thenReturn((Object)"lkc-abc123");
        this.context = new SaslAuthenticationContext(saslServer, SecurityProtocol.SASL_PLAINTEXT, InetAddress.getLoopbackAddress(), SecurityProtocol.SASL_PLAINTEXT.name());
        this.configs = new HashMap<String, Object>();
        this.configs.put("principal.builder.class", MultiTenantPrincipalBuilder.class);
    }

    @Test
    public void testOauthSaslPrincipalIsSuperuserByDefault() {
        MultiTenantPrincipal principal = (MultiTenantPrincipal)ChannelBuilders.createPrincipalBuilder(this.configs, null, null, null, null).build((AuthenticationContext)this.context);
        Assert.assertTrue((boolean)principal.tenantMetadata().isSuperUser);
    }

    @Test
    public void testOauthSaslPrincipalIsNotSuperuserWhenMultitenantOauthSuperuserDisableIsTrue() {
        this.configs.put("multitenant.oauth.superuser.disable", "true");
        MultiTenantPrincipal principal = (MultiTenantPrincipal)ChannelBuilders.createPrincipalBuilder(this.configs, null, null, null, null).build((AuthenticationContext)this.context);
        Assert.assertFalse((boolean)principal.tenantMetadata().isSuperUser);
    }
}

