/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.multitenant.LogicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.quota.QuotaConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Formatter;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LogicalClusterMetadataTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testLoadMetadataFromFile() throws IOException {
        Path metaFile = this.tempFolder.newFile("lkc-xyz.json").toPath();
        Files.write(metaFile, Utils.logicalClusterJsonString(Utils.LC_META_XYZ).getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assert.assertEquals((Object)Utils.LC_META_XYZ, (Object)meta);
        Assert.assertTrue((boolean)meta.isValid());
    }

    @Test
    public void testLoadMetadataWithNonDefaultOverheadAndRequestRate() throws IOException {
        Path metaFile = this.tempFolder.newFile("lkc-abc.json").toPath();
        Files.write(metaFile, Utils.logicalClusterJsonString(Utils.LC_META_ABC).getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assert.assertEquals((Object)Utils.LC_META_ABC, (Object)meta);
        Assert.assertTrue((boolean)meta.isValid());
    }

    @Test
    public void testDefaultHeadroom() throws IOException {
        LogicalClusterMetadata legacyQuotaMeta = new LogicalClusterMetadata(Utils.LC_META_ABC.logicalClusterId(), Utils.LC_META_ABC.physicalClusterId(), "new-name", "new-account", Utils.LC_META_XYZ.k8sClusterId(), Utils.LC_META_ABC.logicalClusterType(), Utils.LC_META_ABC.storageBytes(), Long.valueOf(0x500000L), Long.valueOf(0x500000L), null, null, Long.valueOf(Utils.LC_META_ABC.brokerRequestPercentage().longValue()), null, null, null);
        Assert.assertEquals((Object)LogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, (Object)legacyQuotaMeta.networkQuotaOverhead());
        QuotaConfig quotaConfig = legacyQuotaMeta.quotaConfig();
        Assert.assertEquals((double)5242880.0, (double)quotaConfig.quota(ClientQuotaType.PRODUCE), (double)0.001);
        Assert.assertEquals((double)5242880.0, (double)quotaConfig.quota(ClientQuotaType.FETCH), (double)0.001);
        Assert.assertEquals((double)Utils.LC_META_ABC.brokerRequestPercentage(), (double)quotaConfig.quota(ClientQuotaType.REQUEST), (double)0.001);
        LogicalClusterMetadata largeConsumeQuotaMeta = new LogicalClusterMetadata(Utils.LC_META_ABC.logicalClusterId(), Utils.LC_META_ABC.physicalClusterId(), "new-name", "new-account", Utils.LC_META_XYZ.k8sClusterId(), Utils.LC_META_ABC.logicalClusterType(), Utils.LC_META_ABC.storageBytes(), Long.valueOf(0x100000L), Long.valueOf(0x6400000L), null, null, Long.valueOf(Utils.LC_META_ABC.brokerRequestPercentage().longValue()), null, null, null);
        Assert.assertEquals((Object)LogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, (Object)largeConsumeQuotaMeta.networkQuotaOverhead());
        quotaConfig = largeConsumeQuotaMeta.quotaConfig();
        Assert.assertEquals((double)1048576.0, (double)quotaConfig.quota(ClientQuotaType.PRODUCE), (double)0.001);
        Assert.assertEquals((double)1.048576E8, (double)quotaConfig.quota(ClientQuotaType.FETCH), (double)0.001);
        Assert.assertEquals((double)Utils.LC_META_ABC.brokerRequestPercentage(), (double)quotaConfig.quota(ClientQuotaType.REQUEST), (double)0.001);
        LogicalClusterMetadata largeQuotaMeta = new LogicalClusterMetadata(Utils.LC_META_ABC.logicalClusterId(), Utils.LC_META_ABC.physicalClusterId(), "new-name", "new-account", Utils.LC_META_XYZ.k8sClusterId(), Utils.LC_META_ABC.logicalClusterType(), Utils.LC_META_ABC.storageBytes(), Long.valueOf(0x6400000L), Long.valueOf(0x6400000L), null, null, Long.valueOf(Utils.LC_META_ABC.brokerRequestPercentage().longValue()), null, null, null);
        Assert.assertEquals((Object)LogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, (Object)largeQuotaMeta.networkQuotaOverhead());
        quotaConfig = largeQuotaMeta.quotaConfig();
        Assert.assertEquals((double)1.048576E8, (double)quotaConfig.quota(ClientQuotaType.PRODUCE), (double)0.001);
        Assert.assertEquals((double)1.048576E8, (double)quotaConfig.quota(ClientQuotaType.FETCH), (double)0.001);
        Assert.assertEquals((double)Utils.LC_META_ABC.brokerRequestPercentage(), (double)quotaConfig.quota(ClientQuotaType.REQUEST), (double)0.001);
    }

    @Test
    public void testZeroQuotas() throws IOException {
        LogicalClusterMetadata zeroQuotaMeta = new LogicalClusterMetadata(Utils.LC_META_ABC.logicalClusterId(), Utils.LC_META_ABC.physicalClusterId(), "new-name", "new-account", Utils.LC_META_XYZ.k8sClusterId(), Utils.LC_META_ABC.logicalClusterType(), Utils.LC_META_ABC.storageBytes(), Long.valueOf(0L), Long.valueOf(0L), null, null, Long.valueOf(Utils.LC_META_ABC.brokerRequestPercentage().longValue()), null, null, null);
        Assert.assertEquals((Object)LogicalClusterMetadata.DEFAULT_MIN_NETWORK_BYTE_RATE, (Object)zeroQuotaMeta.producerByteRate());
        Assert.assertEquals((Object)LogicalClusterMetadata.DEFAULT_MIN_NETWORK_BYTE_RATE, (Object)zeroQuotaMeta.consumerByteRate());
        LogicalClusterMetadata produceZeroQuotaMeta = new LogicalClusterMetadata(Utils.LC_META_ABC.logicalClusterId(), Utils.LC_META_ABC.physicalClusterId(), "new-name", "new-account", Utils.LC_META_XYZ.k8sClusterId(), Utils.LC_META_ABC.logicalClusterType(), Utils.LC_META_ABC.storageBytes(), Long.valueOf(0L), Long.valueOf(0x6400000L), null, null, Long.valueOf(Utils.LC_META_ABC.brokerRequestPercentage().longValue()), null, null, null);
        Assert.assertEquals((Object)LogicalClusterMetadata.DEFAULT_MIN_NETWORK_BYTE_RATE, (Object)produceZeroQuotaMeta.producerByteRate());
        Assert.assertEquals((long)0x6400000L, (long)produceZeroQuotaMeta.consumerByteRate());
        QuotaConfig quotaConfig = produceZeroQuotaMeta.quotaConfig();
        Assert.assertEquals((double)LogicalClusterMetadata.DEFAULT_MIN_NETWORK_BYTE_RATE.longValue(), (double)quotaConfig.quota(ClientQuotaType.PRODUCE), (double)0.001);
        Assert.assertEquals((double)1.048576E8, (double)quotaConfig.quota(ClientQuotaType.FETCH), (double)0.001);
        Assert.assertEquals((double)Utils.LC_META_ABC.brokerRequestPercentage(), (double)quotaConfig.quota(ClientQuotaType.REQUEST), (double)0.001);
    }

    @Test
    public void testLifeCycleMetadataOfLiveCluster() throws IOException {
        Path metaFile = this.tempFolder.newFile("lkc-xyz.json").toPath();
        Files.write(metaFile, Utils.logicalClusterJsonString(Utils.LC_META_XYZ).getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assert.assertEquals((Object)Utils.LC_META_XYZ, (Object)meta);
        Assert.assertEquals((Object)meta.lifecycleMetadata().logicalClusterName(), (Object)"xyz");
    }

    @Test
    public void testLifeCycleMetadataOfDeadCluster() throws IOException {
        Path metaFile = this.tempFolder.newFile("lkc-abs.json").toPath();
        Files.write(metaFile, Utils.logicalClusterJsonString(Utils.LC_META_DED).getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assert.assertEquals((Object)Utils.LC_META_DED, (Object)meta);
        Assert.assertTrue((boolean)meta.lifecycleMetadata().deletionDate().before(new Date()));
    }

    @Test
    public void testMetadataWithNoByteRatesIsValid() throws IOException {
        String lcId = "lkc-fhg";
        String invalidMeta = "{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"kafka\"}";
        Path metaFile = this.tempFolder.newFile("lkc-fhg.json").toPath();
        Files.write(metaFile, "{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"kafka\"}".getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assert.assertNotNull((Object)meta);
        Assert.assertTrue((boolean)meta.isValid());
        Assert.assertNull((Object)meta.producerByteRate());
        Assert.assertNull((Object)meta.consumerByteRate());
        Assert.assertEquals((double)LogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER, (double)meta.brokerRequestPercentage(), (double)0.001);
        QuotaConfig quotaConfig = meta.quotaConfig();
        Assert.assertEquals((double)QuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.PRODUCE), (double)quotaConfig.quota(ClientQuotaType.PRODUCE), (double)0.001);
        Assert.assertEquals((double)QuotaConfig.UNLIMITED_QUOTA.quota(ClientQuotaType.FETCH), (double)quotaConfig.quota(ClientQuotaType.FETCH), (double)0.001);
        Assert.assertEquals((double)LogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER, (double)quotaConfig.quota(ClientQuotaType.REQUEST), (double)0.001);
    }

    @Test
    public void testLoadMetadataWithInvalidClusterType() throws IOException {
        String lcId = "lkc-fhg";
        String invalidMeta = "{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"not-kafka\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": 1024,\"network_egress_byte_rate\": 1024}";
        Path metaFile = this.tempFolder.newFile("lkc-fhg.json").toPath();
        Files.write(metaFile, "{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"not-kafka\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": 1024,\"network_egress_byte_rate\": 1024}".getBytes(), new OpenOption[0]);
        LogicalClusterMetadata meta = this.loadFromFile(metaFile);
        Assert.assertNotNull((Object)meta);
        Assert.assertFalse((boolean)meta.isValid());
        Assert.assertEquals((Object)"lkc-fhg", (Object)meta.logicalClusterId());
        Assert.assertEquals((Object)1024L, (Object)meta.producerByteRate());
        Assert.assertEquals((Object)1024L, (Object)meta.consumerByteRate());
    }

    @Test
    public void testLoadMetadataWithMaxQuotas() throws IOException {
        String lcId = "lkc-fhg";
        String metadataTemplate = "{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"nobody-cares\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": %d,\"network_egress_byte_rate\": %d,\"max_network_ingress_byte_rate\": %d,\"max_network_egress_byte_rate\": %d}";
        File metaFile = this.tempFolder.newFile("lkc-fhg.1.json");
        Formatter formatter = new Formatter(metaFile.toString());
        formatter.format("{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"nobody-cares\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": %d,\"network_egress_byte_rate\": %d,\"max_network_ingress_byte_rate\": %d,\"max_network_egress_byte_rate\": %d}", 1024L, 1024L, 2048L, 2048L);
        formatter.close();
        LogicalClusterMetadata meta = this.loadFromFile(metaFile.toPath());
        Assert.assertNotNull((Object)meta);
        Assert.assertFalse((boolean)meta.isValid());
        Assert.assertEquals((Object)2048L, (Object)meta.producerByteRate());
        Assert.assertEquals((Object)2048L, (Object)meta.consumerByteRate());
        metaFile = this.tempFolder.newFile("lkc-fhg.2.json");
        formatter = new Formatter(metaFile.toString());
        formatter.format("{\"logical_cluster_id\": \"lkc-fhg\",\"physical_cluster_id\": \"pkc-fhg\",\"logical_cluster_name\": \"name\",\"account_id\": \"account\",\"k8s_cluster_id\": \"k8s-cluster\",\"logical_cluster_type\": \"nobody-cares\",\"storage_bytes\": 100,\"network_ingress_byte_rate\": %d,\"network_egress_byte_rate\": %d,\"max_network_ingress_byte_rate\": %d,\"max_network_egress_byte_rate\": %d}", 1024L, 1024L, -1L, -1L);
        formatter.close();
        meta = this.loadFromFile(metaFile.toPath());
        Assert.assertNotNull((Object)meta);
        Assert.assertFalse((boolean)meta.isValid());
        Assert.assertEquals((Object)1024L, (Object)meta.producerByteRate());
        Assert.assertEquals((Object)1024L, (Object)meta.consumerByteRate());
    }

    private LogicalClusterMetadata loadFromFile(Path metaFile) {
        LogicalClusterMetadata retMeta = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            retMeta = (LogicalClusterMetadata)objectMapper.readValue(metaFile.toFile(), LogicalClusterMetadata.class);
        }
        catch (IOException ioe) {
            Assert.fail((String)("Failed to read logical cluster metadata from file " + metaFile));
        }
        return retMeta;
    }
}

