/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common;

import io.confluent.common.EndPoint;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class EndPointTest {
    @Rule
    public final Timeout globalTimeout = Timeout.millis((long)120000L);

    @Test
    public void testEndPointEquals() {
        EndPoint e0 = new EndPoint("foo", 8080, SecurityProtocol.PLAINTEXT);
        EndPoint e1 = new EndPoint("foo", 8080, SecurityProtocol.SASL_SSL);
        EndPoint e2 = new EndPoint("", 8080, SecurityProtocol.PLAINTEXT);
        EndPoint e3 = new EndPoint("foo", 8080, SecurityProtocol.SASL_SSL);
        this.checkNotEqual(e0, e1);
        this.checkNotEqual(e0, e2);
        this.checkNotEqual(e1, e2);
        this.checkEqual(e1, e3);
        this.checkNotEqual(e0, e3);
    }

    private void checkNotEqual(EndPoint a, EndPoint b) {
        Assert.assertFalse((boolean)a.equals((Object)b));
        Assert.assertFalse((boolean)b.equals((Object)a));
    }

    private void checkEqual(EndPoint a, EndPoint b) {
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertEquals((Object)b, (Object)a);
        Assert.assertEquals((long)a.hashCode(), (long)b.hashCode());
        Assert.assertEquals((long)b.hashCode(), (long)a.hashCode());
    }

    @Test
    public void testEndPointParsing() {
        this.checkEndPoint(SecurityProtocol.PLAINTEXT, "", 8080, "PLAINTEXT://:8080");
        this.checkEndPoint(SecurityProtocol.SASL_SSL, "2001:0db8:85a3:0000:0000:8a2e:0370:7334", 23, "SASL_SSL://[2001:0db8:85a3:0000:0000:8a2e:0370:7334]:23");
        this.checkEndPoint(SecurityProtocol.SSL, "example.com", 9999, "SSL://example.com:9999");
    }

    private void checkEndPoint(SecurityProtocol securityProtocol, String host, int port, String connectionString) {
        EndPoint ep0 = new EndPoint(host, port, securityProtocol);
        EndPoint ep1 = EndPoint.parse((String)connectionString);
        Assert.assertEquals((Object)ep0, (Object)ep1);
        Assert.assertEquals((Object)ep1, (Object)ep0);
        Assert.assertEquals((long)ep0.hashCode(), (long)ep1.hashCode());
        Assert.assertEquals((long)ep1.hashCode(), (long)ep0.hashCode());
        Assert.assertEquals((Object)connectionString, (Object)ep0.toString());
        Assert.assertEquals((Object)connectionString, (Object)ep1.toString());
    }

    @Test(expected=RuntimeException.class)
    public void testEndPointParsingFailsWithoutName() {
        EndPoint.parse((String)"febtober");
    }

    @Test(expected=RuntimeException.class)
    public void testEndPointParsingFailsWithoutPort() {
        EndPoint.parse((String)"PLAINTEXT://example");
    }
}

