/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.test;

import io.committed.invest.test.BeanTestSupport;
import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LombokDataTestSupport {
    private static final Logger log = LoggerFactory.getLogger(LombokDataTestSupport.class);

    public void testPackage(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        ScanResult scanResult = new FastClasspathScanner(new String[]{packageName}).disableRecursiveScanning().scan();
        scanResult.getClassNameToClassInfo().values().stream().filter(i -> i.getClassName().startsWith(packageName)).forEach(this::testClassInfo);
    }

    public void testClassInfo(ClassInfo info) {
        try {
            Class<?> loadedClass = this.getClass().getClassLoader().loadClass(info.getClassName());
            this.testClass(loadedClass);
        }
        catch (Exception e) {
            log.error("Unable to create class to test", (Throwable)e);
        }
    }

    public void testClasses(Class<?> ... classess) {
        Arrays.stream(classess).forEach(this::testClass);
    }

    public void testClass(Class<?> clazz) {
        if (this.isTestClass(clazz)) {
            return;
        }
        int modifiers = clazz.getModifiers();
        if (Modifier.isInterface(modifiers)) {
            return;
        }
        try {
            if (Modifier.isAbstract(modifiers)) {
                this.testAbstractClass(clazz);
            } else {
                this.testConcreteClass(clazz);
            }
        }
        catch (AssertionError | Exception e) {
            this.rethrowWithClass(clazz, (Throwable)e);
        }
    }

    private boolean isTestClass(Class<?> clazz) {
        for (Method m : clazz.getMethods()) {
            if (!m.isAnnotationPresent(Test.class)) continue;
            return true;
        }
        return false;
    }

    protected void testAbstractClass(Class<?> clazz) {
        EqualsVerifier.forClass(clazz).suppress(new Warning[]{Warning.STRICT_INHERITANCE, Warning.NONFINAL_FIELDS}).verify();
    }

    protected void testConcreteClass(Class<?> clazz) throws InstantiationException, IllegalAccessException, NotFoundException, CannotCompileException {
        int modifiers = clazz.getModifiers();
        if (Modifier.isAbstract(modifiers) || clazz.equals(this.getClass())) {
            return;
        }
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            log.warn("Unable to test {} as no default constructor", (Object)clazz.getSimpleName());
            return;
        }
        BeanTestSupport.test(clazz);
        EqualsVerifier.forClass(clazz).withRedefinedSuperclass().suppress(new Warning[]{Warning.STRICT_INHERITANCE, Warning.NONFINAL_FIELDS}).verify();
        if (!Modifier.isFinal(modifiers)) {
            Assert.assertFalse((boolean)clazz.newInstance().equals(LombokDataTestSupport.createSubClassInstance(clazz.getName())));
        }
    }

    private void rethrowWithClass(Class<?> clazz, Throwable e) throws AssertionError {
        throw new AssertionError(String.format("%s: %s", clazz.getSimpleName(), e.getMessage()), e);
    }

    static Object createSubClassInstance(String superClassName) throws NotFoundException, CannotCompileException, InstantiationException, IllegalAccessException {
        ClassPool pool = ClassPool.getDefault();
        CtClass subClass = pool.makeClass(superClassName + "Extended");
        CtClass superClass = pool.get(superClassName);
        subClass.setSuperclass(superClass);
        subClass.setModifiers(1);
        CtClass[] params = new CtClass[]{};
        CtConstructor ctor = CtNewConstructor.make((CtClass[])params, null, (int)2, null, null, (CtClass)subClass);
        subClass.addConstructor(ctor);
        CtMethod ctmethod = CtNewMethod.make((String)("public boolean canEqual(Object o) { return o instanceof " + superClassName + "Extended; }"), (CtClass)subClass);
        subClass.addMethod(ctmethod);
        return subClass.toClass().newInstance();
    }
}

