/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.test;

import java.time.Instant;
import java.util.Optional;
import java.util.stream.Stream;
import org.meanbean.lang.Factory;
import org.meanbean.test.BeanTester;
import org.meanbean.util.RandomValueGenerator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BeanTestSupport {
    private static final long MAX_TIME = 2L * System.currentTimeMillis();
    private static final int MAX_ARRAY_SIZE = 10;
    private static final BeanTester beanTester = new BeanTester();

    private BeanTestSupport() {
    }

    public static RandomValueGenerator getRandomValueGenerator() {
        return beanTester.getRandomValueGenerator();
    }

    public static <T> void addFactory(Class<T> clazz, Factory<T> factory) {
        beanTester.getFactoryCollection().addFactory(clazz, factory);
    }

    public static <T> T generateValue(Class<T> clazz) {
        return (T)beanTester.getFactoryCollection().getFactory(clazz).create();
    }

    public static <T> T generateValue(Class<T> clazz, T defaultValue) {
        try {
            return BeanTestSupport.generateValue(clazz);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static void test(Class<?> clazz) {
        beanTester.testBean(clazz);
    }

    static {
        beanTester.setIterations(2);
        RandomValueGenerator rvg = BeanTestSupport.getRandomValueGenerator();
        BeanTestSupport.addFactory(Instant.class, () -> Instant.ofEpochMilli(Math.abs(rvg.nextLong()) % MAX_TIME));
        BeanTestSupport.addFactory(Class.class, () -> Object.class);
        BeanTestSupport.addFactory(Flux.class, Flux::empty);
        BeanTestSupport.addFactory(Optional.class, Optional::empty);
        BeanTestSupport.addFactory(Mono.class, Mono::empty);
        BeanTestSupport.addFactory(Publisher.class, Mono::empty);
        BeanTestSupport.addFactory(Stream.class, Stream::empty);
        BeanTestSupport.addFactory(String[].class, () -> {
            int size = Math.abs(rvg.nextInt()) % 10;
            String[] a = new String[size];
            for (int i = 0; i < size; ++i) {
                a[i] = BeanTestSupport.generateValue(String.class, Long.toString(rvg.nextLong()));
            }
            return a;
        });
    }
}

