/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.core.services;

import io.committed.invest.extensions.InvestExtension;
import io.committed.invest.extensions.collections.InvestExtensions;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExtensionLogger {
    private static final Logger log = LoggerFactory.getLogger(ExtensionLogger.class);
    @Autowired(required=false)
    private List<InvestExtension> extensions;
    @Autowired(required=false)
    private List<InvestExtensions> multiExtensions;

    @PostConstruct
    public void postConstruct() {
        int total = 0;
        if (this.extensions != null && !this.extensions.isEmpty()) {
            this.extensions.forEach(this::logExtension);
            total += this.extensions.size();
        }
        if (this.multiExtensions != null && !this.multiExtensions.isEmpty()) {
            this.multiExtensions.forEach(m -> m.stream().forEach(this::logExtension));
            total += this.multiExtensions.stream().reduce(0, (a, e) -> a + e.getExtensions().size(), Integer::sum).intValue();
        }
        if (total == 0) {
            log.warn("No extensions found");
        } else {
            log.info("Found {} extensions", (Object)total);
        }
    }

    private void logExtension(InvestExtension e) {
        log.info("Found extension {} with name {} of type {}", new Object[]{e.getId(), e.getName(), e.getClass()});
    }
}

