/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.core.config;

import io.committed.invest.core.services.UiUrlService;
import io.committed.invest.extensions.InvestUiExtension;
import io.committed.invest.extensions.registry.InvestUiExtensionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.config.CorsRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

@Configuration
public class UiMerger
implements WebFluxConfigurer {
    private static final Logger log = LoggerFactory.getLogger(UiMerger.class);
    @Autowired(required=false)
    private InvestUiExtensionRegistry uiRegistry;
    @Autowired
    private UiUrlService urlService;

    @Bean
    public RouterFunction<ServerResponse> uiExtensionRoutes() {
        if (this.uiRegistry.isEmpty()) {
            log.warn("No UI extension points defined");
        }
        RouterFunction combined = RouterFunctions.route((RequestPredicate)RequestPredicates.path((String)"/"), request -> ServerResponse.ok().build());
        for (InvestUiExtension e : this.uiRegistry.getExtensions()) {
            String classPath = e.getStaticResourcePath();
            if (StringUtils.isEmpty((Object)classPath)) continue;
            String urlPath = this.urlService.getContextRelativePath(e);
            combined = combined.andNest(RequestPredicates.path((String)urlPath), RouterFunctions.resources((String)"/**", (Resource)new ClassPathResource(classPath, e.getClass().getClassLoader())));
        }
        return RouterFunctions.nest((RequestPredicate)RequestPredicates.path((String)this.urlService.getContextPath()), (RouterFunction)combined);
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping(String.valueOf(this.urlService.getContextPath()) + "/**").allowedHeaders(new String[]{"*"}).allowedMethods(new String[]{"GET", "OPTIONS"}).allowedOrigins(new String[]{"*"});
    }
}

