/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.graphql.mappers;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import io.leangen.graphql.util.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MonoAdapter<T>
extends AbstractTypeAdapter<Mono<T>, T> {
    private static final Logger log = LoggerFactory.getLogger(MonoAdapter.class);

    public T convertOutput(Mono<T> original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        try {
            return (T)original.map(inner -> resolutionEnvironment.convertOutput(inner, this.getSubstituteType(type))).block();
        }
        catch (Exception e) {
            log.error("Unable to convert mono {}, returning null", (Object)e.getMessage());
            log.debug("Exception was:", (Throwable)e);
            return null;
        }
    }

    public AnnotatedType getSubstituteType(AnnotatedType original) {
        AnnotatedType innerType = GenericTypeReflector.getTypeParameter((AnnotatedType)original, Mono.class.getTypeParameters()[0]);
        return ClassUtils.addAnnotations((AnnotatedType)innerType, (Annotation[])original.getAnnotations());
    }

    public Mono<T> convertInput(T substitute, AnnotatedType type, GlobalEnvironment environment, ValueMapper valueMapper) {
        return Mono.justOrEmpty((Optional)((Optional)environment.convertInput(substitute, this.getSubstituteType(type), valueMapper)));
    }
}

