/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.graphql.mappers;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeFactory;
import io.leangen.graphql.execution.GlobalEnvironment;
import io.leangen.graphql.execution.ResolutionEnvironment;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.metadata.strategy.value.ValueMapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class FluxToCollectionTypeAdapter<T>
extends AbstractTypeAdapter<Flux<T>, List<T>> {
    private static final Logger log = LoggerFactory.getLogger(FluxToCollectionTypeAdapter.class);

    public List<T> convertOutput(Flux<T> original, AnnotatedType type, ResolutionEnvironment resolutionEnvironment) {
        try {
            return (List)original.map(item -> resolutionEnvironment.convertOutput(item, this.getElementType(type))).collect(Collectors.toList()).block();
        }
        catch (Exception e) {
            log.error("Unable to convert flux {}, returning empty", (Object)e.getMessage());
            log.debug("Exception was:", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Flux<T> convertInput(List<T> substitute, AnnotatedType type, GlobalEnvironment environment, ValueMapper valueMapper) {
        return Flux.fromIterable(substitute).map(item -> environment.convertInput(item, this.getElementType(type), valueMapper));
    }

    public AnnotatedType getSubstituteType(AnnotatedType original) {
        return TypeFactory.parameterizedAnnotatedClass(List.class, (Annotation[])original.getAnnotations(), (AnnotatedType[])new AnnotatedType[]{this.getElementType(original)});
    }

    private AnnotatedType getElementType(AnnotatedType type) {
        return GenericTypeReflector.getTypeParameter((AnnotatedType)type, Flux.class.getTypeParameters()[0]);
    }
}

