/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.graphql;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.committed.invest.core.exceptions.InvestRuntimeException;
import io.committed.invest.core.graphql.InvestRootContext;
import io.committed.invest.server.graphql.data.GraphQlQuery;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Component
public class GraphQlHandler {
    private static final Logger log = LoggerFactory.getLogger(GraphQlHandler.class);
    private static final TypeReference<Map<String, Object>> mapStringObject = new TypeReference<Map<String, Object>>(){};
    private final GraphQL graphQL;
    private final ObjectMapper mapper;

    @Autowired
    public GraphQlHandler(GraphQLSchema graphQLSchema, ObjectMapper mapper) {
        this.mapper = mapper;
        this.graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).build();
    }

    public Mono<ServerResponse> postQuery(ServerRequest request) {
        Mono result = request.bodyToMono(GraphQlQuery.class).map(q -> ExecutionInput.newExecutionInput().operationName(q.getOperationName()).query(q.getQuery()).variables(q.getVariables()).context((Object)this.buildContext(request)).build()).flatMap(this::performQuery);
        return this.convertResultToServerResponse((Mono<ExecutionResult>)result);
    }

    public Mono<ServerResponse> getQuery(ServerRequest request) {
        Optional query = request.queryParam("query");
        Optional operationName = request.queryParam("operationName");
        Optional variablesString = request.queryParam("variables");
        ExecutionInput.Builder input = ExecutionInput.newExecutionInput();
        if (query.isPresent()) {
            input = input.query((String)query.get());
        }
        if (operationName.isPresent()) {
            input = input.operationName((String)operationName.get());
        }
        if (variablesString.isPresent()) {
            try {
                input = input.variables((Map)this.mapper.readValue((String)variablesString.get(), mapStringObject));
            }
            catch (Exception e) {
                log.warn("Dropping variables unable to deserialise", (Throwable)e);
            }
        }
        InvestRootContext context = this.buildContext(request);
        input = input.context((Object)context);
        Mono<ExecutionResult> result = this.performQuery(input.build());
        return this.convertResultToServerResponse(result);
    }

    private InvestRootContext buildContext(ServerRequest request) {
        return InvestRootContext.builder().authentication(request.session().flatMap(s -> {
            SecurityContext sc = (SecurityContext)s.getAttribute("USER");
            return sc != null && sc.getAuthentication() != null ? Mono.just((Object)sc.getAuthentication()) : Mono.empty();
        })).session(request.session()).build();
    }

    public Mono<ServerResponse> getSchema(ServerRequest request) {
        ExecutionInput input = ExecutionInput.newExecutionInput().query("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\n  fragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n        }\n      }\n    }\n  }\n").build();
        Mono<ExecutionResult> result = this.performQuery(input);
        return this.convertResultToServerResponse(result);
    }

    protected Mono<ExecutionResult> performQuery(ExecutionInput input) {
        try {
            Mono blockingWrapper = Mono.fromCallable(() -> this.graphQL.execute(input));
            blockingWrapper = blockingWrapper.subscribeOn(Schedulers.elastic());
            return blockingWrapper;
        }
        catch (Exception e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            log.debug("Exception was: ", (Throwable)e);
            throw new InvestRuntimeException(rootCause.getMessage());
        }
    }

    private Mono<ServerResponse> convertResultToServerResponse(Mono<ExecutionResult> result) {
        return ServerResponse.ok().body((Publisher)result.map(ExecutionResult::toSpecification), Map.class);
    }
}

