/*
 * Decompiled with CFR 0.152.
 */
package io.committed.invest.server.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaPrinter;
import io.committed.invest.extensions.annotations.GraphQLService;
import io.committed.invest.server.graphql.GraphQlHandler;
import io.committed.invest.server.graphql.NoopGraphQLService;
import io.committed.invest.server.graphql.data.GraphQlServices;
import io.committed.invest.server.graphql.mappers.FluxToCollectionTypeAdapter;
import io.committed.invest.server.graphql.mappers.MonoAdapter;
import io.leangen.graphql.GraphQLSchemaGenerator;
import io.leangen.graphql.generator.mapping.AbstractTypeAdapter;
import io.leangen.graphql.metadata.strategy.value.ValueMapperFactory;
import io.leangen.graphql.metadata.strategy.value.jackson.JacksonValueMapperFactory;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.util.ClassUtils;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

@Configuration
public class GraphQlConfig {
    private static final Logger log = LoggerFactory.getLogger(GraphQlConfig.class);
    @Autowired
    private ApplicationContext context;

    @Bean
    public RouterFunction<ServerResponse> graphQlRouterFunction(GraphQlHandler handler) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.POST((String)"/graphql").and(RequestPredicates.accept((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON})), handler::postQuery).andRoute(RequestPredicates.GET((String)"/graphql"), handler::getQuery).andRoute(RequestPredicates.GET((String)"/schema.json"), handler::getSchema);
    }

    @Bean
    public GraphQlHandler graphQlHandler(GraphQLSchema schema, ObjectMapper mapper) {
        return new GraphQlHandler(schema, mapper);
    }

    @Bean
    public GraphQlServices graphQlServices() {
        Map beansWithAnnotation = this.context.getBeansWithAnnotation(GraphQLService.class);
        return new GraphQlServices(Collections.unmodifiableCollection(beansWithAnnotation.values()));
    }

    @Bean
    public GraphQLSchema schema(GraphQlServices services) {
        GraphQLSchemaGenerator factory = new GraphQLSchemaGenerator().withDefaults().withValueMapperFactory((ValueMapperFactory)new JacksonValueMapperFactory()).withTypeAdapters(new AbstractTypeAdapter[]{new MonoAdapter(), new FluxToCollectionTypeAdapter()});
        if (services.getServices().isEmpty()) {
            factory = factory.withOperationsFromSingleton((Object)new NoopGraphQLService());
        }
        for (Object service : services.getServices()) {
            Class userClass = ClassUtils.getUserClass((Object)service);
            factory = factory.withOperationsFromSingleton(service, (Type)userClass);
        }
        GraphQLSchema schema = factory.generate();
        String schemaString = new SchemaPrinter().print(schema);
        log.info(schemaString);
        return schema;
    }
}

