/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.util;

import codechicken.diffpatch.util.Diff;
import codechicken.diffpatch.util.LineRange;
import codechicken.diffpatch.util.Operation;
import codechicken.repack.net.covers1624.quack.collection.FastStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class Patch {
    public List<Diff> diffs;
    public int start1;
    public int start2;
    public int length1;
    public int length2;

    public Patch() {
        this.diffs = new ArrayList<Diff>();
    }

    public Patch(Patch other) {
        this.diffs = FastStream.of(other.diffs).map(Diff::new).toList();
        this.start1 = other.start1;
        this.start2 = other.start2;
        this.length1 = other.length1;
        this.length2 = other.length2;
    }

    private LineRange trimRange(LineRange range) {
        int end;
        int start;
        for (start = 0; start < this.diffs.size() && this.diffs.get((int)start).op == Operation.EQUAL; ++start) {
        }
        if (start == this.diffs.size()) {
            return LineRange.fromStartLen(range.getStart(), 0);
        }
        for (end = this.diffs.size(); end > start && this.diffs.get((int)(end - 1)).op == Operation.EQUAL; --end) {
        }
        return new LineRange(range.getStart() + start, range.getEnd() - (this.diffs.size() - end));
    }

    public void recalculateLength() {
        this.length1 = this.diffs.size();
        this.length2 = this.diffs.size();
        for (Diff diff : this.diffs) {
            if (diff.op == Operation.DELETE) {
                --this.length2;
                continue;
            }
            if (diff.op != Operation.INSERT) continue;
            --this.length1;
        }
    }

    public void trim(int numContextLines) {
        LineRange r = this.trimRange(LineRange.fromStartLen(0, this.diffs.size()));
        if (r.getLength() == 0) {
            this.length2 = 0;
            this.length1 = 0;
            this.diffs.clear();
            return;
        }
        int trimStart = r.getStart() - numContextLines;
        int trimEnd = this.diffs.size() - r.getEnd() - numContextLines;
        if (trimStart > 0) {
            this.diffs.subList(0, trimStart).clear();
            this.start1 += trimStart;
            this.start2 += trimStart;
            this.length1 -= trimStart;
            this.length2 -= trimStart;
        }
        if (trimEnd > 0) {
            this.diffs.subList(this.diffs.size() - trimEnd, this.diffs.size()).clear();
            this.length1 -= trimEnd;
            this.length2 -= trimEnd;
        }
    }

    public void uncollate() {
        ArrayList<Diff> unCollatedDiffs = new ArrayList<Diff>(this.diffs.size());
        ArrayList<Diff> addDiffs = new ArrayList<Diff>();
        for (Diff d : this.diffs) {
            if (d.op == Operation.DELETE) {
                unCollatedDiffs.add(d);
                continue;
            }
            if (d.op == Operation.INSERT) {
                addDiffs.add(d);
                continue;
            }
            unCollatedDiffs.addAll(addDiffs);
            addDiffs.clear();
            unCollatedDiffs.add(d);
        }
        unCollatedDiffs.addAll(addDiffs);
        this.diffs = unCollatedDiffs;
    }

    public List<Patch> split(int numContextLines) {
        if (this.diffs.size() == 0) {
            return new ArrayList<Patch>();
        }
        ArrayList<LineRange> ranges = new ArrayList<LineRange>();
        int start = 0;
        int n = 0;
        for (int i = 0; i < this.diffs.size(); ++i) {
            if (this.diffs.get((int)i).op == Operation.EQUAL) {
                ++n;
                continue;
            }
            if (n > numContextLines * 2) {
                ranges.add(new LineRange(start, i - n + numContextLines));
                start = i - numContextLines;
            }
            n = 0;
        }
        ranges.add(new LineRange(start, this.diffs.size()));
        ArrayList<Patch> patches = new ArrayList<Patch>(this.diffs.size());
        int end1 = this.start1;
        int end2 = this.start2;
        int endDiffIndex = 0;
        for (LineRange r : ranges) {
            int skip = r.getStart() - endDiffIndex;
            Patch patch = new Patch();
            patch.start1 = end1 + skip;
            patch.start2 = end2 + skip;
            patch.diffs = new ArrayList<Diff>(this.diffs.subList(r.getStart(), r.getEnd()));
            patch.recalculateLength();
            patches.add(patch);
            end1 = patch.start1 + patch.length1;
            end2 = patch.start2 + patch.length2;
            endDiffIndex = r.getEnd();
        }
        return patches;
    }

    public void combine(Patch patch2, List<String> lines1) {
        if (this.getRange1().intersects(patch2.getRange1()) || this.getRange2().intersects(patch2.getRange2())) {
            throw new IllegalArgumentException("Patches overlap");
        }
        while (this.start1 + this.length1 < patch2.start1) {
            this.diffs.add(new Diff(Operation.EQUAL, lines1.get(this.start1 + this.length1)));
            ++this.length1;
            ++this.length2;
        }
        if (this.start2 + this.length2 != patch2.start2) {
            throw new IllegalArgumentException("Unequal distance between end of patch1 and start of patch2 in context and patched");
        }
        this.diffs.addAll(patch2.diffs);
        this.length1 += patch2.length1;
        this.length2 += patch2.length2;
    }

    public String getHeader() {
        return String.format("@@ -%d,%d +%d,%d @@", this.start1 + 1, this.length1, this.start2 + 1, this.length2);
    }

    public String getAutoHeader() {
        return String.format("@@ -%d,%d +_,%d @@", this.start1 + 1, this.length1, this.length2);
    }

    public List<String> getContextLines() {
        return this.getContextLines(Function.identity());
    }

    public List<String> getContextLines(Function<String, String> f) {
        return FastStream.of(this.diffs).filter(e -> e.op != Operation.INSERT).map(e -> (String)f.apply(e.text)).toList();
    }

    public List<String> getPatchedLines() {
        return this.getPatchedLines(Function.identity());
    }

    public List<String> getPatchedLines(Function<String, String> f) {
        return FastStream.of(this.diffs).filter(e -> e.op != Operation.DELETE).map(e -> (String)f.apply(e.text)).toList();
    }

    public LineRange getRange1() {
        return LineRange.fromStartLen(this.start1, this.length1);
    }

    public LineRange getRange2() {
        return LineRange.fromStartLen(this.start2, this.length2);
    }

    public LineRange getTrimmedRange1() {
        return this.trimRange(this.getRange1());
    }

    public LineRange getTrimmedRange2() {
        return this.trimRange(this.getRange2());
    }

    public String toString() {
        return this.getHeader() + "\n" + FastStream.of(this.diffs).map(Diff::toString).join("\n");
    }
}

