/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.cli;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.diff.Differ;
import codechicken.diffpatch.diff.PatienceDiffer;
import codechicken.diffpatch.util.FileCollector;
import codechicken.diffpatch.util.InputPath;
import codechicken.diffpatch.util.LogLevel;
import codechicken.diffpatch.util.Operation;
import codechicken.diffpatch.util.OutputPath;
import codechicken.diffpatch.util.PatchFile;
import codechicken.diffpatch.util.Utils;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import codechicken.diffpatch.util.archiver.ArchiveReader;
import codechicken.diffpatch.util.archiver.ArchiveWriter;
import codechicken.repack.net.covers1624.quack.collection.FastStream;
import codechicken.repack.net.covers1624.quack.io.IOUtils;
import codechicken.repack.net.covers1624.quack.io.NullOutputStream;
import codechicken.repack.net.covers1624.quack.util.SneakyUtils;
import codechicken.repack.org.apache.commons.lang3.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class DiffOperation
extends CliOperation<DiffSummary> {
    private final boolean summary;
    private final InputPath aPath;
    private final InputPath bPath;
    private final String aPrefix;
    private final String bPrefix;
    private final boolean autoHeader;
    private final int context;
    private final OutputPath outputPath;
    private final String lineEnding;
    private final String[] ignorePrefixes;

    private DiffOperation(PrintStream logger, LogLevel level, Consumer<PrintStream> helpCallback, boolean summary, InputPath aPath, InputPath bPath, String aPrefix, String bPrefix, boolean autoHeader, int context, OutputPath outputPath, String lineEnding, String[] ignorePrefixes) {
        super(logger, level, helpCallback);
        this.summary = summary;
        this.aPath = aPath;
        this.bPath = bPath;
        this.aPrefix = aPrefix;
        this.bPrefix = bPrefix;
        this.autoHeader = autoHeader;
        this.context = context;
        this.outputPath = outputPath;
        this.lineEnding = lineEnding;
        this.ignorePrefixes = ignorePrefixes;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CliOperation.Result<DiffSummary> operate() throws IOException {
        DiffSummary summary;
        FileCollector patches;
        block71: {
            Set<String> aIndex;
            if (!this.aPath.exists()) {
                this.log(LogLevel.ERROR, "File A doesn't exist.", new Object[0]);
                return new CliOperation.Result<DiffSummary>(-1);
            }
            if (!this.bPath.exists()) {
                this.log(LogLevel.ERROR, "File B doesn't exist.", new Object[0]);
                return new CliOperation.Result<DiffSummary>(-1);
            }
            patches = new FileCollector();
            summary = new DiffSummary();
            if (this.aPath.isFile() && this.bPath.isFile() && this.aPath.getFormat() == null && this.bPath.getFormat() == null) {
                if (this.outputPath.getFormat() != null) {
                    this.log(LogLevel.ERROR, "Can't specify output format when diffing regular files.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
                if (this.outputPath.getType().isPath() && Files.exists(this.outputPath.toPath(), new LinkOption[0]) && !Files.isRegularFile(this.outputPath.toPath(), new LinkOption[0])) {
                    this.log(LogLevel.ERROR, "Output already exists and is not a file.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
                List<String> lines = this.doDiff(summary, this.aPath.toPath().toString(), this.bPath.toPath().toString(), this.aPath.readAllLines(), this.bPath.readAllLines(), this.context, this.autoHeader);
                boolean changes = false;
                if (!lines.isEmpty()) {
                    changes = true;
                    try (PrintWriter out = new PrintWriter(this.outputPath.open());){
                        out.println(String.join((CharSequence)this.lineEnding, lines) + this.lineEnding);
                    }
                }
                if (this.summary) {
                    summary.print(this.logger, true);
                }
                return new CliOperation.Result<DiffSummary>(changes ? 1 : 0, summary);
            }
            if (this.outputPath.getType().isPath()) {
                if (this.outputPath.getFormat() != null) {
                    if (Files.exists(this.outputPath.toPath(), new LinkOption[0]) && !Files.isRegularFile(this.outputPath.toPath(), new LinkOption[0])) {
                        this.log(LogLevel.ERROR, "Output already exists and is not a file.", new Object[0]);
                        this.printHelp();
                        return new CliOperation.Result<DiffSummary>(-1);
                    }
                } else if (Files.exists(this.outputPath.toPath(), new LinkOption[0]) && !Files.isDirectory(this.outputPath.toPath(), new LinkOption[0])) {
                    this.log(LogLevel.ERROR, "Output already exists and is not a directory.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
            }
            if (this.aPath.isFile() && this.bPath.isFile()) {
                if (this.aPath.getFormat() == null) {
                    this.log(LogLevel.ERROR, "File A is in an unknown archive format.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
                if (this.bPath.getFormat() == null) {
                    this.log(LogLevel.ERROR, "File B is in an unknown archive format.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
                try (ArchiveReader aReader = this.aPath.getFormat().createReader(this.aPath.open());
                     ArchiveReader bReader = this.bPath.getFormat().createReader(this.bPath.open());){
                    aIndex = DiffOperation.filterPrefixed(aReader.getEntries(), this.ignorePrefixes);
                    Set<String> set = DiffOperation.filterPrefixed(bReader.getEntries(), this.ignorePrefixes);
                    this.doDiff(patches, summary, aIndex, set, aReader::readLines, bReader::readLines, this.context, this.autoHeader);
                    break block71;
                }
            }
            if (!this.aPath.isFile() && !this.bPath.isFile()) {
                Map<String, Path> aFiles = Utils.indexChildren(this.aPath.toPath());
                Map<String, Path> bFiles = Utils.indexChildren(this.bPath.toPath());
                aIndex = DiffOperation.filterPrefixed(aFiles.keySet(), this.ignorePrefixes);
                Set<String> set = DiffOperation.filterPrefixed(bFiles.keySet(), this.ignorePrefixes);
                this.doDiff(patches, summary, aIndex, set, e -> Files.readAllLines((Path)aFiles.get(e)), e -> Files.readAllLines((Path)bFiles.get(e)), this.context, this.autoHeader);
            } else {
                void var6_21;
                Set<String> aIndex2;
                LinesReader aFunc;
                Map<String, Path> pathIndex;
                if (!this.aPath.isFile()) {
                    if (this.bPath.getFormat() == null) {
                        this.log(LogLevel.ERROR, "File B is in an unknown format, whilst File A is a directory.", new Object[0]);
                        this.printHelp();
                        return new CliOperation.Result<DiffSummary>(-1);
                    }
                    pathIndex = Utils.indexChildren(this.aPath.toPath());
                    Set<String> aIndex22 = pathIndex.keySet();
                    aFunc = e -> Files.readAllLines((Path)pathIndex.get(e));
                    try (ArchiveReader reader = this.bPath.getFormat().createReader(this.bPath.open());){
                        Set<String> bIndex2 = reader.getEntries();
                        LinesReader linesReader = reader::readLines;
                    }
                }
                if (this.aPath.getFormat() == null) {
                    this.log(LogLevel.ERROR, "File A is in an unknown format, whilst File B is a directory.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
                try (ArchiveReader reader = this.aPath.getFormat().createReader(this.aPath.open());){
                    aIndex2 = reader.getEntries();
                    aFunc = reader::readLines;
                }
                pathIndex = Utils.indexChildren(this.bPath.toPath());
                Iterator<Map.Entry<String, FileCollector.CollectedEntry>> bIndex = pathIndex.keySet();
                LinesReader linesReader = e -> Files.readAllLines((Path)pathIndex.get(e));
                aIndex2 = DiffOperation.filterPrefixed(aIndex2, this.ignorePrefixes);
                bIndex = DiffOperation.filterPrefixed(bIndex, this.ignorePrefixes);
                this.doDiff(patches, summary, aIndex2, (Set<String>)((Object)bIndex), aFunc, (LinesReader)var6_21, this.context, this.autoHeader);
            }
        }
        boolean changes = false;
        if (!patches.isEmpty()) {
            changes = true;
            if (this.outputPath.getType().isPipe() && this.outputPath.getFormat() == null) {
                try (PrintWriter out = new PrintWriter(this.outputPath.open());){
                    for (FileCollector.CollectedEntry collectedEntry : patches.values()) {
                        List<String> lines = ((FileCollector.LinesCollectedEntry)collectedEntry).lines;
                        lines.forEach(line -> {
                            out.print((String)line);
                            out.print(this.lineEnding);
                        });
                    }
                }
            } else if (this.outputPath.getFormat() != null) {
                try (ArchiveWriter writer = this.outputPath.getFormat().createWriter(this.outputPath.open());){
                    for (Map.Entry<String, FileCollector.CollectedEntry> entry : patches.get().entrySet()) {
                        writer.writeEntry(entry.getKey(), entry.getValue().toBytes(this.lineEnding, true));
                    }
                }
            } else {
                if (Files.exists(this.outputPath.toPath(), new LinkOption[0])) {
                    Utils.deleteFolder(this.outputPath.toPath());
                }
                for (Map.Entry<String, FileCollector.CollectedEntry> entry : patches.get().entrySet()) {
                    Path path = this.outputPath.toPath().resolve(entry.getKey());
                    Files.write(IOUtils.makeParents(path), entry.getValue().toBytes(this.lineEnding, true), new OpenOption[0]);
                }
            }
        }
        if (this.summary) {
            summary.print(this.logger, false);
        }
        return new CliOperation.Result<DiffSummary>(changes ? 1 : 0, summary);
    }

    public void doDiff(FileCollector patches, DiffSummary summary, Set<String> aEntries, Set<String> bEntries, LinesReader aFunc, LinesReader bFunc, int context, boolean autoHeader) {
        String aName;
        List<String> patchLines;
        List<String> bLines;
        List<String> aLines;
        ArrayList<String> added = FastStream.of(bEntries).filter(e -> !aEntries.contains(e)).sorted().toList();
        ArrayList<String> common = FastStream.of(aEntries).filter(bEntries::contains).sorted().toList();
        ArrayList<String> removed = FastStream.of(aEntries).filter(e -> !bEntries.contains(e)).sorted().toList();
        String aPrefix = StringUtils.appendIfMissing(StringUtils.isEmpty(this.aPrefix) ? "a" : this.aPrefix, (CharSequence)"/", new CharSequence[0]);
        String bPrefix = StringUtils.appendIfMissing(StringUtils.isEmpty(this.bPrefix) ? "b" : this.bPrefix, (CharSequence)"/", new CharSequence[0]);
        for (String file : added) {
            try {
                String bName = bPrefix + StringUtils.removeStart(file, "/");
                aLines = Collections.emptyList();
                bLines = bFunc.apply(file);
                patchLines = this.doDiff(summary, null, bName, aLines, bLines, context, autoHeader);
                if (!patchLines.isEmpty()) {
                    ++summary.addedFiles;
                    patches.consume(file + ".patch", patchLines);
                    continue;
                }
                ++summary.unchangedFiles;
            }
            catch (IOException e2) {
                this.log(LogLevel.ERROR, "Failed to read file: %s", file);
            }
        }
        for (String file : common) {
            try {
                aName = aPrefix + StringUtils.removeStart(file, "/");
                String bName = bPrefix + StringUtils.removeStart(file, "/");
                List<String> aLines2 = aFunc.apply(file);
                List<String> bLines2 = bFunc.apply(file);
                List<String> patchLines2 = this.doDiff(summary, aName, bName, aLines2, bLines2, context, autoHeader);
                if (!patchLines2.isEmpty()) {
                    ++summary.changedFiles;
                    patches.consume(file + ".patch", patchLines2);
                    continue;
                }
                ++summary.unchangedFiles;
            }
            catch (IOException e3) {
                this.log(LogLevel.ERROR, "Failed to read file: %s", file);
            }
        }
        for (String file : removed) {
            try {
                aName = aPrefix + StringUtils.removeStart(file, "/");
                aLines = aFunc.apply(file);
                bLines = Collections.emptyList();
                patchLines = this.doDiff(summary, aName, null, aLines, bLines, context, autoHeader);
                if (!patchLines.isEmpty()) {
                    ++summary.removedFiles;
                    patches.consume(file + ".patch", patchLines);
                    continue;
                }
                ++summary.unchangedFiles;
            }
            catch (IOException e4) {
                this.log(LogLevel.ERROR, "Failed to read file: %s", file);
            }
        }
    }

    public List<String> doDiff(DiffSummary summary, String aName, String bName, List<String> aLines, List<String> bLines, int context, boolean autoHeader) {
        PatienceDiffer differ = new PatienceDiffer();
        PatchFile patchFile = new PatchFile();
        patchFile.basePath = aName != null ? aName : "/dev/null";
        String string = patchFile.patchedPath = bName != null ? bName : "/dev/null";
        patchFile.patches = aLines.isEmpty() ? Differ.makeFileAdded(bLines) : (bLines.isEmpty() ? Differ.makeFileRemoved(aLines) : differ.makePatches(aLines, bLines, context, true));
        if (patchFile.patches.isEmpty()) {
            this.log(LogLevel.DEBUG, "%s -> %s\n No changes.", aName, bName);
            return Collections.emptyList();
        }
        long added = FastStream.of(patchFile.patches).flatMap(e -> e.diffs).filter(e -> e.op == Operation.INSERT).count();
        long removed = FastStream.of(patchFile.patches).flatMap(e -> e.diffs).filter(e -> e.op == Operation.DELETE).count();
        if (this.summary) {
            summary.addedLines += added;
            summary.removedLines += removed;
        }
        this.log(this.summary ? LogLevel.INFO : LogLevel.DEBUG, "%s -> %s\n %d Added.\n %d Removed.", aName, bName, added, removed);
        return patchFile.toLines(autoHeader);
    }

    private static Set<String> filterPrefixed(Set<String> toFilter, String[] filters) {
        if (filters.length == 0) {
            return toFilter;
        }
        return FastStream.of(toFilter).filterNot(e -> {
            for (String s : filters) {
                if (!e.startsWith(s)) continue;
                return true;
            }
            return false;
        }).toSet();
    }

    public static class Builder {
        private static final PrintStream NULL_STREAM = new PrintStream(NullOutputStream.INSTANCE);
        private PrintStream logger = NULL_STREAM;
        private Consumer<PrintStream> helpCallback = SneakyUtils.nullCons();
        private LogLevel level = LogLevel.WARN;
        private boolean summary;
        private InputPath aPath;
        private InputPath bPath;
        private boolean autoHeader;
        private int context = 3;
        private OutputPath outputPath;
        private String aPrefix = "a/";
        private String bPrefix = "b/";
        private String lineEnding = System.lineSeparator();
        private final List<String> ignorePrefixes = new LinkedList<String>();

        private Builder() {
        }

        public Builder logTo(PrintStream logger) {
            this.logger = Objects.requireNonNull(logger);
            return this;
        }

        public Builder logTo(OutputStream logger) {
            return this.logTo(new PrintStream(logger));
        }

        public Builder helpCallback(Consumer<PrintStream> helpCallback) {
            this.helpCallback = Objects.requireNonNull(helpCallback);
            return this;
        }

        public Builder level(LogLevel level) {
            this.level = level;
            return this;
        }

        public Builder summary(boolean summary) {
            this.summary = summary;
            return this;
        }

        public Builder aPath(InputPath aPath) {
            if (this.aPath != null) {
                throw new IllegalStateException("Unable to replace aPath.");
            }
            this.aPath = Objects.requireNonNull(aPath);
            return this;
        }

        public Builder aPath(Path aPath) {
            return this.aPath(aPath, ArchiveFormat.findFormat(aPath.getFileName()));
        }

        public Builder aPath(Path aPath, ArchiveFormat format) {
            return this.aPath(new InputPath.FilePath(Objects.requireNonNull(aPath), format, new OpenOption[0]));
        }

        public Builder aPath(byte[] aPath, ArchiveFormat format) {
            ByteArrayInputStream is = new ByteArrayInputStream(Objects.requireNonNull(aPath));
            return this.aPath(new InputPath.PipePath(is, Objects.requireNonNull(format)));
        }

        public Builder bPath(InputPath bPath) {
            if (this.bPath != null) {
                throw new IllegalStateException("Unable to replace bPath.");
            }
            this.bPath = Objects.requireNonNull(bPath);
            return this;
        }

        public Builder aPrefix(String aPrefix) {
            this.aPrefix = aPrefix;
            return this;
        }

        public Builder bPath(Path bPath) {
            return this.bPath(bPath, ArchiveFormat.findFormat(bPath.getFileName()));
        }

        public Builder bPath(Path bPath, ArchiveFormat format) {
            return this.bPath(new InputPath.FilePath(Objects.requireNonNull(bPath), format, new OpenOption[0]));
        }

        public Builder bPath(byte[] bPath, ArchiveFormat format) {
            ByteArrayInputStream is = new ByteArrayInputStream(Objects.requireNonNull(bPath));
            return this.bPath(new InputPath.PipePath(is, Objects.requireNonNull(format)));
        }

        public Builder bPrefix(String bPrefix) {
            this.bPrefix = bPrefix;
            return this;
        }

        public Builder autoHeader(boolean autoHeader) {
            this.autoHeader = autoHeader;
            return this;
        }

        public Builder context(int context) {
            this.context = context;
            return this;
        }

        public Builder outputPath(OutputPath outputPath) {
            this.outputPath = Objects.requireNonNull(outputPath);
            return this;
        }

        public Builder outputPath(Path output) {
            return this.outputPath(output, ArchiveFormat.findFormat(output.getFileName()));
        }

        public Builder outputPath(Path output, ArchiveFormat format) {
            return this.outputPath(new OutputPath.FilePath(Objects.requireNonNull(output), format, new OpenOption[0]));
        }

        public Builder outputPath(OutputStream output, ArchiveFormat format) {
            return this.outputPath(new OutputPath.PipePath(Objects.requireNonNull(output), Objects.requireNonNull(format)));
        }

        public Builder lineEnding(String lineEnding) {
            this.lineEnding = lineEnding;
            return this;
        }

        public Builder ignorePrefix(String prefix) {
            this.ignorePrefixes.add(prefix);
            return this;
        }

        public DiffOperation build() {
            if (this.aPath == null) {
                throw new IllegalStateException("aPath not set.");
            }
            if (this.bPath == null) {
                throw new IllegalStateException("bPath not set.");
            }
            if (this.outputPath == null) {
                throw new IllegalStateException("output not set.");
            }
            return new DiffOperation(this.logger, this.level, this.helpCallback, this.summary, this.aPath, this.bPath, this.aPrefix, this.bPrefix, this.autoHeader, this.context, this.outputPath, this.lineEnding, this.ignorePrefixes.toArray(new String[0]));
        }
    }

    private static interface LinesReader {
        public List<String> apply(String var1) throws IOException;
    }

    public static class DiffSummary {
        public int unchangedFiles;
        public int addedFiles;
        public int changedFiles;
        public int removedFiles;
        public long addedLines;
        public long removedLines;

        public void print(PrintStream logger, boolean slim) {
            logger.println("Diff Summary:");
            if (!slim) {
                logger.println(" UnChanged files: " + this.unchangedFiles);
                logger.println(" Added files:     " + this.addedFiles);
                logger.println(" Changed files:   " + this.changedFiles);
                logger.println(" Removed files:   " + this.removedFiles);
            }
            logger.println(" Added lines:     " + this.addedLines);
            logger.println(" Removed lines:   " + this.removedLines);
        }
    }
}

