/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.util;

import codechicken.repack.net.covers1624.quack.util.SneakyUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Utils {
    public static String stripStart(char start, String str) {
        if (!str.isEmpty() && str.charAt(0) == start) {
            return str.substring(1);
        }
        return str;
    }

    public static void deleteFolder(Path folder) throws IOException {
        try (Stream<Path> stream = Files.walk(folder, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(SneakyUtils.sneak(Files::delete));
        }
    }

    public static Map<String, Path> indexChildren(Path toIndex) throws IOException {
        return Utils.indexChildren(toIndex, "");
    }

    public static Map<String, Path> indexChildren(Path toIndex, String prefix) throws IOException {
        if (!prefix.isEmpty()) {
            toIndex = toIndex.resolve(prefix);
        }
        try (Stream<Path> stream = Files.walk(toIndex, new FileVisitOption[0]);){
            Path finalToIndex = toIndex;
            Map<String, Path> map = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(e -> Utils.stripStart('/', finalToIndex.relativize((Path)e).toString().replace("\\", "/")), Function.identity()));
            return map;
        }
    }
}

