/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileCollector {
    private final Map<String, List<String>> files = new LinkedHashMap<String, List<String>>();

    public boolean consume(String name, List<String> lines) {
        return this.files.put(name, Collections.unmodifiableList(lines)) == null;
    }

    public Map<String, List<String>> get() {
        return Collections.unmodifiableMap(this.files);
    }

    public Set<String> keySet() {
        return this.get().keySet();
    }

    public Collection<List<String>> values() {
        return this.get().values();
    }

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    public List<String> getSingleFile() {
        if (this.files.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.files.size() != 1) {
            throw new IllegalStateException("Expected 1 file in FileCollector, got: " + this.files.size());
        }
        return this.files.entrySet().iterator().next().getValue();
    }
}

