/*
 * Decompiled with CFR 0.152.
 */
package codechicken.repack.org.tukaani.xz.rangecoder;

import codechicken.repack.org.tukaani.xz.ArrayCache;
import codechicken.repack.org.tukaani.xz.CorruptedInputException;
import codechicken.repack.org.tukaani.xz.rangecoder.RangeDecoder;
import java.io.DataInputStream;
import java.io.IOException;

public final class RangeDecoderFromBuffer
extends RangeDecoder {
    private static final int INIT_SIZE = 5;
    private final byte[] buf;
    private int pos;

    public RangeDecoderFromBuffer(int n, ArrayCache arrayCache) {
        this.buf = arrayCache.getByteArray(n - 5, false);
        this.pos = this.buf.length;
    }

    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.buf);
    }

    public void prepareInputBuffer(DataInputStream dataInputStream, int n) throws IOException {
        if (n < 5) {
            throw new CorruptedInputException();
        }
        if (dataInputStream.readUnsignedByte() != 0) {
            throw new CorruptedInputException();
        }
        this.code = dataInputStream.readInt();
        this.range = -1;
        this.pos = this.buf.length - (n -= 5);
        dataInputStream.readFully(this.buf, this.pos, n);
    }

    public boolean isFinished() {
        return this.pos == this.buf.length && this.code == 0;
    }

    public void normalize() throws IOException {
        if ((this.range & 0xFF000000) == 0) {
            try {
                this.code = this.code << 8 | this.buf[this.pos++] & 0xFF;
                this.range <<= 8;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new CorruptedInputException();
            }
        }
    }
}

