/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Utils {
    private static final ThreadLocal<byte[]> bufferCache = ThreadLocal.withInitial(() -> new byte[32768]);

    public static void copy(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buffer = bufferCache.get();
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
    }

    public static byte[] toBytes(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Utils.copy(is, os);
        return os.toByteArray();
    }

    public static List<String> readAll(byte[] bytes) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    public static String stripStart(char start, String str) {
        if (!str.isEmpty() && str.charAt(0) == start) {
            return str.substring(1);
        }
        return str;
    }

    public static String stripStart(String start, String str) {
        if (str.startsWith(start)) {
            return str.substring(str.length());
        }
        return str;
    }

    public static String ensureStartsWith(char start, String str) {
        if (str.isEmpty() || str.charAt(0) != start) {
            return start + str;
        }
        return str;
    }

    public static String ensureStartsWith(String start, String str) {
        if (!str.startsWith(start)) {
            return start + str;
        }
        return str;
    }

    public static InputStream protectClose(InputStream is) {
        return new FilterInputStream(is){

            @Override
            public void close() {
            }
        };
    }

    public static OutputStream protectClose(OutputStream os) {
        return new FilterOutputStream(os){

            @Override
            public void close() {
            }
        };
    }

    public static void deleteFolder(File directory) {
        ArrayDeque<File> toDelete = new ArrayDeque<File>();
        toDelete.push(directory);
        while (!toDelete.isEmpty()) {
            File peek = (File)toDelete.peek();
            if (peek.isDirectory()) {
                File[] list = peek.listFiles();
                if (list == null || list.length == 0) {
                    ((File)toDelete.pop()).delete();
                    continue;
                }
                if (list == null) continue;
                for (File f : list) {
                    toDelete.push(f);
                }
                continue;
            }
            ((File)toDelete.pop()).delete();
        }
    }

    public static void deleteFolder(Path folder) throws IOException {
        try (Stream<Path> stream = Files.walk(folder, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(Utils.sneakC(Files::delete));
        }
    }

    public static Path makeParentDirs(Path path) {
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            Utils.sneaky(() -> Files.createDirectories(path.getParent(), new FileAttribute[0]));
        }
        return path;
    }

    public static Runnable sneakR(ThrowingRunnable<Throwable> tr) {
        return () -> Utils.sneaky(tr);
    }

    public static <T, R> Function<T, R> sneakF(ThrowingFunction<T, R, Throwable> tf) {
        return e -> Utils.sneaky(() -> tf.apply(e));
    }

    public static <T> Consumer<T> sneakC(ThrowingConsumer<T, Throwable> tc) {
        return t -> {
            try {
                tc.accept(t);
            }
            catch (Throwable th) {
                Utils.throwUnchecked(th);
            }
        };
    }

    public static void sneaky(ThrowingRunnable<Throwable> tr) {
        try {
            tr.run();
        }
        catch (Throwable t) {
            Utils.throwUnchecked(t);
        }
    }

    public static <T> T sneaky(ThrowingProducer<T, Throwable> tp) {
        try {
            return tp.get();
        }
        catch (Throwable t) {
            Utils.throwUnchecked(t);
            return null;
        }
    }

    public static <T extends Throwable> void throwUnchecked(Throwable t) throws T {
        throw t;
    }

    public static Map<String, Path> indexChildren(Path toIndex) throws IOException {
        return Utils.indexChildren(toIndex, "");
    }

    public static Map<String, Path> indexChildren(Path toIndex, String prefix) throws IOException {
        if (!prefix.isEmpty()) {
            toIndex = toIndex.resolve(prefix);
        }
        try (Stream<Path> stream = Files.walk(toIndex, new FileVisitOption[0]);){
            Path finalToIndex = toIndex;
            Map<String, Path> map = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(e -> Utils.stripStart('/', finalToIndex.relativize((Path)e).toString().replace("\\", "/")), Function.identity()));
            return map;
        }
    }

    public static interface ThrowingRunnable<E extends Throwable> {
        public void run() throws E;
    }

    public static interface ThrowingProducer<T, E extends Throwable> {
        public T get() throws E;
    }

    public static interface ThrowingFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;
    }

    public static interface ThrowingConsumer<T, E extends Throwable> {
        public void accept(T var1) throws E;
    }
}

