/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.cli;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.patch.Patcher;
import codechicken.diffpatch.util.Diff;
import codechicken.diffpatch.util.FileCollector;
import codechicken.diffpatch.util.InputPath;
import codechicken.diffpatch.util.NullOutputStream;
import codechicken.diffpatch.util.OutputPath;
import codechicken.diffpatch.util.PatchFile;
import codechicken.diffpatch.util.PatchMode;
import codechicken.diffpatch.util.Utils;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import codechicken.diffpatch.util.archiver.ArchiveReader;
import codechicken.diffpatch.util.archiver.ArchiveWriter;
import codechicken.repack.org.apache.commons.lang3.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PatchOperation
extends CliOperation<PatchesSummary> {
    private final boolean summary;
    private final InputPath basePath;
    private final InputPath patchesPath;
    private final String aPrefix;
    private final String bPrefix;
    private final OutputPath outputPath;
    private final OutputPath rejectsPath;
    private final float minFuzz;
    private final int maxOffset;
    private final PatchMode mode;
    private final String patchesPrefix;

    public PatchOperation(PrintStream logger, Consumer<PrintStream> helpCallback, boolean verbose, boolean summary, InputPath basePath, InputPath patchesPath, String aPrefix, String bPrefix, OutputPath outputPath, OutputPath rejectsPath, float minFuzz, int maxOffset, PatchMode mode, String patchesPrefix) {
        super(logger, helpCallback, verbose);
        this.summary = summary;
        this.basePath = basePath;
        this.patchesPath = patchesPath;
        this.aPrefix = aPrefix;
        this.bPrefix = bPrefix;
        this.outputPath = outputPath;
        this.rejectsPath = rejectsPath;
        this.minFuzz = minFuzz;
        this.maxOffset = maxOffset;
        this.mode = mode;
        this.patchesPrefix = patchesPrefix;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CliOperation.Result<PatchesSummary> operate() throws IOException {
        String file;
        Object writer;
        Object baseFunc;
        boolean patchSuccess;
        PatchesSummary summary;
        FileCollector rejectCollector;
        FileCollector outputCollector;
        block134: {
            Set<String> baseIndex;
            if (!this.basePath.exists()) {
                this.log("Err: Base file doesn't exist.", new Object[0]);
                return new CliOperation.Result<PatchesSummary>(-1);
            }
            if (!this.patchesPath.exists()) {
                this.log("Err: Patch file doesn't exist.", new Object[0]);
                return new CliOperation.Result<PatchesSummary>(-1);
            }
            outputCollector = new FileCollector();
            rejectCollector = new FileCollector();
            summary = new PatchesSummary();
            if (this.basePath.isFile() && this.patchesPath.isFile() && this.basePath.getFormat() == null && this.patchesPath.getFormat() == null) {
                Path out;
                if (this.outputPath.getFormat() != null) {
                    this.log("Err: Can't specify output format when patching regular file.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<PatchesSummary>(-1);
                }
                if (this.outputPath.getType().isPath() && Files.exists(out = this.outputPath.toPath(), new LinkOption[0]) && !Files.isRegularFile(out, new LinkOption[0])) {
                    this.log("Err: Output already exists and is not a file.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<PatchesSummary>(-1);
                }
                if (this.rejectsPath.exists()) {
                    if (this.rejectsPath.getFormat() != null) {
                        this.log("Err: Can't specify reject format when patching regular file.", new Object[0]);
                        this.printHelp();
                        return new CliOperation.Result<PatchesSummary>(-1);
                    }
                    if (this.rejectsPath.getType().isPath() && Files.exists(out = this.rejectsPath.toPath(), new LinkOption[0]) && !Files.isRegularFile(out, new LinkOption[0])) {
                        this.log("Err: Reject already exists and is not a file.", new Object[0]);
                        this.printHelp();
                        return new CliOperation.Result<PatchesSummary>(-1);
                    }
                }
                PatchFile patchFile = PatchFile.fromLines(this.patchesPath.toString(), this.patchesPath.readAllLines(), true);
                boolean success = this.doPatch(outputCollector, rejectCollector, summary, this.basePath.toString(), this.basePath.readAllLines(), patchFile, this.minFuzz, this.maxOffset, this.mode);
                List<String> output = outputCollector.getSingleFile();
                List<String> list = rejectCollector.getSingleFile();
                try (PrintWriter out2 = new PrintWriter(this.outputPath.open());){
                    out2.println(String.join((CharSequence)"\n", output) + "\n");
                }
                if (this.rejectsPath.exists() && !list.isEmpty()) {
                    var10_31 = null;
                    try (PrintWriter out2 = new PrintWriter(this.rejectsPath.open());){
                        out2.println(String.join((CharSequence)"\n", list + "\n"));
                    }
                    catch (Throwable throwable) {
                        var10_31 = throwable;
                        throw throwable;
                    }
                }
                if (this.summary) {
                    summary.print(this.logger, true);
                }
                return new CliOperation.Result<PatchesSummary>(success ? 0 : 1, summary);
            }
            if (this.outputPath.getType().isPipe() && this.outputPath.getFormat() == null) {
                this.log("Err: Output detected as pipe but no format is specified.", new Object[0]);
                this.printHelp();
                return new CliOperation.Result<PatchesSummary>(-1);
            }
            if (this.outputPath.isFile()) {
                Path out = this.outputPath.toPath();
                if (this.outputPath.getFormat() != null) {
                    if (Files.exists(out, new LinkOption[0]) && !Files.isRegularFile(out, new LinkOption[0])) {
                        this.log("Err: Output already exists and is not a file.", new Object[0]);
                        this.printHelp();
                        return new CliOperation.Result<PatchesSummary>(-1);
                    }
                } else if (Files.exists(out, new LinkOption[0]) && !Files.isDirectory(out, new LinkOption[0])) {
                    this.log("Err: Output already exists and is not a directory.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<PatchesSummary>(-1);
                }
            }
            if (this.basePath.isFile() && this.patchesPath.isFile()) {
                if (this.basePath.getFormat() == null) {
                    this.log("Err: Base path is in an unknown archive format", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<PatchesSummary>(-1);
                }
                if (this.patchesPath.getFormat() == null) {
                    this.log("Err: Patches path is in an unknown archive format", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<PatchesSummary>(-1);
                }
                try (ArchiveReader baseReader = this.basePath.getFormat().createReader(this.basePath.open());){
                    Throwable throwable = null;
                    try (ArchiveReader patchesReader = this.patchesPath.getFormat().createReader(this.patchesPath.open(), this.patchesPrefix);){
                        patchSuccess = this.doPatch(outputCollector, rejectCollector, summary, baseReader.getEntries(), patchesReader.getEntries(), Utils.sneakF(baseReader::readLines), Utils.sneakF(patchesReader::readLines), this.minFuzz, this.maxOffset, this.mode);
                        break block134;
                    }
                    catch (Throwable out2) {
                        Throwable throwable2 = out2;
                        throw out2;
                    }
                }
            }
            if (!this.basePath.isFile() && !this.patchesPath.isFile()) {
                baseIndex = Utils.indexChildren(this.basePath.toPath());
                Map<String, Path> patchIndex = Utils.indexChildren(this.patchesPath.toPath(), this.patchesPrefix);
                patchSuccess = this.doPatch(outputCollector, rejectCollector, summary, baseIndex.keySet(), patchIndex.keySet(), Utils.sneakF(arg_0 -> PatchOperation.lambda$operate$0((Map)((Object)baseIndex), arg_0)), Utils.sneakF(e -> Files.readAllLines((Path)patchIndex.get(e))), this.minFuzz, this.maxOffset, this.mode);
            } else {
                void var8_21;
                Object patchIndex;
                Throwable throwable;
                ArchiveReader reader;
                Map<String, Path> pathIndex;
                if (!this.basePath.isFile()) {
                    if (this.patchesPath.getFormat() == null) {
                        this.log("Err: Patches file is in an unknown format, whilst Base file is a directory.", new Object[0]);
                        this.printHelp();
                        return new CliOperation.Result<PatchesSummary>(-1);
                    }
                    pathIndex = Utils.indexChildren(this.basePath.toPath());
                    baseIndex = pathIndex.keySet();
                    baseFunc = Utils.sneakF(e -> Files.readAllLines((Path)pathIndex.get(e)));
                    reader = this.patchesPath.getFormat().createReader(this.patchesPath.open(), this.patchesPrefix);
                    throwable = null;
                    try {
                        patchIndex = reader.getEntries();
                        Function<String, List> function = Utils.sneakF(reader::readLines);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                if (this.basePath.getFormat() == null) {
                    this.log("Err: Base file is in an unknown format, whilst Patches file is a directory.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<PatchesSummary>(-1);
                }
                pathIndex = Utils.indexChildren(this.patchesPath.toPath(), this.patchesPrefix);
                patchIndex = pathIndex.keySet();
                Function<String, List> function = Utils.sneakF(e -> Files.readAllLines((Path)pathIndex.get(e)));
                reader = this.basePath.getFormat().createReader(this.basePath.open());
                throwable = null;
                try {
                    baseIndex = reader.getEntries();
                    baseFunc = Utils.sneakF(reader::readLines);
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
                patchSuccess = this.doPatch(outputCollector, rejectCollector, summary, baseIndex, (Set<String>)patchIndex, (Function<String, List<String>>)baseFunc, (Function<String, List<String>>)var8_21, this.minFuzz, this.maxOffset, this.mode);
            }
        }
        if (this.outputPath.getFormat() != null) {
            writer = this.outputPath.getFormat().createWriter(this.outputPath.open());
            baseFunc = null;
            try {
                for (Map.Entry entry : outputCollector.get().entrySet()) {
                    file = String.join((CharSequence)"\n", (Iterable)entry.getValue()) + "\n";
                    writer.writeEntry((String)entry.getKey(), file.getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (Throwable patchIndex) {
                baseFunc = patchIndex;
                throw patchIndex;
            }
            finally {
                if (writer != null) {
                    if (baseFunc != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable patchIndex) {
                            ((Throwable)baseFunc).addSuppressed(patchIndex);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        } else {
            if (Files.exists(this.outputPath.toPath(), new LinkOption[0])) {
                Utils.deleteFolder(this.outputPath.toPath());
            }
            for (Map.Entry<String, List<String>> entry : outputCollector.get().entrySet()) {
                Path path2 = this.outputPath.toPath().resolve((String)entry.getKey());
                Files.write(Utils.makeParentDirs(path2), (Iterable<? extends CharSequence>)((Iterable)entry.getValue()), new OpenOption[0]);
            }
        }
        if (this.rejectsPath.exists()) {
            if (this.rejectsPath.getFormat() != null) {
                Map.Entry<String, List<String>> entry;
                writer = this.rejectsPath.getFormat().createWriter(this.rejectsPath.open());
                entry = null;
                try {
                    for (Map.Entry entry2 : rejectCollector.get().entrySet()) {
                        file = String.join((CharSequence)"\n", (Iterable)entry2.getValue()) + "\n";
                        writer.writeEntry((String)entry2.getKey(), file.getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (Throwable path2) {
                    entry = path2;
                    throw path2;
                }
                finally {
                    if (writer != null) {
                        if (entry != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable path2) {
                                ((Throwable)((Object)entry)).addSuppressed(path2);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            } else {
                if (Files.exists(this.rejectsPath.toPath(), new LinkOption[0])) {
                    Utils.deleteFolder(this.rejectsPath.toPath());
                }
                for (Map.Entry<String, List<String>> entry : rejectCollector.get().entrySet()) {
                    Path path = this.rejectsPath.toPath().resolve(entry.getKey());
                    Files.write(Utils.makeParentDirs(path), (Iterable<? extends CharSequence>)entry.getValue(), new OpenOption[0]);
                }
            }
        }
        if (this.summary) {
            summary.print(this.logger, false);
        }
        return new CliOperation.Result<PatchesSummary>(patchSuccess ? 0 : 1, summary);
    }

    public boolean doPatch(FileCollector oCollector, FileCollector rCollector, PatchesSummary summary, Set<String> bEntries, Set<String> pEntries, Function<String, List<String>> bFunc, Function<String, List<String>> pFunc, float minFuzz, int maxOffset, PatchMode mode) {
        PatchFile patchFile;
        Map patchFiles = pEntries.stream().map(e -> PatchFile.fromLines(e, (List)pFunc.apply((String)e), true)).collect(Collectors.toMap(e -> {
            if (e.patchedPath == null) {
                return e.name.substring(0, e.name.lastIndexOf(".patch"));
            }
            if (e.patchedPath.startsWith("b/")) {
                return e.patchedPath.substring(2);
            }
            if (e.patchedPath.startsWith(this.bPrefix)) {
                return StringUtils.removeStart(e.patchedPath.substring(this.bPrefix.length()), "/");
            }
            return e.patchedPath;
        }, Function.identity()));
        List notPatched = bEntries.stream().filter(e -> !patchFiles.containsKey(e)).sorted().collect(Collectors.toList());
        List patchedFiles = bEntries.stream().filter(patchFiles::containsKey).sorted().collect(Collectors.toList());
        List removedFiles = patchFiles.keySet().stream().filter(e -> !bEntries.contains(e)).sorted().collect(Collectors.toList());
        boolean result = true;
        for (String file : notPatched) {
            ++summary.unchangedFiles;
            oCollector.consume(file, bFunc.apply(file));
        }
        for (String file : patchedFiles) {
            ++summary.changedFiles;
            patchFile = (PatchFile)patchFiles.get(file);
            List<String> baseLines = bFunc.apply(file);
            result &= this.doPatch(oCollector, rCollector, summary, file, baseLines, patchFile, minFuzz, maxOffset, mode);
        }
        for (String file : removedFiles) {
            ++summary.missingFiles;
            patchFile = (PatchFile)patchFiles.get(file);
            ArrayList<String> lines = new ArrayList<String>(patchFile.toLines(false));
            lines.add(0, "++++ Target missing");
            this.verbose("Missing patch target for %s", patchFile.name);
            rCollector.consume(patchFile.name, lines);
            result = false;
        }
        return result;
    }

    public boolean doPatch(FileCollector outputCollector, FileCollector rejectCollector, PatchesSummary summary, String baseName, List<String> base, PatchFile patchFile, float minFuzz, int maxOffset, PatchMode mode) {
        Patcher patcher = new Patcher(patchFile, base, minFuzz, maxOffset);
        this.verbose("Patching: " + baseName, new Object[0]);
        List results = patcher.patch(mode).collect(Collectors.toList());
        ArrayList<String> rejectLines = new ArrayList<String>();
        boolean first = true;
        for (int i = 0; i < results.size(); ++i) {
            Patcher.Result result = (Patcher.Result)results.get(i);
            if (result.mode != null) {
                switch (result.mode) {
                    case EXACT: {
                        ++summary.exactMatches;
                        summary.overallQuality += 100.0;
                        break;
                    }
                    case ACCESS: {
                        ++summary.accessMatches;
                        summary.overallQuality += 100.0;
                        break;
                    }
                    case OFFSET: {
                        ++summary.offsetMatches;
                        summary.overallQuality += 100.0;
                        break;
                    }
                    case FUZZY: {
                        ++summary.fuzzyMatches;
                        summary.overallQuality += (double)(result.fuzzyQuality * 100.0f);
                    }
                }
            } else {
                ++summary.failedMatches;
            }
            if (this.verbose) {
                this.verbose(" Hunk %d: %s", i, result.summary());
            }
            if (result.success) continue;
            if (!first) {
                rejectLines.add("");
            }
            first = false;
            rejectLines.add("++++ REJECTED HUNK: " + (i + 1));
            rejectLines.add(result.patch.getHeader());
            result.patch.diffs.stream().map(Diff::toString).forEach(rejectLines::add);
            rejectLines.add("++++ END HUNK");
        }
        outputCollector.consume(baseName, patcher.lines);
        if (!rejectLines.isEmpty()) {
            rejectCollector.consume(patchFile.name + ".rej", rejectLines);
            return false;
        }
        return true;
    }

    public static void bakePatches(InputPath input, OutputPath output) throws IOException {
        PatchOperation.bakePatches(input, "", output);
    }

    public static void bakePatches(InputPath input, String prefix, OutputPath output) throws IOException {
        if (!input.exists()) {
            throw new IllegalArgumentException("Expected input to exist.");
        }
        if (output.getType().isNull()) {
            throw new IllegalArgumentException("Expected non-null output.");
        }
        HashMap<String, List<String>> patchLines = new HashMap<String, List<String>>();
        if (input.isFile()) {
            if (input.getFormat() == null) {
                throw new IllegalArgumentException("Input is single file or unknown ArchiveFormat.");
            }
            ArchiveReader reader = input.getFormat().createReader(input.open(), prefix);
            Iterator iterator = null;
            try {
                for (String entry : reader.getEntries()) {
                    patchLines.put(entry, reader.readLines(entry));
                }
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (iterator != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        } else {
            Map<String, Path> index = Utils.indexChildren(input.toPath(), prefix);
            for (Map.Entry<String, Path> entry : index.entrySet()) {
                patchLines.put(entry.getKey(), Files.readAllLines(entry.getValue()));
            }
        }
        HashMap bakedPatches = new HashMap();
        for (Map.Entry entry : patchLines.entrySet()) {
            PatchFile patchFile = PatchFile.fromLines((String)entry.getKey(), (List)entry.getValue(), true);
            List<String> list = patchFile.toLines(false);
            String joined = String.join((CharSequence)("\n" + list), new CharSequence[0]) + "\n";
            bakedPatches.put(entry.getKey(), joined.getBytes(StandardCharsets.UTF_8));
        }
        if (output.isFile()) {
            if (output.getFormat() == null) {
                throw new IllegalArgumentException("Output is single file or unknown ArchiveFormat.");
            }
            Throwable throwable = null;
            try (ArchiveWriter writer = output.getFormat().createWriter(output.open());){
                for (Map.Entry entry : bakedPatches.entrySet()) {
                    String path = !StringUtils.isEmpty(prefix) ? StringUtils.appendIfMissing(prefix, (CharSequence)"/", new CharSequence[0]) + StringUtils.removeStart((String)entry.getKey(), "/") : (String)entry.getKey();
                    writer.writeEntry(path, (byte[])entry.getValue());
                }
            }
            catch (Throwable patchFile) {
                Throwable throwable2 = patchFile;
                throw patchFile;
            }
        } else {
            Utils.deleteFolder(output.toPath());
            for (Map.Entry entry : bakedPatches.entrySet()) {
                Path path = !StringUtils.isEmpty(prefix) ? output.toPath().resolve(StringUtils.appendIfMissing(prefix, (CharSequence)"/", new CharSequence[0]) + StringUtils.removeStart((String)entry.getKey(), "/")) : output.toPath().resolve((String)entry.getKey());
                Files.write(Utils.makeParentDirs(path), (byte[])entry.getValue(), new OpenOption[0]);
            }
        }
    }

    public static String bakePatch(PatchFile patchFile) {
        List<String> lines = patchFile.toLines(false);
        return String.join((CharSequence)("\n" + lines), new CharSequence[0]) + "\n";
    }

    private static /* synthetic */ List lambda$operate$0(Map baseIndex, String e) throws Throwable {
        return Files.readAllLines((Path)baseIndex.get(e));
    }

    public static class Builder {
        private static final Consumer<PrintStream> NULL_CALLBACK = e -> {};
        private static final PrintStream NULL_STREAM = new PrintStream(NullOutputStream.INSTANCE);
        private PrintStream logger = NULL_STREAM;
        private Consumer<PrintStream> helpCallback = NULL_CALLBACK;
        private boolean verbose;
        private boolean summary;
        private InputPath basePath;
        private InputPath patchesPath;
        private OutputPath outputPath;
        private OutputPath rejectsPath = OutputPath.NullPath.INSTANCE;
        private float minFuzz = 0.5f;
        private int maxOffset = 5;
        private PatchMode mode = PatchMode.EXACT;
        private String patchesPrefix = "";
        private String aPrefix = "a/";
        private String bPrefix = "b/";

        private Builder() {
        }

        public Builder logTo(PrintStream logger) {
            this.logger = Objects.requireNonNull(logger);
            return this;
        }

        public Builder logTo(OutputStream logger) {
            return this.logTo(new PrintStream(logger));
        }

        public Builder helpCallback(Consumer<PrintStream> helpCallback) {
            this.helpCallback = Objects.requireNonNull(helpCallback);
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder summary(boolean summary) {
            this.summary = summary;
            return this;
        }

        public Builder basePath(InputPath basePath) {
            this.basePath = Objects.requireNonNull(basePath);
            return this;
        }

        public Builder basePath(Path basePath) {
            return this.basePath(basePath, ArchiveFormat.findFormat(basePath.getFileName()));
        }

        public Builder basePath(Path basePath, ArchiveFormat format) {
            return this.basePath(new InputPath.FilePath(Objects.requireNonNull(basePath), format, new OpenOption[0]));
        }

        public Builder basePath(byte[] basePath, ArchiveFormat format) {
            ByteArrayInputStream is = new ByteArrayInputStream(Objects.requireNonNull(basePath));
            return this.basePath(new InputPath.PipePath(is, Objects.requireNonNull(format)));
        }

        public Builder patchesPath(InputPath patchesPath) {
            this.patchesPath = Objects.requireNonNull(patchesPath);
            return this;
        }

        public Builder patchesPath(Path patchesPath) {
            return this.patchesPath(patchesPath, ArchiveFormat.findFormat(patchesPath.getFileName()));
        }

        public Builder patchesPath(Path patchesPath, ArchiveFormat format) {
            return this.patchesPath(new InputPath.FilePath(Objects.requireNonNull(patchesPath), format, new OpenOption[0]));
        }

        public Builder patchesPath(byte[] patchesPath, ArchiveFormat format) {
            ByteArrayInputStream is = new ByteArrayInputStream(Objects.requireNonNull(patchesPath));
            return this.patchesPath(new InputPath.PipePath(is, Objects.requireNonNull(format)));
        }

        public Builder aPrefix(String aPrefix) {
            this.aPrefix = aPrefix;
            return this;
        }

        public Builder bPrefix(String bPrefix) {
            this.bPrefix = bPrefix;
            return this;
        }

        public Builder outputPath(OutputPath outputPath) {
            this.outputPath = Objects.requireNonNull(outputPath);
            return this;
        }

        public Builder outputPath(Path output) {
            return this.outputPath(output, ArchiveFormat.findFormat(output.getFileName()));
        }

        public Builder outputPath(Path output, ArchiveFormat format) {
            return this.outputPath(new OutputPath.FilePath(Objects.requireNonNull(output), format, new OpenOption[0]));
        }

        public Builder outputPath(OutputStream output, ArchiveFormat format) {
            return this.outputPath(new OutputPath.PipePath(Objects.requireNonNull(output), Objects.requireNonNull(format)));
        }

        public Builder rejectsPath(OutputPath rejectsPath) {
            this.rejectsPath = Objects.requireNonNull(rejectsPath);
            return this;
        }

        public Builder rejectsPath(Path rejects) {
            return this.rejectsPath(rejects, ArchiveFormat.findFormat(rejects.getFileName()));
        }

        public Builder rejectsPath(Path rejects, ArchiveFormat format) {
            return this.rejectsPath(new OutputPath.FilePath(Objects.requireNonNull(rejects), format, new OpenOption[0]));
        }

        public Builder rejectsPath(OutputStream rejects, ArchiveFormat format) {
            return this.rejectsPath(new OutputPath.PipePath(Objects.requireNonNull(rejects), Objects.requireNonNull(format)));
        }

        public Builder minFuzz(float minFuzz) {
            this.minFuzz = minFuzz;
            return this;
        }

        public Builder maxOffset(int maxOffset) {
            this.maxOffset = maxOffset;
            return this;
        }

        public Builder mode(PatchMode mode) {
            this.mode = Objects.requireNonNull(mode);
            return this;
        }

        public Builder patchesPrefix(String patchesPrefix) {
            this.patchesPrefix = Objects.requireNonNull(patchesPrefix);
            return this;
        }

        public PatchOperation build() {
            if (this.basePath == null) {
                throw new IllegalStateException("basePath not set.");
            }
            if (this.patchesPath == null) {
                throw new IllegalStateException("patchesPath not set.");
            }
            if (this.outputPath == null) {
                throw new IllegalStateException("output not set.");
            }
            return new PatchOperation(this.logger, this.helpCallback, this.verbose, this.summary, this.basePath, this.patchesPath, this.aPrefix, this.bPrefix, this.outputPath, this.rejectsPath, this.minFuzz, this.maxOffset, this.mode, this.patchesPrefix);
        }
    }

    public static class PatchesSummary {
        public int unchangedFiles;
        public int changedFiles;
        public int missingFiles;
        public int failedMatches;
        public int exactMatches;
        public int accessMatches;
        public int offsetMatches;
        public int fuzzyMatches;
        public double overallQuality;

        public void print(PrintStream logger, boolean slim) {
            logger.println("Patch Summary:");
            if (!slim) {
                logger.println(" Un-changed files: " + this.unchangedFiles);
                logger.println(" Changed files:    " + this.changedFiles);
                logger.println(" Missing files:    " + this.missingFiles);
            }
            logger.println();
            logger.println(" Failed matches:   " + this.failedMatches);
            logger.println(" Exact matches:    " + this.exactMatches);
            logger.println(" Access matches:   " + this.accessMatches);
            logger.println(" Offset matches:   " + this.offsetMatches);
            logger.println(" Fuzzy matches:    " + this.fuzzyMatches);
            logger.println(String.format("Overall Quality   %.2f%%", this.overallQuality / (double)(this.failedMatches + this.exactMatches + this.accessMatches + this.offsetMatches + this.fuzzyMatches)));
        }
    }
}

