/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.cli;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.diff.Differ;
import codechicken.diffpatch.diff.PatienceDiffer;
import codechicken.diffpatch.util.FileCollector;
import codechicken.diffpatch.util.InputPath;
import codechicken.diffpatch.util.NullOutputStream;
import codechicken.diffpatch.util.Operation;
import codechicken.diffpatch.util.OutputPath;
import codechicken.diffpatch.util.PatchFile;
import codechicken.diffpatch.util.Utils;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import codechicken.diffpatch.util.archiver.ArchiveReader;
import codechicken.diffpatch.util.archiver.ArchiveWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class DiffOperation
extends CliOperation<DiffSummary> {
    private final boolean summary;
    private final InputPath aPath;
    private final InputPath bPath;
    private final boolean autoHeader;
    private final int context;
    private final OutputPath outputPath;

    public DiffOperation(PrintStream logger, Consumer<PrintStream> helpCallback, boolean verbose, boolean summary, InputPath aPath, InputPath bPath, boolean autoHeader, int context, OutputPath outputPath) {
        super(logger, helpCallback, verbose);
        this.summary = summary;
        this.aPath = aPath;
        this.bPath = bPath;
        this.autoHeader = autoHeader;
        this.context = context;
        this.outputPath = outputPath;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CliOperation.Result<DiffSummary> operate() throws IOException {
        Object bIndex;
        DiffSummary summary;
        FileCollector patches;
        block115: {
            Set<String> aIndex;
            if (!this.aPath.exists()) {
                this.log("Err: File A doesn't exist.", new Object[0]);
                return new CliOperation.Result<DiffSummary>(-1);
            }
            if (this.bPath.exists()) {
                this.log("Err: File B doesn't exist.", new Object[0]);
                return new CliOperation.Result<DiffSummary>(-1);
            }
            patches = new FileCollector();
            summary = new DiffSummary();
            if (this.aPath.isFile() && this.bPath.isFile() && this.aPath.getFormat() == null && this.bPath.getFormat() == null) {
                if (this.outputPath.getFormat() != null) {
                    this.log("Err: Can't specify output format when diffing regular files.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
                if (this.outputPath.getType().isPath() && Files.exists(this.outputPath.toPath(), new LinkOption[0]) && !Files.isRegularFile(this.outputPath.toPath(), new LinkOption[0])) {
                    this.log("Err: Output already exists and is not a file.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
                List<String> lines = this.doDiff(summary, this.aPath.toPath().toString(), this.bPath.toPath().toString(), this.aPath.readAllLines(), this.bPath.readAllLines(), this.context, this.autoHeader);
                boolean changes = false;
                if (!lines.isEmpty()) {
                    changes = true;
                    try (PrintWriter out = new PrintWriter(this.outputPath.open());){
                        out.println(String.join((CharSequence)"\n", lines) + "\n");
                    }
                }
                if (this.summary) {
                    summary.print(this.logger, true);
                }
                return new CliOperation.Result<DiffSummary>(changes ? 1 : 0, summary);
            }
            if (this.outputPath.getType().isPath()) {
                if (this.outputPath.getFormat() != null) {
                    if (Files.exists(this.outputPath.toPath(), new LinkOption[0]) && !Files.isRegularFile(this.outputPath.toPath(), new LinkOption[0])) {
                        this.log("Err: Output already exists and is not a file.", new Object[0]);
                        this.printHelp();
                        return new CliOperation.Result<DiffSummary>(-1);
                    }
                } else if (Files.exists(this.outputPath.toPath(), new LinkOption[0]) && !Files.isDirectory(this.outputPath.toPath(), new LinkOption[0])) {
                    this.log("Err: Output already exists and is not a directory.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
            }
            if (this.aPath.isFile() && this.bPath.isFile()) {
                if (this.aPath.getFormat() == null) {
                    this.log("Err: File A is in an unknown archive format.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
                if (this.bPath.getFormat() == null) {
                    this.log("Err: File B is in an unknown archive format.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
                try (ArchiveReader aReader = this.aPath.getFormat().createReader(this.aPath.open());
                     ArchiveReader bReader = this.bPath.getFormat().createReader(this.bPath.open());){
                    this.doDiff(patches, summary, aReader.getEntries(), bReader.getEntries(), aReader::readLines, bReader::readLines, this.context, this.autoHeader);
                    break block115;
                }
            }
            if (!this.aPath.isFile() && !this.bPath.isFile()) {
                aIndex = Utils.indexChildren(this.aPath.toPath());
                Map<String, Path> bIndex2 = Utils.indexChildren(this.bPath.toPath());
                this.doDiff(patches, summary, aIndex.keySet(), bIndex2.keySet(), e -> Files.readAllLines((Path)aIndex.get(e)), e -> Files.readAllLines((Path)bIndex2.get(e)), this.context, this.autoHeader);
            } else {
                Iterator<Map.Entry<String, List<String>>> bFunc;
                Object reader;
                LinesReader aFunc;
                if (!this.aPath.isFile()) {
                    if (this.bPath.getFormat() == null) {
                        this.log("Err: File B is in an unknown format, whilst File A is a directory.", new Object[0]);
                        this.printHelp();
                        return new CliOperation.Result<DiffSummary>(-1);
                    }
                    Map<String, Path> map = Utils.indexChildren(this.aPath.toPath());
                    aIndex = map.keySet();
                    aFunc = e -> Files.readAllLines((Path)pathIndex.get(e));
                    reader = this.bPath.getFormat().createReader(this.bPath.open());
                    Throwable throwable = null;
                    try {
                        bIndex = reader.getEntries();
                        bFunc = ((ArchiveReader)reader)::readLines;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                if (this.aPath.getFormat() == null) {
                    this.log("Err: File A is in an unknown format, whilst File B is a directory.", new Object[0]);
                    this.printHelp();
                    return new CliOperation.Result<DiffSummary>(-1);
                }
                ArchiveReader archiveReader = this.aPath.getFormat().createReader(this.aPath.open());
                reader = null;
                try {
                    aIndex = archiveReader.getEntries();
                    aFunc = archiveReader::readLines;
                }
                catch (Throwable throwable) {
                    reader = throwable;
                    throw throwable;
                }
                finally {
                    if (archiveReader != null) {
                        if (reader != null) {
                            try {
                                archiveReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)reader).addSuppressed(throwable);
                            }
                        } else {
                            archiveReader.close();
                        }
                    }
                }
                Map<String, Path> map = Utils.indexChildren(this.bPath.toPath());
                bIndex = map.keySet();
                bFunc = e -> Files.readAllLines((Path)pathIndex.get(e));
                this.doDiff(patches, summary, aIndex, (Set<String>)bIndex, aFunc, (LinesReader)((Object)bFunc), this.context, this.autoHeader);
            }
        }
        boolean changes = false;
        if (!patches.isEmpty()) {
            changes = true;
            if (this.outputPath.getType().isPipe() && this.outputPath.getFormat() == null) {
                PrintWriter out = new PrintWriter(this.outputPath.open());
                bIndex = null;
                try {
                    for (List list : patches.values()) {
                        list.forEach(out::println);
                    }
                }
                catch (Throwable bFunc) {
                    bIndex = bFunc;
                    throw bFunc;
                }
                finally {
                    if (out != null) {
                        if (bIndex != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable bFunc) {
                                ((Throwable)bIndex).addSuppressed(bFunc);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            } else if (this.outputPath.getFormat() != null) {
                ArchiveWriter writer = this.outputPath.getFormat().createWriter(this.outputPath.open());
                bIndex = null;
                try {
                    for (Map.Entry<String, List<String>> entry : patches.get().entrySet()) {
                        String patchFile = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)entry.getValue()) + "\n";
                        writer.writeEntry(entry.getKey(), patchFile.getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (Throwable bFunc) {
                    bIndex = bFunc;
                    throw bFunc;
                }
                finally {
                    if (writer != null) {
                        if (bIndex != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable bFunc) {
                                ((Throwable)bIndex).addSuppressed(bFunc);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            } else {
                if (Files.exists(this.outputPath.toPath(), new LinkOption[0])) {
                    Utils.deleteFolder(this.outputPath.toPath());
                }
                for (Map.Entry<String, List<String>> entry : patches.get().entrySet()) {
                    Path path = this.outputPath.toPath().resolve(entry.getKey());
                    Files.write(Utils.makeParentDirs(path), (Iterable<? extends CharSequence>)entry.getValue(), new OpenOption[0]);
                }
            }
        }
        if (this.summary) {
            summary.print(this.logger, false);
        }
        return new CliOperation.Result<DiffSummary>(changes ? 1 : 0, summary);
    }

    public void doDiff(FileCollector patches, DiffSummary summary, Set<String> aEntries, Set<String> bEntries, LinesReader aFunc, LinesReader bFunc, int context, boolean autoHeader) {
        String aName;
        List<String> patchLines;
        List<String> bLines;
        List<String> aLines;
        List added = bEntries.stream().filter(e -> !aEntries.contains(e)).sorted().collect(Collectors.toList());
        List common = aEntries.stream().filter(bEntries::contains).sorted().collect(Collectors.toList());
        List removed = aEntries.stream().filter(e -> !bEntries.contains(e)).sorted().collect(Collectors.toList());
        for (String file : added) {
            try {
                String bName = 'b' + Utils.ensureStartsWith('/', file);
                aLines = Collections.emptyList();
                bLines = bFunc.apply(file);
                patchLines = this.doDiff(summary, null, bName, aLines, bLines, context, autoHeader);
                if (!patchLines.isEmpty()) {
                    ++summary.addedFiles;
                    patches.consume(file + ".patch", patchLines);
                    continue;
                }
                ++summary.unchangedFiles;
            }
            catch (IOException e2) {
                this.verbose("Failed to read file: %s", file);
            }
        }
        for (String file : common) {
            try {
                aName = 'a' + Utils.ensureStartsWith('/', file);
                String bName = 'b' + Utils.ensureStartsWith('/', file);
                List<String> aLines2 = aFunc.apply(file);
                List<String> bLines2 = bFunc.apply(file);
                List<String> patchLines2 = this.doDiff(summary, aName, bName, aLines2, bLines2, context, autoHeader);
                if (!patchLines2.isEmpty()) {
                    ++summary.changedFiles;
                    patches.consume(file + ".patch", patchLines2);
                    continue;
                }
                ++summary.unchangedFiles;
            }
            catch (IOException e3) {
                this.verbose("Failed to read file: %s", file);
            }
        }
        for (String file : removed) {
            try {
                aName = 'a' + Utils.ensureStartsWith('/', file);
                aLines = aFunc.apply(file);
                bLines = Collections.emptyList();
                patchLines = this.doDiff(summary, aName, null, aLines, bLines, context, autoHeader);
                if (!patchLines.isEmpty()) {
                    ++summary.removedFiles;
                    patches.consume(file + ".patch", patchLines);
                    continue;
                }
                ++summary.unchangedFiles;
            }
            catch (IOException e4) {
                this.verbose("Failed to read file: %s", file);
            }
        }
    }

    public List<String> doDiff(DiffSummary summary, String aName, String bName, List<String> aLines, List<String> bLines, int context, boolean autoHeader) {
        PatienceDiffer differ = new PatienceDiffer();
        PatchFile patchFile = new PatchFile();
        patchFile.basePath = aName != null ? aName : "/dev/null";
        String string = patchFile.patchedPath = bName != null ? bName : "/dev/null";
        patchFile.patches = aLines.isEmpty() ? Differ.makeFileAdded(bLines) : (bLines.isEmpty() ? Differ.makeFileRemoved(aLines) : differ.makePatches(aLines, bLines, context, true));
        if (patchFile.patches.isEmpty()) {
            if (this.verbose) {
                this.verbose("%s -> %s\n No changes.", aName, bName);
            }
            return Collections.emptyList();
        }
        if (this.verbose || this.summary) {
            long added = patchFile.patches.stream().flatMap(e -> e.diffs.stream()).filter(e -> e.op == Operation.INSERT).count();
            long removed = patchFile.patches.stream().flatMap(e -> e.diffs.stream()).filter(e -> e.op == Operation.DELETE).count();
            if (this.summary) {
                summary.addedLines += added;
                summary.removedLines += removed;
            }
            if (this.verbose) {
                this.verbose("%s -> %s\n %d Added.\n %d Removed.", aName, bName, added, removed);
            }
        }
        return patchFile.toLines(autoHeader);
    }

    public static class Builder {
        private static final Consumer<PrintStream> NULL_CALLBACK = e -> {};
        private static final PrintStream NULL_STREAM = new PrintStream(NullOutputStream.INSTANCE);
        private PrintStream logger = NULL_STREAM;
        private Consumer<PrintStream> helpCallback = NULL_CALLBACK;
        private boolean verbose;
        private boolean summary;
        private InputPath aPath;
        private InputPath bPath;
        private boolean autoHeader;
        private int context = 3;
        private OutputPath outputPath;

        private Builder() {
        }

        public Builder logTo(PrintStream logger) {
            this.logger = Objects.requireNonNull(logger);
            return this;
        }

        public Builder logTo(OutputStream logger) {
            return this.logTo(new PrintStream(logger));
        }

        public Builder helpCallback(Consumer<PrintStream> helpCallback) {
            this.helpCallback = Objects.requireNonNull(helpCallback);
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder summary(boolean summary) {
            this.summary = summary;
            return this;
        }

        public Builder aPath(InputPath aPath) {
            if (this.aPath != null) {
                throw new IllegalStateException("Unable to replace aPath.");
            }
            this.aPath = Objects.requireNonNull(aPath);
            return this;
        }

        public Builder aPath(Path aPath) {
            return this.aPath(aPath, ArchiveFormat.findFormat(aPath.getFileName()));
        }

        public Builder aPath(Path aPath, ArchiveFormat format) {
            return this.aPath(new InputPath.FilePath(Objects.requireNonNull(aPath), format, new OpenOption[0]));
        }

        public Builder aPath(byte[] aPath, ArchiveFormat format) {
            ByteArrayInputStream is = new ByteArrayInputStream(Objects.requireNonNull(aPath));
            return this.aPath(new InputPath.PipePath(is, Objects.requireNonNull(format)));
        }

        public Builder bPath(InputPath bPath) {
            if (this.bPath != null) {
                throw new IllegalStateException("Unable to replace bPath.");
            }
            this.bPath = Objects.requireNonNull(bPath);
            return this;
        }

        public Builder bPath(Path bPath) {
            return this.bPath(bPath, ArchiveFormat.findFormat(bPath.getFileName()));
        }

        public Builder bPath(Path bPath, ArchiveFormat format) {
            return this.bPath(new InputPath.FilePath(Objects.requireNonNull(bPath), format, new OpenOption[0]));
        }

        public Builder bPath(byte[] bPath, ArchiveFormat format) {
            ByteArrayInputStream is = new ByteArrayInputStream(Objects.requireNonNull(bPath));
            return this.bPath(new InputPath.PipePath(is, Objects.requireNonNull(format)));
        }

        public Builder autoHeader(boolean autoHeader) {
            this.autoHeader = autoHeader;
            return this;
        }

        public Builder context(int context) {
            this.context = context;
            return this;
        }

        public Builder outputPath(OutputPath outputPath) {
            this.outputPath = Objects.requireNonNull(outputPath);
            return this;
        }

        public Builder outputPath(Path output) {
            return this.outputPath(output, ArchiveFormat.findFormat(output.getFileName()));
        }

        public Builder outputPath(Path output, ArchiveFormat format) {
            return this.outputPath(new OutputPath.FilePath(Objects.requireNonNull(output), format, new OpenOption[0]));
        }

        public Builder outputPath(OutputStream output, ArchiveFormat format) {
            return this.outputPath(new OutputPath.PipePath(Objects.requireNonNull(output), Objects.requireNonNull(format)));
        }

        public DiffOperation build() {
            if (this.aPath == null) {
                throw new IllegalStateException("aPath not set.");
            }
            if (this.bPath == null) {
                throw new IllegalStateException("bPath not set.");
            }
            if (this.outputPath == null) {
                throw new IllegalStateException("output not set.");
            }
            return new DiffOperation(this.logger, this.helpCallback, this.verbose, this.summary, this.aPath, this.bPath, this.autoHeader, this.context, this.outputPath);
        }
    }

    private static interface LinesReader {
        public List<String> apply(String var1) throws IOException;
    }

    public static class DiffSummary {
        public int unchangedFiles;
        public int addedFiles;
        public int changedFiles;
        public int removedFiles;
        public long addedLines;
        public long removedLines;

        public void print(PrintStream logger, boolean slim) {
            logger.println("Diff Summary:");
            if (!slim) {
                logger.println(" UnChanged files: " + this.unchangedFiles);
                logger.println(" Added files:     " + this.addedFiles);
                logger.println(" Changed files:   " + this.changedFiles);
                logger.println(" Removed files:   " + this.removedFiles);
            }
            logger.println(" Added lines:     " + this.addedLines);
            logger.println(" Removed lines:   " + this.removedLines);
        }
    }
}

