/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.util.archiver;

import codechicken.diffpatch.util.Utils;
import codechicken.diffpatch.util.archiver.ArchiveReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;

public class ArchiveInputStreamReader
implements ArchiveReader {
    private final Map<String, byte[]> archiveIndex = new HashMap<String, byte[]>();
    private final ArchiveInputStream is;

    public ArchiveInputStreamReader(ArchiveInputStream is, String prefix) {
        this.is = is;
        try {
            ArchiveEntry entry;
            while ((entry = is.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = Utils.stripStart('/', entry.getName());
                if (!prefix.isEmpty() && !entry.getName().startsWith(prefix)) continue;
                this.archiveIndex.put(Utils.stripStart('/', name.substring(prefix.length())), Utils.toBytes((InputStream)is));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to index archive", e);
        }
    }

    @Override
    public Set<String> getEntries() {
        return Collections.unmodifiableSet(this.archiveIndex.keySet());
    }

    @Override
    public byte[] getBytes(String entry) {
        return this.archiveIndex.get(entry);
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

