/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch;

import codechicken.diffpatch.cli.ArchiveFormatValueConverter;
import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.DiffOperation;
import codechicken.diffpatch.cli.PatchModeValueConverter;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.InputPath;
import codechicken.diffpatch.util.OutputPath;
import codechicken.diffpatch.util.PatchMode;
import codechicken.diffpatch.util.Utils;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;

public class DiffPatch {
    public static void main(String[] args) throws IOException {
        System.exit(DiffPatch.mainI(args, System.err, System.out));
    }

    public static int mainI(String[] args, PrintStream logger, PrintStream pipe) throws IOException {
        CliOperation operation;
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec nonOptions = parser.nonOptions();
        AbstractOptionSpec helpOpt = parser.acceptsAll(Arrays.asList("h", "help"), "Prints this help.").forHelp();
        OptionSpecBuilder verboseOpt = parser.acceptsAll(Arrays.asList("v", "verbose"), "Prints more stuff.");
        OptionSpecBuilder summaryOpt = parser.acceptsAll(Arrays.asList("s", "summary"), "Prints a changes summary at the end.");
        OptionSpecBuilder doDiffOpt = parser.acceptsAll(Arrays.asList("d", "diff"), "Does a Diff operation.");
        OptionSpecBuilder autoHeaderOpt = parser.acceptsAll(Arrays.asList("h", "auto-header"), "Enables the generation of auto-headers. Using _ as the start2 index.").availableIf((OptionSpec)doDiffOpt, new OptionSpec[0]);
        ArgumentAcceptingOptionSpec contextOpt = parser.acceptsAll(Arrays.asList("c", "context"), "Number of context lines to generate in diffs.").availableIf((OptionSpec)doDiffOpt, new OptionSpec[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)3, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec outputOpt = parser.acceptsAll(Arrays.asList("o", "output"), "Sets the output path.").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec archiveOpt = parser.acceptsAll(Arrays.asList("A", "archive"), "Treat output as an archive. Allows printing multi-output to STDOUT.").withRequiredArg().withValuesConvertedBy((ValueConverter)new ArchiveFormatValueConverter());
        OptionSpecBuilder doPatchOpt = parser.acceptsAll(Arrays.asList("p", "patch"), "Does a Patch operation.");
        ArgumentAcceptingOptionSpec rejectOpt = parser.acceptsAll(Arrays.asList("r", "reject"), "Saves patch rejects to the specified path / archive").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec rejectArchiveOpt = parser.acceptsAll(Arrays.asList("H", "archive-rejects"), "Treat reject output as an archive.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new ArchiveFormatValueConverter());
        ArgumentAcceptingOptionSpec fuzzOpt = parser.acceptsAll(Arrays.asList("f", "fuzz"), "The minimum fuzz match quality, anything lower will be treated as a failure.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(Float.class).defaultsTo((Object)Float.valueOf(0.5f), (Object[])new Float[0]);
        ArgumentAcceptingOptionSpec offsetOpt = parser.acceptsAll(Arrays.asList("O", "offset"), "The max line offset allowed for fuzzy matching, larger than this will be treated as a failure.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)5, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec modeOpt = parser.acceptsAll(Arrays.asList("m", "mode"), "The desired patching mode.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PatchModeValueConverter()).defaultsTo((Object)PatchMode.EXACT, (Object[])new PatchMode[0]);
        ArgumentAcceptingOptionSpec patchPrefix = parser.acceptsAll(Arrays.asList("P", "prefix"), "Prefix path for reading patches from patches input.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        OptionSet optSet = parser.parse(args);
        if (optSet.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)logger);
            return -1;
        }
        boolean verbose = optSet.has((OptionSpec)verboseOpt);
        boolean summary = optSet.has((OptionSpec)summaryOpt);
        List arguments = optSet.valuesOf((OptionSpec)nonOptions);
        if (arguments.size() != 2) {
            logger.println("Expected 2 arguments, got: " + arguments.size());
            parser.printHelpOn((OutputStream)logger);
            return -1;
        }
        if (optSet.has((OptionSpec)doDiffOpt)) {
            Path a = Paths.get((String)arguments.get(0), new String[0]);
            Path b = Paths.get((String)arguments.get(1), new String[0]);
            Path output = (Path)optSet.valueOf((OptionSpec)outputOpt);
            ArchiveFormat outputFormat = (ArchiveFormat)((Object)optSet.valueOf((OptionSpec)archiveOpt));
            if (outputFormat == null && output != null) {
                outputFormat = ArchiveFormat.findFormat(output.getFileName());
            }
            InputPath.FilePath aPath = new InputPath.FilePath(a, ArchiveFormat.findFormat(a.getFileName()), new OpenOption[0]);
            InputPath.FilePath bPath = new InputPath.FilePath(b, ArchiveFormat.findFormat(b.getFileName()), new OpenOption[0]);
            OutputPath outputPath = output != null ? new OutputPath.FilePath(output, outputFormat, new OpenOption[0]) : new OutputPath.PipePath(pipe, outputFormat);
            boolean autoHeader = optSet.has((OptionSpec)autoHeaderOpt);
            int context = (Integer)optSet.valueOf((OptionSpec)contextOpt);
            operation = new DiffOperation(logger, pipe, Utils.sneakC(arg_0 -> ((OptionParser)parser).printHelpOn(arg_0)), verbose, summary, aPath, bPath, autoHeader, context, outputPath);
        } else if (optSet.has((OptionSpec)doPatchOpt)) {
            Path base = Paths.get((String)arguments.get(0), new String[0]);
            Path patches = Paths.get((String)arguments.get(1), new String[0]);
            Path output = (Path)optSet.valueOf((OptionSpec)outputOpt);
            Path rejects = (Path)optSet.valueOf((OptionSpec)rejectOpt);
            ArchiveFormat outputFormat = (ArchiveFormat)((Object)optSet.valueOf((OptionSpec)archiveOpt));
            ArchiveFormat rejectsFormat = (ArchiveFormat)((Object)optSet.valueOf((OptionSpec)rejectArchiveOpt));
            if (outputFormat == null && output != null) {
                outputFormat = ArchiveFormat.findFormat(output.getFileName());
            }
            if (rejectsFormat == null && rejects != null) {
                rejectsFormat = ArchiveFormat.findFormat(rejects.getFileName());
            }
            InputPath.FilePath basePath = new InputPath.FilePath(base, ArchiveFormat.findFormat(base.getFileName()), new OpenOption[0]);
            InputPath.FilePath patchesPath = new InputPath.FilePath(patches, ArchiveFormat.findFormat(patches.getFileName()), new OpenOption[0]);
            OutputPath outputPath = output != null ? new OutputPath.FilePath(output, outputFormat, new OpenOption[0]) : new OutputPath.PipePath(pipe, outputFormat);
            OutputPath.FilePath rejectsPath = new OutputPath.FilePath(rejects, rejectsFormat, new OpenOption[0]);
            float minFuzz = ((Float)optSet.valueOf((OptionSpec)fuzzOpt)).floatValue();
            int maxOffset = (Integer)optSet.valueOf((OptionSpec)offsetOpt);
            PatchMode mode = (PatchMode)((Object)optSet.valueOf((OptionSpec)modeOpt));
            String prefix = (String)optSet.valueOf((OptionSpec)patchPrefix);
            operation = new PatchOperation(logger, Utils.sneakC(arg_0 -> ((OptionParser)parser).printHelpOn(arg_0)), verbose, summary, basePath, patchesPath, outputPath, rejectsPath, minFuzz, maxOffset, mode, prefix);
        } else {
            logger.println("Expected --diff or --patch.");
            parser.printHelpOn((OutputStream)logger);
            return -1;
        }
        return ((CliOperation)operation).operate();
    }
}

