/*
 * Decompiled with CFR 0.152.
 */
package codechicken.diffpatch.cli;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.diff.Differ;
import codechicken.diffpatch.diff.PatienceDiffer;
import codechicken.diffpatch.util.FileCollector;
import codechicken.diffpatch.util.InputPath;
import codechicken.diffpatch.util.Operation;
import codechicken.diffpatch.util.OutputPath;
import codechicken.diffpatch.util.PatchFile;
import codechicken.diffpatch.util.Utils;
import codechicken.diffpatch.util.archiver.ArchiveReader;
import codechicken.diffpatch.util.archiver.ArchiveWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DiffOperation
extends CliOperation {
    private final boolean summary;
    private final InputPath aPath;
    private final InputPath bPath;
    private final boolean autoHeader;
    private final int context;
    private final OutputPath outputPath;

    public DiffOperation(PrintStream logger, PrintStream pipe, Consumer<PrintStream> helpCallback, boolean verbose, boolean summary, InputPath aPath, InputPath bPath, boolean autoHeader, int context, OutputPath outputPath) {
        super(logger, helpCallback, verbose);
        this.summary = summary;
        this.aPath = aPath;
        this.bPath = bPath;
        this.autoHeader = autoHeader;
        this.context = context;
        this.outputPath = outputPath;
    }

    @Override
    public int operate() throws IOException {
        Object bIndex;
        DiffSummary summary;
        FileCollector patches;
        block115: {
            Set<String> aIndex;
            if (this.aPath.getType().isPath() && Files.notExists(this.aPath.toPath(), new LinkOption[0])) {
                this.log("Err: File A doesn't exist.", new Object[0]);
                return -1;
            }
            if (this.aPath.getType().isPath() && Files.notExists(this.bPath.toPath(), new LinkOption[0])) {
                this.log("Err: File B doesn't exist.", new Object[0]);
                return -1;
            }
            patches = new FileCollector();
            summary = new DiffSummary();
            if (this.aPath.isFile() && this.bPath.isFile() && this.aPath.getFormat() == null && this.bPath.getFormat() == null) {
                if (this.outputPath.getFormat() != null) {
                    this.log("Err: Can't specify output format when diffing regular files.", new Object[0]);
                    this.printHelp();
                    return -1;
                }
                if (this.outputPath.getType().isPath() && Files.exists(this.outputPath.toPath(), new LinkOption[0]) && !Files.isRegularFile(this.outputPath.toPath(), new LinkOption[0])) {
                    this.log("Err: Output already exists and is not a file.", new Object[0]);
                    this.printHelp();
                    return -1;
                }
                List<String> lines = this.doDiff(summary, this.aPath.toString(), this.bPath.toString(), this.aPath.readAllLines(), this.bPath.readAllLines(), this.context, this.autoHeader);
                boolean changes = false;
                if (!lines.isEmpty()) {
                    changes = true;
                    try (PrintWriter out = new PrintWriter(this.outputPath.open());){
                        out.println(String.join((CharSequence)"\n", lines) + "\n");
                    }
                }
                if (this.summary) {
                    summary.print(this.logger, true);
                }
                return changes ? 1 : 0;
            }
            if (this.outputPath.getType().isPath()) {
                if (this.outputPath.getFormat() != null) {
                    if (Files.exists(this.outputPath.toPath(), new LinkOption[0]) && !Files.isRegularFile(this.outputPath.toPath(), new LinkOption[0])) {
                        this.log("Err: Output already exists and is not a file.", new Object[0]);
                        this.printHelp();
                        return -1;
                    }
                } else if (this.outputPath != null && Files.exists(this.outputPath.toPath(), new LinkOption[0]) && !Files.isDirectory(this.outputPath.toPath(), new LinkOption[0])) {
                    this.log("Err: Output already exists and is not a directory.", new Object[0]);
                    this.printHelp();
                    return -1;
                }
            }
            if (this.aPath.isFile() && this.bPath.isFile()) {
                if (this.aPath.getFormat() == null) {
                    this.log("Err: File A is in an unknown archive format.", new Object[0]);
                    this.printHelp();
                    return -1;
                }
                if (this.bPath.getFormat() == null) {
                    this.log("Err: File B is in an unknown archive format.", new Object[0]);
                    this.printHelp();
                    return -1;
                }
                try (ArchiveReader aReader = this.aPath.getFormat().createReader(this.aPath.open());
                     ArchiveReader bReader = this.bPath.getFormat().createReader(this.bPath.open());){
                    this.doDiff(patches, summary, aReader.getEntries(), bReader.getEntries(), Utils.sneakF(aReader::readLines), Utils.sneakF(bReader::readLines), this.context, this.autoHeader);
                    break block115;
                }
            }
            if (!this.aPath.isFile() && !this.bPath.isFile()) {
                aIndex = Utils.indexChildren(this.aPath.toPath());
                Map<String, Path> bIndex2 = Utils.indexChildren(this.bPath.toPath());
                this.doDiff(patches, summary, aIndex.keySet(), bIndex2.keySet(), Utils.sneakF(e -> Files.readAllLines((Path)aIndex.get(e))), Utils.sneakF(e -> Files.readAllLines((Path)bIndex2.get(e))), this.context, this.autoHeader);
            } else {
                Iterator<Map.Entry<String, List<String>>> bFunc;
                Object reader;
                Function<String, List<String>> aFunc;
                if (!this.aPath.isFile()) {
                    if (this.bPath.getFormat() == null) {
                        this.log("Err: File B is in an unknown format, whilst File A is a directory.", new Object[0]);
                        this.printHelp();
                        return -1;
                    }
                    Map<String, Path> map = Utils.indexChildren(this.aPath.toPath());
                    aIndex = map.keySet();
                    aFunc = Utils.sneakF(e -> Files.readAllLines((Path)pathIndex.get(e)));
                    reader = this.bPath.getFormat().createReader(this.bPath.open());
                    Throwable throwable = null;
                    try {
                        bIndex = reader.getEntries();
                        bFunc = Utils.sneakF(((ArchiveReader)reader)::readLines);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                if (this.aPath.getFormat() == null) {
                    this.log("Err: File A is in an unknown format, whilst File B is a directory.", new Object[0]);
                    this.printHelp();
                    return -1;
                }
                ArchiveReader archiveReader = this.aPath.getFormat().createReader(this.aPath.open());
                reader = null;
                try {
                    aIndex = archiveReader.getEntries();
                    aFunc = Utils.sneakF(archiveReader::readLines);
                }
                catch (Throwable throwable) {
                    reader = throwable;
                    throw throwable;
                }
                finally {
                    if (archiveReader != null) {
                        if (reader != null) {
                            try {
                                archiveReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)reader).addSuppressed(throwable);
                            }
                        } else {
                            archiveReader.close();
                        }
                    }
                }
                Map<String, Path> map = Utils.indexChildren(this.bPath.toPath());
                bIndex = map.keySet();
                bFunc = Utils.sneakF(e -> Files.readAllLines((Path)pathIndex.get(e)));
                this.doDiff(patches, summary, aIndex, (Set<String>)bIndex, aFunc, (Function<String, List<String>>)((Object)bFunc), this.context, this.autoHeader);
            }
        }
        boolean changes = false;
        if (!patches.isEmpty()) {
            changes = true;
            if (this.outputPath.getType().isPipe() && this.outputPath.getFormat() == null) {
                PrintWriter out = new PrintWriter(this.outputPath.open());
                bIndex = null;
                try {
                    for (List list : patches.values()) {
                        list.forEach(out::println);
                    }
                }
                catch (Throwable bFunc) {
                    bIndex = bFunc;
                    throw bFunc;
                }
                finally {
                    if (out != null) {
                        if (bIndex != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable bFunc) {
                                ((Throwable)bIndex).addSuppressed(bFunc);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            } else if (this.outputPath.getFormat() != null) {
                ArchiveWriter writer = this.outputPath.getFormat().createWriter(this.outputPath.open());
                bIndex = null;
                try {
                    for (Map.Entry<String, List<String>> entry : patches.get().entrySet()) {
                        String patchFile = String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)entry.getValue()) + "\n";
                        writer.writeEntry(entry.getKey(), patchFile.getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (Throwable bFunc) {
                    bIndex = bFunc;
                    throw bFunc;
                }
                finally {
                    if (writer != null) {
                        if (bIndex != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable bFunc) {
                                ((Throwable)bIndex).addSuppressed(bFunc);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            } else {
                if (Files.exists(this.outputPath.toPath(), new LinkOption[0])) {
                    Utils.deleteFolder(this.outputPath.toPath());
                }
                for (Map.Entry<String, List<String>> entry : patches.get().entrySet()) {
                    Path path = this.outputPath.toPath().resolve(entry.getKey());
                    Files.write(Utils.makeParentDirs(path), (Iterable<? extends CharSequence>)entry.getValue(), new OpenOption[0]);
                }
            }
        }
        if (this.summary) {
            summary.print(this.logger, false);
        }
        return changes ? 1 : 0;
    }

    public void doDiff(FileCollector patches, DiffSummary summary, Set<String> aEntries, Set<String> bEntries, Function<String, List<String>> aFunc, Function<String, List<String>> bFunc, int context, boolean autoHeader) {
        String aName;
        List<String> patchLines;
        List<String> bLines;
        List<String> aLines;
        List added = bEntries.stream().filter(e -> !aEntries.contains(e)).sorted().collect(Collectors.toList());
        List common = aEntries.stream().filter(bEntries::contains).sorted().collect(Collectors.toList());
        List removed = aEntries.stream().filter(e -> !bEntries.contains(e)).sorted().collect(Collectors.toList());
        for (String file : added) {
            String bName = 'b' + Utils.ensureStartsWith('/', file);
            patchLines = this.doDiff(summary, null, bName, aLines = Collections.emptyList(), bLines = bFunc.apply(file), context, autoHeader);
            if (!patchLines.isEmpty()) {
                ++summary.addedFiles;
                patches.consume(file + ".patch", patchLines);
                continue;
            }
            ++summary.unchangedFiles;
        }
        for (String file : common) {
            List<String> bLines2;
            List<String> aLines2;
            String bName;
            aName = 'a' + Utils.ensureStartsWith('/', file);
            List<String> patchLines2 = this.doDiff(summary, aName, bName = 'b' + Utils.ensureStartsWith('/', file), aLines2 = aFunc.apply(file), bLines2 = bFunc.apply(file), context, autoHeader);
            if (!patchLines2.isEmpty()) {
                ++summary.changedFiles;
                patches.consume(file + ".patch", patchLines2);
                continue;
            }
            ++summary.unchangedFiles;
        }
        for (String file : removed) {
            aName = 'a' + Utils.ensureStartsWith('/', file);
            patchLines = this.doDiff(summary, aName, null, aLines = aFunc.apply(file), bLines = Collections.emptyList(), context, autoHeader);
            if (!patchLines.isEmpty()) {
                ++summary.removedFiles;
                patches.consume(file + ".patch", patchLines);
                continue;
            }
            ++summary.unchangedFiles;
        }
    }

    public List<String> doDiff(DiffSummary summary, String aName, String bName, List<String> aLines, List<String> bLines, int context, boolean autoHeader) {
        PatienceDiffer differ = new PatienceDiffer();
        PatchFile patchFile = new PatchFile();
        patchFile.basePath = aName != null ? aName : "/dev/null";
        String string = patchFile.patchedPath = bName != null ? bName : "/dev/null";
        patchFile.patches = aLines.isEmpty() ? Differ.makeFileAdded(bLines) : (bLines.isEmpty() ? Differ.makeFileRemoved(aLines) : differ.makePatches(aLines, bLines, context, true));
        if (patchFile.patches.isEmpty()) {
            if (this.verbose) {
                this.verbose("%s -> %s\n No changes.", aName, bName);
            }
            return Collections.emptyList();
        }
        if (this.verbose || this.summary) {
            long added = patchFile.patches.stream().flatMap(e -> e.diffs.stream()).filter(e -> e.op == Operation.INSERT).count();
            long removed = patchFile.patches.stream().flatMap(e -> e.diffs.stream()).filter(e -> e.op == Operation.DELETE).count();
            if (this.summary) {
                summary.addedLines += added;
                summary.removedLines += removed;
            }
            if (this.verbose) {
                this.verbose("%s -> %s\n %d Added.\n %d Removed.", aName, bName, added, removed);
            }
        }
        return patchFile.toLines(autoHeader);
    }

    private static class DiffSummary {
        public int unchangedFiles;
        public int addedFiles;
        public int changedFiles;
        public int removedFiles;
        public long addedLines;
        public long removedLines;

        private DiffSummary() {
        }

        public void print(PrintStream logger, boolean slim) {
            logger.println("Diff Summary:");
            if (!slim) {
                logger.println(" UnChanged files: " + this.unchangedFiles);
                logger.println(" Added files:     " + this.addedFiles);
                logger.println(" Changed files:   " + this.changedFiles);
                logger.println(" Removed files:   " + this.removedFiles);
            }
            logger.println(" Added lines:     " + this.addedLines);
            logger.println(" Removed lines:   " + this.removedLines);
        }
    }
}

