/*
 * Decompiled with CFR 0.152.
 */
package io.cloudslang.lang.cli.utils;

import io.cloudslang.lang.api.Slang;
import io.cloudslang.lang.cli.utils.MetadataHelper;
import io.cloudslang.lang.compiler.SlangSource;
import io.cloudslang.lang.compiler.modeller.model.Metadata;
import java.io.File;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetadataHelperImpl
implements MetadataHelper {
    private static final String NO_METADATA_TO_DISPLAY = "No metadata to display.";
    @Autowired
    private Slang slang;

    @Override
    public String extractMetadata(File file) {
        Validate.notNull((Object)file, (String)"File can not be null");
        Validate.notNull((Object)file.getAbsolutePath(), (String)"File path can not be null");
        Validate.isTrue((boolean)file.isFile(), (String)("File: " + file.getName() + " was not found"));
        Metadata metadata = this.slang.extractMetadata(SlangSource.fromFile((File)file));
        return this.prettyPrint(metadata);
    }

    private String prettyPrint(Metadata metadata) {
        if (this.emptyMetadata(metadata)) {
            return NO_METADATA_TO_DISPLAY;
        }
        return metadata.prettyPrint();
    }

    private boolean emptyMetadata(Metadata metadata) {
        return "".equals(metadata.getDescription()) && "".equals(metadata.getPrerequisites()) && metadata.getInputs().size() == 0 && metadata.getOutputs().size() == 0 && metadata.getResults().size() == 0;
    }
}

